using System;
using System.IO;
using System.Collections;
using System.Text;

namespace LapperServer
{
    class LFSServers
    {
        static public int getRemotePort()
        {

            int remotePort = 3000;

            if (!File.Exists("LFSServers.cfg"))
            {
                throw (new System.Exception("Error LFSServers.cfg config file do not exist!"));
            }
            {
                StreamReader sr = new StreamReader("LFSServers.cfg");
                while (!sr.EndOfStream)
                {

                    string line = sr.ReadLine();
                    if (line.Trim() == "")
                        continue;
                    if (line[0] == '#')
                        continue;
                    if (line.ToLower().IndexOf("remoteport") == 0)
                    {
                        try
                        {
                            string[] par = line.Split('=');
                            remotePort = int.Parse(par[1].Replace(';', ' ').Trim());
                        }
                        catch
                        {
                            throw (new System.Exception("Error in LFSServers.cfg on remote port"));
                        }
                        continue;
                    }
                }
                sr.Close();
            }
            return remotePort;

        }

    }

}
