using System;
using System.Collections;
using System.Text;

namespace LFSLapper
{
    class ZoneEvent
    {
        public int x1, y1, dist;
        public string command = "";
        public ZoneEvent(int px1, int py1,int pdist, string pcommand)
        {
            this.x1 = px1;
            this.y1 = py1;
            this.dist = pdist;

            command = pcommand;
        }
    }
    class ListZoneEvent
    {
        System.Collections.Hashtable listOfZones = new System.Collections.Hashtable();

        public void Add(string trackName, int x1, int y1, int dist, string command)
        {
            if (!listOfZones.ContainsKey(trackName))
            {
                listOfZones[trackName] = new ArrayList();
            }
            (listOfZones[trackName] as ArrayList).Add( new ZoneEvent(x1,y1,dist, command) );
        }
        public int getMyZone(string trackName, int x, int y)
        {
            if (listOfZones.ContainsKey(trackName))
            {
                ArrayList zones = (ArrayList)listOfZones[trackName];
                for (int i = 0; i < zones.Count; i++)
                {
                    ZoneEvent z = (ZoneEvent)zones[i];
                    int distX = z.x1 - x;
                    int distY = z.y1 - y;
                    int dist = (int)System.Math.Sqrt(distX * distX + distY * distY);
//                    Console.WriteLine(dist);
                    if (dist <= z.dist )
                        return i;
                }
            }
            return -1;
        }
        public string getCommandZone(string trackName, int idx )
        {
            ArrayList zones =(ArrayList)listOfZones[trackName];
            return (zones[idx] as ZoneEvent).command;
        }
    }
}
