/*
    LFSLapper, Insim Utilities for Live For Speed Game
    Copyright (C) 2007  Robert B. alias Gai-Luron and Monkster: lfsgailuron@free.fr

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
using System;
using System.Text;
using System.Collections;
using System.Threading;
using System.IO;
using System.Net;
using System.Net.Cache;
using System.Reflection;
using Configurator;



namespace LapperThreads
{
    public class PubStatUserPB
    {
        public class pbInfo 
        {
            public string track;
            public string car;
            public long split1 = 0;
            public long split2 = 0;
            public long split3 = 0;
            public long lapTime = 0;
            public long lapCount = 0;
            public DateTime datPB;

            public pbInfo(string ptrack, string pcar, long psplit1, long psplit2, long psplit3, long plapTime, long plapCount, long ptimeStamp)
            {
                this.track = ptrack;
                this.car = pcar;
                this.split1 = psplit1;
                this.split2 = psplit2;
                this.split3 = psplit3;
                this.lapTime = plapTime;
                this.lapCount = plapCount;
                this.datPB = UTILS.utils.TimestampToDateTime((double)ptimeStamp);
            }

        }
        private class sortByCar : IComparer
        {
            int IComparer.Compare(object a, object b)
            {
                if (string.Compare((a as pbInfo).car, (b as pbInfo).car) > 0)
                    return 1;
                else if (string.Compare((a as pbInfo).car, (b as pbInfo).car) < 0)
                    return -1;
                else
                {
                    if (string.Compare((a as pbInfo).track, (b as pbInfo).track) > 0)
                        return 1;
                    else if (string.Compare((a as pbInfo).track, (b as pbInfo).track) < 0)
                        return -1;
                    else
                        return 0;
                }
            }
        }
        private class sortByTrack : IComparer
        {
            int IComparer.Compare(object a, object b)
            {
                if (string.Compare((a as pbInfo).track, (b as pbInfo).track) > 0)
                    return 1;
                else if (string.Compare((a as pbInfo).track, (b as pbInfo).track) < 0)
                    return -1;
                else
                {
                    if (string.Compare((a as pbInfo).car, (b as pbInfo).car) > 0)
                        return 1;
                    else if (string.Compare((a as pbInfo).car, (b as pbInfo).car) < 0)
                        return -1;
                    else
                        return 0;
                }
            }
        }
        public Hashtable listOfUserPB = new Hashtable();
        public Queue QuserPb = new Queue(100);
        private GLDebug.Debug myDebug;
        private string PubStatIdk = "";
        public PubStatUserPB(GLDebug.Debug pmyDebug, string pPubStatIdk)
        {
            this.myDebug = pmyDebug;
            this.PubStatIdk = pPubStatIdk;
        }
        public void TPubStatUserPB()
        {
            myDebug.WriteLine("mss","PubStat Thread Started...");
            while (true)
            {
// PB Request, hight priority
                Monitor.Enter(QuserPb);
                if (QuserPb.Count != 0)
                {
                    string user = (string)QuserPb.Dequeue();
                    Monitor.Exit(QuserPb);
                    while (queryUserPb(user) == false)
                        System.Threading.Thread.Sleep(6000);
                    continue;
                }
                else
                {
                    Monitor.Exit(QuserPb);
                }
                System.Threading.Thread.Sleep(100);
            }
        }
        private bool queryUserPb(string userName )
        {
            if (userName == "" || PubStatIdk == "" )
                return true;
            try
            {
                string readLine = "";
                string url = "http://www.lfsworld.net/pubstat/get_stat2.php?version=1.4"
                                + "&idk=" + PubStatIdk 
                                + "&action=pb"
                                + "&racer=" + userName;

                WebRequest req = WebRequest.Create(url);
                req.Timeout = (int)LFSLapper.paramLapper.webTimeOut;

                RequestCachePolicy policy = new RequestCachePolicy(RequestCacheLevel.NoCacheNoStore);
                //                    req.CachePolicy = policy;
                WebResponse result = req.GetResponse();
                Stream receiveStream = result.GetResponseStream();
                ArrayList pbUser = new ArrayList();
                using (StreamReader sr = new StreamReader(receiveStream))
                {
                    string track = "";
                    string car = "";
                    string[] par;
                    long lapTime = 0;
                    while (!sr.EndOfStream)
                    {
                        readLine = sr.ReadLine().Trim();
                        par = readLine.Split(' ');
                        if (par[0] == "can't")
                            return false;
                        if (par[0].ToLower() == "invalid") // Wrong pubstatIdk
                        {
                            PubStatIdk = "";
                            return true;
                        }
                        track = UTILS.utils.convTrack(par[0]);
                        car = par[1];
                        lapTime = long.Parse(par[5]);
                        if( lapTime != 0 ) {
                            pbUser.Add(new pbInfo(track, car
                                                ,long.Parse( par[2] )
                                                ,long.Parse( par[3] )
                                                ,long.Parse( par[4] )
                                                ,lapTime
                                                ,long.Parse( par[6] )
                                                ,long.Parse( par[7] )
                                                ));
//                            Console.WriteLine(readLine);
                        }
                    }
                }
                Monitor.Enter(listOfUserPB);
                pbUser.Sort(new sortByCar());
                listOfUserPB[userName] = pbUser;
                Monitor.Exit(listOfUserPB);
            }
            catch( Exception ex )
            {
                myDebug.WriteLine("err", "Error on retreiving pubstat info");
            }
            return true;

        }
        public void retreiveUserPb(string userName)
        {
            if (userName == "" || PubStatIdk == "" )
                return;
            Monitor.Enter(QuserPb);
            if (QuserPb.Count >= 100)
            {
                myDebug.WriteLine("err", "Error to many request on PB pubstat info");
                PubStatIdk = "";
            }
            QuserPb.Enqueue(userName);
            Monitor.Exit(QuserPb);
        }
        public void removeUserPb(string userName)
        {
            if (userName == "" || PubStatIdk == "")
                return;
            Monitor.Enter(listOfUserPB);
            listOfUserPB.Remove(userName);
            Monitor.Exit(listOfUserPB);
        }
        public ArrayList getUserPb(string userName, string car, string track)
        {
            if (!listOfUserPB.Contains(userName))
                return null;
            ArrayList pbUser = (ArrayList)listOfUserPB[userName];
            ArrayList retPbUser = new ArrayList();
            if (car != "" && track != "")
            {
                for (int i = 0; i < pbUser.Count; i++)
                {
                    if ((pbUser[i] as pbInfo).car == car && (pbUser[i] as pbInfo).track == track )
                    {
                        retPbUser.Add( pbUser[i] );
                        return retPbUser;
                    }
                }
                return retPbUser;
            }
            if (car == "" && track == "")
            {
                pbUser.Sort( new sortByCar() );
                return pbUser;
            }
            if (car == "")
            {
                for (int i = 0; i < pbUser.Count; i++)
                {
                    if ((pbUser[i] as pbInfo).track == track)
                    {
                        retPbUser.Add(pbUser[i]);
                    }
                }
                retPbUser.Sort(new sortByCar());
                return retPbUser;
            }
            if (track == "")
            {
                for (int i = 0; i < pbUser.Count; i++)
                {
                    if ((pbUser[i] as pbInfo).car == car)
                    {
                        retPbUser.Add(pbUser[i]);
                    }
                }
                retPbUser.Sort(new sortByTrack());
                return retPbUser;
            }
            return pbUser;
        }
    }
}
