<?php
	include('lfsworldsdk.php');
	# Function By Victor van Vlaardingen: http://www.lfsforum.net/showthread.php?t=36628
	function codepage_convert($str, $conv_to = 'UTF-8') {
		$sets = array (
			'L' => 'CP1252',
			'G' => 'ISO-8859-7',
			'C' => 'CP1251',
			'E' => 'ISO-8859-2',
			'T' => 'ISO-8859-9',
			'B' => 'ISO-8859-13',
			'J' => 'SJIS-win',
			'S' => 'CP936',
			'K' => 'CP949',
			'H' => 'CP950'
		);
		$tr_ptrn = array ("/\^d/", "/\^s/", "/\^c/", "/\^a/", "/\^q/", "/\^t/", "/\^l/", "/\^r/", "/\^v/");
		$tr_ptrn_r = array ("\\", "/", ":", "*", "?", "\"", "<", ">", "|");
		$str = preg_replace ($tr_ptrn, $tr_ptrn_r, $str);
		$newstr = $tmp = '';
		$current_cp = 'L';
		$len = strlen ($str);
		for ($i=0; $i<$len; $i++) {
			if ($str{$i} == '^' && isset ($sets[$str{$i+1}]) && $str{$i-1} != "^") {
				if ($tmp != '') {
					$newstr .= mb_convert_encoding ($tmp, $conv_to, $sets[$current_cp]);
					$tmp = '';
				}
				$current_cp = $str{++$i};
			} else if (ord($str{$i}) > 31)
				$tmp .= $str{$i};
		}
		if ($tmp != '')
			$newstr .= mb_convert_encoding ($tmp, $conv_to, $sets[$current_cp]);
		return str_replace ('^^', '^', $newstr);
	}
	# Function by D34N0: http://www.lfsforum.net/showthread.php?p=35947#post35947
	# Function Edited by Mark 'Dygear' Tomlin;
	function get_colour($ColourNum) {
		switch ($ColourNum) {
			case 0: return '#000000'; # Black
			case 1: return '#FF0000'; # Red
			case 2: return '#00FF00'; # Green
			case 3: return '#FFFF00'; # Yellow
			case 4:	return '#0000FF'; # Light Blue
			case 5: return '#FF0080'; # Light Purple
			case 6: return '#00FFFF'; # Turquoise
			case 7; return '#FFFFFF'; # White
			case 8: return '#00FF00'; # Pastel Green
		}
	}
	# Function by D34N0: http://www.lfsforum.net/showthread.php?p=35947#post35947
	# Funntion Edited by Mark 'Dygear' Tomlin;
	function format_host_colours($HostName) {
		for ($i = 0; $i < strlen($HostName); $i++) {
			if (substr($HostName, $i, 1) == "^") {
				$CharPos = strpos($HostName, "^", $i);
				$ColNum = substr($HostName, strpos($HostName, "^", $i) + 1,1);
				$ColourString = get_colour(substr($HostName, strpos($HostName, "^", $i) + 1,1));
				if ($i == "0") {
					$TmpString = substr($HostName,$i+2);
					$HostName = "<span style=\"color: {$ColourString}\">{$TmpString}";
				} else {
					$LTmpString = substr($HostName,0,$i);
					$RTmpString = substr($HostName,$i+2);
					$HostName = "{$LTmpString}</span><span style=\"color: {$ColourString}\">{$RTmpString}";
				}
			}
		}
		$HostName = $HostName."</span>";
		return $HostName;
	}
	# Function by Mark 'Dygear' Tomlin;
	function hostToHTML($hostName) {
		return format_host_colours(codepage_convert($hostName));
	}
	# Function by Mark 'Dygear' Tomlin;
	function trackToName($trackCode) {
		switch($trackCode[0]) {
			case 0: $rtn = 'Blackwood ';
				switch($trackCode[1]) {
					case 0: $rtn .= 'GP Track'; break;
					case 1: $rtn .= 'Rally Cross'; break;
					case 2: $rtn .= 'Car Park'; break;
				}
			break;
			case 1: $rtn = 'South City ';
				switch($trackCode[1]) {
					case 0: $rtn .= 'Classic'; break;
					case 1: $rtn .= 'Sprint Track 1'; break;
					case 2: $rtn .= 'Sprint Track 2'; break;
					case 3: $rtn .= 'Long'; break;
					case 4: $rtn .= 'Town Course'; break;
					case 5: $rtn .= 'Chicane Route'; break;
				}
			break;
			case 2: $rtn = 'Fern Bay ';
				switch($trackCode[1]) {
					case 0: $rtn .= 'Club'; break;
					case 1: $rtn .= 'Green Track'; break;
					case 2: $rtn .= 'Gold Track'; break;
					case 3: $rtn .= 'Black Track'; break;
					case 4: $rtn .= 'Rally Cross'; break;
					case 5: $rtn .= 'RallyX Green'; break;
				}
			break;
			case 3: $rtn = 'Autocross ';
				switch($trackCode[1]) {
					case 0: $rtn .= 'Autocross'; break;
					case 1: $rtn .= 'Skid Pad'; break;
					case 2: $rtn .= 'Drag Strip'; break;
					case 3: $rtn .= '8 Lane Drag'; break;
				}
			break;
			case 4: $rtn = 'Kyoto Ring ';
				switch($trackCode[1]) {
					case 0: $rtn .= 'Oval'; break;
					case 1: $rtn .= 'National'; break;
					case 2: $rtn .= 'GP Long'; break;
				}
			break;
			case 5: $rtn = 'Westhill ';
				switch($trackCode[1]) {
					case 0: $rtn .= 'International'; break;
				}
			break;
			case 6: $rtn = 'Aston ';
				switch($trackCode[1]) {
					case 0: $rtn .= 'Cadet'; break;
					case 1: $rtn .= 'Club'; break;
					case 2: $rtn .= 'National'; break;
					case 3: $rtn .= 'Historic'; break;
					case 4: $rtn .= 'Grand Prix'; break;
					case 5: $rtn .= 'Grand Touring'; break;
					case 6: $rtn .= 'North'; break;
				}
			break;
			default: return 'Unknown Track';
		}
		if ($trackCode[2] === 1)
			return "$rtn Reversed";
		else
			return $rtn;
	}
?>
<html>
	<head>
		<title>Page for <?php echo urlencode($_GET['racer']); ?></title>
	</head>
	<body>
<?php	if (empty($_GET['racer'])): ?>
		<form target="_SELF" method="GET">
			<lable for="racer">LFS Username:</lable><input type="textbox" id="racer"  name="racer" /><br />
			<input type="submit" value="Get Info" />
		</form>
<?php	else: 	?>
		<table>
			<tbody>
<?php		$pst = $SDK->get_pst($_GET['racer']);
			forEach ($pst[0] as $key => $val):	?>
				<tr>
<?php			switch ($key):
					case 'distance':	?>
					<th>Meters Driven</th>
					<td><?php echo $val; ?></td>
<?php				break;
					case 'fuel':	?>
					<th>Fuel burned in cl</th>
					<td><?php echo $val; ?></td>
<?php				break;
					case 'laps':	?>
					<th>Laps Driven</th>
					<td><?php echo $val; ?></td>
<?php				break;
					case 'joined':	?>
					<th>Hosts joined</th>
					<td><?php echo $val; ?></td>
<?php				break;
					case 'win':	?>
					<th>Race wins</th>
					<td><?php echo $val; ?></td>
<?php				break;
					case 'races_finished':	?>
					<th>Races finished</th>
					<td><?php echo $val; ?></td>
<?php				break;
					case 'qual':	?>
					<th>Qualifications</th>
					<td><?php echo $val; ?></td>
<?php				break;
					case 'pole':	?>
					<th>Pole positions</th>
					<td><?php echo $val; ?></td>
<?php				break;
					case 'dragwins':	?>
					<th>Drags won</th>
					<td><?php echo $val; ?></td>
<?php				break;
					case 'ostatus':	?>
					<th>Online status</th>
					<td><?php
						switch ($val) {
							case 0:	echo 'Offline'; break;
							case 1: echo 'Spectating'; break;
							case 2: echo 'In pits'; break;
							case 3: echo 'In race'; break;
						}
					?></td>
<?php				break;
					case 'hostname':	?>
					<th>Hostname</th>
					<td><?php echo hostToHTML($val); ?></td>
<?php				break;
					case 'last_time':	?>
					<th>Last active on</th>
					<td><?php echo date('M jS Y @ H:i', $val); ?></td>
<?php				break;
					case 'track':	?>
					<th>Track</th>
					<td><?php echo trackToName($val); ?></td>
<?php				break;
					default:
?>
					<th><?php echo ucwords($key); ?></th>
					<td><?php echo $val; ?></td>
<?php			endSwitch;	?>
				</tr>
<?php		endForEach;	?>
			</tbody>
		</table>
<?php	endIf;	?>
	</body>
</html>