#ifndef _CPUBSTATDLG_H_
#define _CPUBSTATDLG_H_

#include "global.h"
#include <wx/dialog.h>
#include <wx/sizer.h>
#include <wx/button.h>
#include <wx/stattext.h>
#include <wx/hyperlink.h>
#include <wx/textctrl.h>

class wxRegConfig;

//-----------------------------------------------------------------------------
// The dialog to get the LFS World Pubstat ID

class cPubstatDlg : public wxDialog
{
private:
  wxString m_IdentKey;          // the Pubstat ID key

  wxHyperlinkCtrl* m_Hyperlink; // links to the LFSW Pubstat page
  wxTextCtrl* m_IdentKeyText;   // text entry box for the Ident-key

  wxButton* m_OkBtn;           // "OK" button
  wxButton* m_CancelBtn;       // "Cancel" button

  wxBoxSizer* m_EntrySizer;    // sizer for entry of the Ident-key
  wxBoxSizer* m_ButtonSizer;   // sizer for the buttons
  wxBoxSizer* m_TopSizer;      // top-level sizer

  void OnButton(wxCommandEvent& event);
  void OnEnter(wxCommandEvent& event) { DoEnter(); }

  void DoEnter();

  DECLARE_EVENT_TABLE()

public:
  cPubstatDlg(wxWindow* parent);
  virtual ~cPubstatDlg();

  wxString GetIdentKey(bool showAlways = false);

  virtual void TranslateTexts();

  virtual void LoadConfig(wxRegConfig* config, const wxString& key);
  virtual void SaveConfig(wxRegConfig* config, const wxString& key);
};

#endif
