#include "cpubstatdlg.h"
#include <wx/config.h>

//-----------------------------------------------------------------------------
// Event table

BEGIN_EVENT_TABLE(cPubstatDlg, wxDialog)
  EVT_BUTTON(wxID_ANY, cPubstatDlg::OnButton)
  EVT_TEXT_ENTER(wxID_ANY, cPubstatDlg::OnEnter)
END_EVENT_TABLE()

//-----------------------------------------------------------------------------
// - parent = parent window

cPubstatDlg::cPubstatDlg(wxWindow* parent)
: wxDialog(parent, -1, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE | wxRESIZE_BORDER)
{
  // entry
  m_Hyperlink = new wxHyperlinkCtrl(this, wxID_ANY, _T("Pubstat Ident-Key"), LFSW_PUBSTAT_PAGE);
  m_IdentKeyText = new wxTextCtrl(this, wxID_ANY, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxTE_PROCESS_ENTER);

  // set size of text control so that an identkey (32 characters) fits well in it
  m_IdentKeyText->SetMinSize(wxSize(40 * m_IdentKeyText->GetCharWidth(), m_IdentKeyText->GetSize().GetHeight()));

  // buttons
  m_CancelBtn = new wxButton(this, wxID_CANCEL, wxEmptyString);
  m_OkBtn = new wxButton(this, wxID_OK, wxEmptyString);
  m_OkBtn->SetDefault();

  // populate sizers
  m_EntrySizer = new wxBoxSizer(wxHORIZONTAL);
  m_EntrySizer->Add(m_Hyperlink, wxSizerFlags(1).Expand().Centre().Proportion(0));
  m_EntrySizer->AddSpacer(BASE_MARGIN);
  m_EntrySizer->Add(m_IdentKeyText, wxSizerFlags(1).Expand().Proportion(1));

  m_ButtonSizer = new wxBoxSizer(wxHORIZONTAL);
  m_ButtonSizer->AddStretchSpacer();
  m_ButtonSizer->Add(m_CancelBtn);
  m_ButtonSizer->AddSpacer(BASE_MARGIN);
  m_ButtonSizer->Add(m_OkBtn);

  m_TopSizer = new wxBoxSizer(wxVERTICAL);
  m_TopSizer->Add(m_EntrySizer, wxSizerFlags(1).Expand().Proportion(0).Border(wxALL, BASE_MARGIN));
  m_TopSizer->Add(m_ButtonSizer, wxSizerFlags(1).Expand().Proportion(0).Border(wxALL, BASE_MARGIN));

  TranslateTexts();
  SetSizer(m_TopSizer);

  SetSize(m_TopSizer->ComputeFittingWindowSize(this));
}

//-----------------------------------------------------------------------------

cPubstatDlg::~cPubstatDlg()
{
}

//-----------------------------------------------------------------------------

void cPubstatDlg::OnButton(wxCommandEvent& event)
{
  switch (event.GetId()) {
    case wxID_OK :
      DoEnter();
      break;

    default :
      event.Skip();
      return;
  }
}

//-----------------------------------------------------------------------------

void cPubstatDlg::DoEnter()
{
  // fetch input
  wxString text = m_IdentKeyText->GetValue();
  text.Trim(true);
  text.Trim(false);
  if (text.IsEmpty()) return;
  m_IdentKey = text;

  if (IsModal()) EndModal(wxID_OK);
}

//-----------------------------------------------------------------------------
// Return the Ident-key. If necessary, show the dialog and let the user enter one
// - showAlways = always show the dialog

wxString cPubstatDlg::GetIdentKey(bool showAlways)
{
  if (!m_IdentKey.IsEmpty() && !showAlways) return m_IdentKey;

  m_IdentKeyText->SetValue(m_IdentKey);
  CentreOnParent();
  if (ShowModal() != wxID_OK) return wxEmptyString; // nothing was entered
  return m_IdentKey;
}

//-----------------------------------------------------------------------------
// Loading and saving the configuration settings

void cPubstatDlg::LoadConfig(wxRegConfig* config, const wxString& key)
{
  config->Read(key + _T("/identkey"), &m_IdentKey);
}


void cPubstatDlg::SaveConfig(wxRegConfig* config, const wxString& key)
{
  config->Write(key + _T("/identkey"), m_IdentKey);
}

//-----------------------------------------------------------------------------
//

void cPubstatDlg::TranslateTexts()
{
  SetTitle(_TT(ID_CAPTION_PUBSTATEDLG, "Enter LFS World identification"));
  m_CancelBtn->SetLabel(_TT(ID_CTRL_FD_CANCEL, "Cancel"));
}
