#ifndef _CMAINFRAME_H_
#define _CMAINFRAME_H_

#include "global.h"
#include "cgraphcontainer.h"
#include "cgraphview.h"
#include "ceventredirector.h"
#include "cplayback.h"
#include <wx/frame.h>
#include <wx/docview.h>

#include <wx/bitmap.h>
#include <wx/brush.h>
#include <wx/pen.h>
#include <wx/sizer.h>
#include <wx/timer.h>
#include <wx/aui/aui.h>
#include <wx/dynarray.h>

class cLegend;
class cProperties;
class cTrackMap;
class cDrivingLine;
class cFileDlg;
class cLog;
class cPresets;
class cPane;
class cToolbar;
class cPubstatDlg;

WX_DEFINE_ARRAY(cPane*, cPanePtrArray);
WX_DEFINE_ARRAY(cToolbar*, cToolbarPtrArray);
WX_DEFINE_ARRAY(cLap*, cLapPtrArray);

//-----------------------------------------------------------------------------
// The main window of the application

class cMainFrame : public wxFrame, public cEventRedirector
{
private:
  wxAuiManager m_AuiMgr;            // the AUI manager object
  wxMenuBar* m_MenuBar;             // the menu bar

  cGraphContainer* m_Graphs;        // window containing all graphs

  cPanePtrArray m_Panes;            // the panes
  cLegend* m_Legend;                // the legend
  cProperties* m_Properties;        // the properties pane
  cDrivingLine* m_DrivingLine;      // the driving line
  cTrackMap* m_TrackMap;            // the track map
  cLog* m_Log;                      // the log pane

  cToolbarPtrArray m_Toolbars;      // the toolbars
  cPresets* m_Presets;              // the presets toolbar
  cPlayback* m_Playback;            // the playback toolbar

  cFileDlg* m_FileDialog;           // the custom file dialog
  cPubstatDlg* m_PubstatDialog;     // the dialog to fetch the LFSW ID

  wxMenu* m_MenuPreset;             // the presets menu
  wxMenu* m_MenuLang;               // the languages submenu

  wxString m_ManualFile;            // the HTML file with the LRA manual

  float m_CursorDist;               // distance-in-lap for the position of the track cursors
  float m_SelStart;                 // distance-in-lap where selected part of track starts
  float m_SelEnd;                   // distance-in-lap where selected part of track ends

  // config settings
  bool m_CrossHairVisible;          // crosshair visible in graphs?
  bool m_Xrulers;                   // X rulers shown in graphs?
  wxPoint m_Position;               // the frame's (non-maximized, non-iconized) position
  wxFileHistory m_FileHistory;      // contains the list of recently opened files
  wxMenu* m_FileHistoryMenu;        // the menu for the file history
  bool m_AutoScroll;                // automatically scroll the driving line pane?
  bool m_RestoreSession;            // restore previous session at startup?
  bool m_ToolTips;                  // show tooltips on graphs?

  void AddGraph(graph_t type, int size, bool update = true, wxString settings = wxEmptyString);
  void DeleteGraph(size_t index, bool update = true);
  void DoSetTrackSelection(float start, float end);
  void DoSetTrackCursorPos(cGraphView* view, float distance, int type);
  void DoZoomReset();

  void CloseAll();
  void UpdateAll();
  void EnableMenuItems();
  void ShowCrossHair(bool visible);
  void ShowXrulers(bool visible);
  void EnableToolTips(bool visible);

  void LoadPerspective(const wxString& perspective);
  wxString SaveGraphs() const;
  void LoadGraphs(const wxString& graphs);
  void SelectPreset(size_t index);
  void RebuildPresetsMenu();

  void StatusText(const wxString&  text = wxEmptyString) { if (GetStatusBar() != NULL) SetStatusText(text); }
  void Report(const wxString& desc, const wxString& activity = wxEmptyString, bool error = true);

  // showing/hiding panes
  bool m_AllPanesHidden;            // are the panes currently all hidden?
  void ToggleAllPanes();
  void RestorePanes() { if (m_AllPanesHidden) ToggleAllPanes(); }
  void ShowPane(cPane* pane, bool shown);
  void ShowToolbar(cToolbar* toolbar, bool shown);

  // file loading
  cLapPtrArray m_LapsToLoad;        // queue of files that must be loaded

  // replaying the laps
  void PausePlayback() { m_Playback->Pause(); }
  void ResetPlayback() { m_Playback->Reset(); }

  // menu event handlers
  void OnAddGraph(wxCommandEvent& event);
  void OnChangeView(wxCommandEvent& event);
  void OnCloseAll(wxCommandEvent& WXUNUSED(event)) { CloseAll(); }
  void OnExit(wxCommandEvent& event);
  void OnHelp(wxCommandEvent& event);
  void OnIdle(wxIdleEvent& event);
  void OnMove(wxMoveEvent& event);
  void OnOpen(wxCommandEvent& event);
  void OnOpenRecent(wxCommandEvent& event);
  void OnSize(wxSizeEvent& event);
  void OnSetOption(wxCommandEvent& event);
  void OnZoom(wxCommandEvent& event);
  void OnAddPreset(wxCommandEvent& event);
  void OnDeletePreset(wxCommandEvent& event);
  void OnSelectPresetFromMenu(wxCommandEvent& event);
  void OnSelectLanguage(wxCommandEvent& event);
  void OnReplay(wxCommandEvent& event);

  // custom events
  void OnCloseView(wxCommandEvent& event);
  void OnDeleteLap(wxCommandEvent& event);
  void OnEqualHeightGraphs(wxCommandEvent& WXUNUSED(event)) { m_Graphs->EqualHeight(); }
  void OnLayoutMainFrame(wxCommandEvent& WXUNUSED(event)) { UpdateAll(); }
  void OnMoveGraph(wxCommandEvent& event);
  void OnOpenFile(wxCommandEvent& event);
  void OnPresetEvent(wxCommandEvent& event);
  void OnSetTrackCursorPos(wxCommandEvent& event);
  void OnSetTrackSelection(wxCommandEvent& event);
  void OnShowLap(wxCommandEvent& event);
  void OnSyncGraphs(wxCommandEvent& event);
  void OnReplayLap(wxCommandEvent& event);

  // other event handlers
  void OnClose(wxCloseEvent& event);
  void OnMenu(wxMenuEvent& event);

  DECLARE_EVENT_TABLE()

public:
  cMainFrame(const wxString& title, const wxPoint& pos, const wxSize& size, const wxString& infile);

  void RequestFileLoad(const wxString& fileName);
  void CancelFileLoads();
};

#endif
