#include "cgraphtools_y.h"
#include "cgraphview.h"
#include "cmgr.h"

//-----------------------------------------------------------------------------
// Event table

BEGIN_EVENT_TABLE(cGraphToolsY, cGraphTools)
  EVT_CHOICE(ID_CTRL_GT_LOGTYPE_Y, cGraphToolsY::OnChangeLogtype)
  EVT_CHOICE(ID_CTRL_GT_WHEEL, cGraphToolsY::OnChangeLogtype)
  EVT_CHECKBOX(ID_CTRL_GT_DELTA, cGraphToolsY::OnToggleDeltaMode)
  EVT_CHOICE(ID_CTRL_GT_LAP, cGraphToolsY::OnChangeLap)
END_EVENT_TABLE()

//-----------------------------------------------------------------------------

cGraphToolsY::cGraphToolsY(cGraphView* parent, cGraphY* graph)
: cGraphTools(parent, graph)
{
  m_LogtypeChoice = CreateLogtypeControl(ID_CTRL_GT_LOGTYPE_Y);
  m_WheeltypeChoice = CreateWheeltypeControl(ID_CTRL_GT_WHEEL);
  m_WheelText = new wxStaticText(this, ID_TXT_GT_WHEEL, wxEmptyString);
  m_DeltaCheck = new wxCheckBox(this, ID_CTRL_GT_DELTA, wxEmptyString);
  m_LapChoice = new wxChoice(this, ID_CTRL_GT_LAP, wxDefaultPosition, wxDefaultSize, 0, NULL);

  TranslateTexts();
  EnableControls();

  m_TopSizer->Insert(0, m_LogtypeChoice,
      wxSizerFlags(1).Proportion(0).Center().Border(wxALL, BASE_MARGIN));
  m_TopSizer->Insert(1, m_WheelText,
      wxSizerFlags(1).Proportion(0).Center().Border(wxLEFT, 2 * BASE_MARGIN));
  m_TopSizer->Insert(2, m_WheeltypeChoice,
      wxSizerFlags(1).Proportion(0).Center().Border(wxALL, BASE_MARGIN));
  m_TopSizer->Insert(3, m_DeltaCheck,
      wxSizerFlags(1).Proportion(0).Center().Border(wxLEFT, 2 * BASE_MARGIN));
  m_TopSizer->Insert(4, m_LapChoice,
      wxSizerFlags(1).Proportion(0).Center().Border(wxTOP | wxBOTTOM, BASE_MARGIN));

  UpdateAll();
}

//-----------------------------------------------------------------------------

cGraphToolsY::~cGraphToolsY()
{
}

//-----------------------------------------------------------------------------

void cGraphToolsY::OnChangeLogtype(wxCommandEvent& WXUNUSED(event))
{
  cGraphY* graph = (cGraphY*)m_Graph;

  // retrieve user choices
  int log = GetLogtypeSelection(m_LogtypeChoice);
  int wheel = GetWheeltypeSelection(m_WheeltypeChoice);

  // correct invalid choices
  if (log < 0) {
    log = graph->GetLogtype();
    SetLogtypeSelection(m_LogtypeChoice, log);
  }
  if (wheel < 0) {
    wheel = graph->GetWheeltype();
    SetWheeltypeSelection(m_WheeltypeChoice, wheel);
  }

  if ((log == graph->GetLogtype()) && (wheel == graph->GetWheeltype())) return; // no change

  // update graph and state of controls
  graph->SetLogtype(log, wheel);
  if ((log == LOGTYPE_TIMEINLAP) && (MGR->GetLapCount() > 0)) {
    // automatically set the 'delta' checkbox
    m_DeltaCheck->SetValue(true);
  }
  else {
    // restore the user's choice
    m_DeltaCheck->SetValue(((cGraphY*)m_Graph)->GetDeltaMode());
  }
  SetDeltaLap();
  EnableControls();

  graph->FitSelection(); // ensure that curves are visible
}

//-----------------------------------------------------------------------------

void cGraphToolsY::OnToggleDeltaMode(wxCommandEvent& WXUNUSED(event))
{
  ((cGraphY*)m_Graph)->SetDeltaMode(m_DeltaCheck->IsChecked()); // store the user's choice
  SetDeltaLap();
  EnableControls();

  m_Graph->FitSelection(); // ensure that curves are visible
}

//-----------------------------------------------------------------------------

void cGraphToolsY::OnChangeLap(wxCommandEvent& WXUNUSED(event))
{
  SetDeltaLap();
  m_Graph->FitSelection(); // ensure that curves are visible
}

//-----------------------------------------------------------------------------
// Re-read the data from the graph (to fill the controls on the toolbar)

void cGraphToolsY::UpdateAll()
{
  cGraphY* graph = (cGraphY*)m_Graph;

  SetLogtypeSelection(m_LogtypeChoice, graph->GetLogtype());
  SetWheeltypeSelection(m_WheeltypeChoice, graph->GetWheeltype());

  cLap* lap = graph->GetDeltaLap();
  FillLapSelection(m_LapChoice, lap);
  m_DeltaCheck->SetValue(lap != NULL);

  EnableControls();

  Layout(); // re-filling m_LapChoice may change its width
}

//-----------------------------------------------------------------------------
// Set the delta-lap in the graph, based on the state of the controls

void cGraphToolsY::SetDeltaLap()
{
  cLap* lap = NULL;
  if (m_DeltaCheck->IsChecked()) lap = GetLapSelection(m_LapChoice);
  ((cGraphY*)m_Graph)->SetDeltaLap(lap);
}

//-----------------------------------------------------------------------------
// Enable/disable the controls

void cGraphToolsY::DoEnableControls()
{
  int sel = GetLogtypeSelection(m_LogtypeChoice);
  m_WheeltypeChoice->Enable((sel >= 0) && (cCarState::IsPerWheel(sel)));
  m_WheelText->Enable(m_WheeltypeChoice->IsEnabled());

  if (m_LapChoice->IsEmpty()) m_DeltaCheck->SetValue(false);
  m_DeltaCheck->Enable(m_LapChoice->GetCount() > 0);
  m_LapChoice->Enable(m_DeltaCheck->IsChecked());
}

//-----------------------------------------------------------------------------

void cGraphToolsY::TranslateTexts()
{
  cGraphTools::TranslateTexts(); // translate controls created by parent class

  // control labels
  m_WheelText->SetLabel(_TT(ID_TXT_GT_WHEEL, "Wheel"));
  m_DeltaCheck->SetLabel(_TT(ID_CTRL_GT_DELTA, "Difference with"));

  // choice contents
  SetLogtypeStrings(m_LogtypeChoice);
  SetWheeltypeStrings(m_WheeltypeChoice);
}
