#ifndef _CDRIVINGLINE_H_
#define _CDRIVINGLINE_H_

#include "global.h"
#include "cpane.h"
#include <wx/window.h>
#include <wx/pen.h>
#include <wx/menu.h>

class cTrackPath;

//-----------------------------------------------------------------------------
// The pane with the driving lines across the track

class cDrivingLine : public cPane
{
private:
  float m_Scale;           // drawing scale (= number of pixels per meter)
  float m_Zoom;            // user zoom factor
  float m_CentreX;         // X track coordinate corresponding with centre of track display
  float m_CentreY;

  float m_ClickPos;        // distance-in-lap of last click
  wxPoint m_MovePos;       // position of last mouse-motion event
  bool m_DragMode;         // are we drag-scrolling?

  float m_CursorDist;      // distance-in-lap for the position of the track cursors (< 0 = no cursors)

  void PutTrackCursor(float distance);
  wxRect GetTrackCursorPosition();

  bool m_AutoScroll;       // automatically scroll the display?
  wxMenu m_Context;        // context menu

  // drawing the track path
  cTrackPath* m_Path;      // the track path on which the polygon data is based
  bool m_PolygonsValid;    // are the current polygon values correct?
  wxPoint* m_Polygons;     // a poly-polygon, for use in wxDC::DrawPolyPolygon
  int* m_PolygonSize;      // the number of nodes for each polygon (always 4)
  int m_PolygonCount;      // the number of polygons (= number of nodes in the track path)

  void DrawTrack(wxDC& dc);

  void ScrollView(int dx, int dy);
  void SetZoom(float zoom);
  void ResetZoom();
  float DecodeMouse(wxPoint pos);

  void OnMouseLeftClick(wxMouseEvent& event);
  void OnMouseLeftRelease(wxMouseEvent& event);
  void OnMouseMove(wxMouseEvent& event);
  void OnMouseWheel(wxMouseEvent& event);
  void OnMouseLeftDoubleClick(wxMouseEvent& event);
  void OnMouseMiddleClick(wxMouseEvent& WXUNUSED(event)) { ResetZoom(); }
  void OnMouseRightClick(wxMouseEvent& event);
  void OnMouseRightDoubleClick(wxMouseEvent& event);

  void OnMenuClick(wxCommandEvent& event);

  // wxScrolledWindow auto-generates wxScrollWinEvent events when the mouse is dragged outside the window
  // if handling them is left to wxScrolledWindow, these cause repeated redraw (= 'flicker')
  void OnScrollWin(wxScrollWinEvent& WXUNUSED(event)) {}

  void OnPaint(wxPaintEvent& event);
  void OnSize(wxSizeEvent& event);

  DECLARE_EVENT_TABLE()

public:
  cDrivingLine(wxWindow* parent);
  virtual ~cDrivingLine();

  virtual wxSize DoGetBestSize() const;

  virtual void UpdateAll();
  virtual void DoShowLap(cLap* WXUNUSED(lap), bool WXUNUSED(shown)) { Refresh(); }
  virtual void DoSetTrackCursorPos(cGraphView* view, float distance, int type);

  // Convert track coordinates to window coordinates
  inline wxCoord Track2CoordX(float tc)
    { return (GetClientSize().GetWidth() / 2) + (wxCoord)((tc - m_CentreX) * m_Scale * m_Zoom); }

  inline wxCoord Track2CoordY(float tc)
    { return (GetClientSize().GetHeight() / 2) + (wxCoord)((m_CentreY - tc) * m_Scale * m_Zoom); }

  virtual void TranslateTexts();

  virtual void LoadConfig(wxRegConfig* config, const wxString& key);
  virtual void SaveConfig(wxRegConfig* config, const wxString& key);
};

#endif
