/*
You can use config var inEvent of Sub using this syntax
getConfigVar("NameOfVar")

To use $Host Var in your script type:
getConfigVar("Host")

This is case sensitive

List of All variable that can be used in player events or in other event if you have username
This can be retreived with function:
GetCurrentPlayerVar( idOfVar )
GetPlayerVar( username, idOfVar )

example:
$CurrNickName = GetCurrentPlayerVar( "NickName" );
$SpecificNickName = GetPlayerVar( "gai-luron","NickName" );

To have Complete user var readable look at docs/playersVar.txt


List of all variables that can be used in all events
This can be retreived with function:
getLapperVar( idOfVar )

example:
$CurrTrack = getLapperVar( "LongTrackName" );

RotateIn		-> Races remaining before Rotation
HostName		-> Current host Name
ShortTrackName		-> Track Name in Short format : SO6
LongTrackName		-> Track Name in long format : South City Chicane
ShortTime		-> Server Time in short format
LongTime		-> Server Time in long format
ShortDate		-> Date in short format
LongDate		-> Date in long format
CurrRotateCar		-> Current rotated Car
CurrRotateTrack		-> Current rotated Track
CurrLongRotateTrack	-> Current rotated Track
NextRotateCar		-> Next rotated Car
NextRotateTrack		-> Next rotated Track
NextLongRotateTrack	-> Next rotated Track
RequiredFlags		-> Flag(s) required on this server

Additionnal variable that can be used in OnAuthReached.

$auth			-> Authorization reached
*/

/*
Command block to run when a LFS Special event is triggered
Event EventId()
...
EndEvent

Command block used by backcall command like button or scheduled action or when received a command by player
Sub SubId()
...
EndSub

RegisterScheduleAction( "0 0 0 * * * *", SA_mid );
	You can register a subfunction to call when a time is reached
	Firts arg = cron format ss mm hh dayOfWeek dd MM YYYY
	dayOfWeek start at 0 = Sunday
	Second arg = Sub to call when player type this text

Command allowed on Event and Sub

cmdLFS("Command_text");
	Send a command to Lapper, see command.txt in LFS Doc

privMsg( "Message_text");
	Send a private message to the player that has triggered the event
privMsg( userName, "Message_text");
	Send a private message to specific player

openPrivButton( "help",25,28,150,10,5,-1,0,"^2Commands list" );
openPrivButton( "help",25,28,150,10,5,-1,0,"^2Commands list", backcall );
	Open a button for the current player
	1 - Unique id for this button
	2 - Left coordinate for this button ( 0-200 )
		$origL = (value between 0-200); - when this value is used, every next value can be made relative to this one (example: $origL + 5;)
	3 - Top coordinate for this button ( 0-200 )
		$origT = (value between 0-200); - when this value is used, every next value can be made relative to this one (example: $origT + 5;)
	4 - Width of the button ( 0-200 )
	5 - Heigth of the button ( 0-200 )
	6 - Space between line in multiline button
	7 - Duration in seconds for the button to be displayed (use -1 if you don't want an automatic close)
	8 - Format of the button, look at insim.txt for values
	9 - Button caption, for multiline, separate each line with &
	10 - Option name of the backcalled sub
	
Backcalled Sub receive the keyboardflag to have the key pressed when click
// CFlags byte : click flags

			1		// left click
			2		// right click
			4		// ctrl + click
			8		// shift + click
			
			if left click and right click, you receive 2 + 1 = 3

closePrivButton("welc&pos&clos&ref");
	Close one or more button(s), you specify ID of the button to close, multiple ID's have to be separated by a &

openGlobalButton( "bargr1",60,1,10,6,6,30,96,"Restart:" );
	Same as openPrivButton, but open button for all players connected

closeGlobalButton("welc&pos&clos&ref");
	Same as closePrivButton, but close button for all players connected

WriteLine( "My test");
	To display message on the Lapper console with carriage return
Write( "My test");
	To display message on the Lapper console without carriage return

There are another functions, look in config file

Codes that can be used on button format:

0 - transparent button
16 - light button
32 - dark button
64 - align text to left
128 - align text to right

If you want to make a light colored button with text aligned to the left, combine the codes to one new code, for example 16+64 = 80
*/

/*
To create colored text, use the following codes in front of the text you want to color:

^0 - black
^1 - red
^2 - green
^3 - yellow
^4 - blue
^5 - violet
^6 - cyan
^7 - white
^8 - no color

Other variables that could be used on expressions
&&			-> and
||			-> or
+			-> plus
-			-> minus
/			-> devide
*			-> multiply
^			-> pow
==			-> equal to
!=			-> not equal to
>			-> bigger then
<			-> smaller then
<=			-> smaller then and equal to
>=			-> bigger then and equal to
*/

#################
# Const include #
#################

include( "./includes/consts.lpr");


#################
#General options#
#################

$AdminFile = "./admin.txt"; # Name of the file containing admin lfsname player

$StoredValueDbs = "storedvalue"; # Name of the database in which additional values are stored

$TrackInfoFile = "trackInfo.cfg"; # Path to the TrackInfoFile used to compare splits

$TCPmode = true; # Connection to LFS in UDP mode or TCP mode

$EnableRegisterWeb = true; # When set to "true" your LFS Server is displayed on the FRH Team website

# To receive a notification via mail when an error occur on Lapper
$adminEmail = "";
$smtpServer = "";
$loginMail = "";
$passMail = "";

$DateFormat = "dd/MM/yyyy";
$LongDateFormat = "dddd dd MMMM yyyy";
				# Date format used for the exported elp files
				# Look at C#-format for date/time, little help
				# HH = Hour in 0-23 format
				# hh = Hour in 0-12 format
				# mm = Minute
				# tt = PM or AM
				# dd = Day
				# MM = Month
				# yyyy = year with 4 digits

$MessageTime = 5000; # Time in milliseconds for a racecontrol message (started by: rcm_all) to be displayed on screen

#$PubStatIdk = "";	# Indentification code for a connection to PubStat.
			# To obtain a PubStatId go to www.lfsworld.net , select My LFSW Setting, tab Pubstat Access
			# Remove # before PubStatIdK to activate this option

$ShowPlayerControl = False; # Set option to "true" if you want to show the control configuration of players when leaving the pits.

##############
#FTP transfer#
##############
# Results files can also be transferred to an FTP server
# Define the following parameters to use this feature
# Remove # before line to activate it
# -------------------------------------------------------------------

#$FtpServer = "your ftp server"; # Name/IP-address of your FTP server
#$FtpLogin = "your login"; # Loginname for your FTP server
#$FtpPasswd = "your password"; # Password for your FTP server
#$FtpRemotePath = "your remote dir"; # Directorname

#############
#Default Car#
#############
# Default car to show, when no car is specified in command !top or !drf and when a player haven't used a car on this server
# You can combine several cars by using + (example: "XFG+XRG";)
# -------------------------------------------------------------------
# Values UF1,XFG,XRG,XRT,RB4,FXO,LX4,LX6,RAC,FZ5,MRT,XFR,UFR,FOX,FO8,FXR,XRR,FZR,BF1,FBM

$DefaultTopCar = "XFG+XRG";

###################################
#Event triggered when lapper start#
###################################
Sub DisplaySpeed( $userName )
	PrivMsg( langEngine( "%{main_speedtrap}%" , ToPlayerUnit( GetCurrentPlayerVar( "InstantSpeed" ) ),GetCurrentPlayerVar("UnitSpeed") ) );
EndSub
Event OnLapperStart()
	RegisterScheduleAction( "0 0 0 * * * *", SA_mid );
	RegisterScheduleAction( "0 0 0 * 1 1 *", SA_newyear );
	
	RegisterNodeAction( "BL1" , 140 , DisplaySpeed );
	RegisterNodeAction( "BL1R" , 245 , DisplaySpeed );

	RegisterZoneAction( "BL1" , -78,200, 5 , DisplaySpeed );

#	MoveUserToGroup( "admin" , "Gai-Luron");


EndEvent

Sub SA_mid() # Lapper Event

	globalRcm( langEngine( "%{main_midnight}%" ) );

EndSub

Sub SA_newyear() # Lapper Event

	globalRcm( langEngine( "%{main_newyear}%" ) );

EndSub

###################################
#Authorization Options ( license )#
###################################
#Authorization Options
#
#$Auth1 $Auth2 ... $Auth10 variable
#Syntax : $AuthX = "Label,Carname:Trackname:MinimumTime&Carname:Trackname:MinimumTime&...| Carname:Trackname:MinimumTime&Carname:Trackname:MinimumTime&... | ...";
#& -> And condition
#| -> Or condition
#
#$AuthAllowPlayer="Auth1|...|AuthX|@username1,username2,...,usernameN";
#or
#$AuthAllowPlayer="All";
#-------------------------------------------------------------------

#$Auth1 = "Bronze,XFG:BL1:1.45.00 | XRT:SO4:1.20.20";
#$Auth2 = "Silver,XFG:BL1:1.40.00 | XRT:SO4:1.20.20";
#$Auth3 = "Gold,XFG:BL1:1.35.00";

$AuthAllowPlayer = "All";

$AuthMinPlayer = 0;	# Minimum number of players on the server to auto enable authorization
			# If number of players is below value, alle players are allowed
			# If number of players is above value, only AuthAllowPlayer are allowed

Event OnAuthAllowed( $userName ) # Player event
	globalMsg( langEngine( "%{main_allowed}%", GetCurrentPlayerVar("NickName") ) );
Endevent

Event OnAuthNotAllowed( $userName ) # Player event
	cmdLFS("/spec "  . GetCurrentPlayerVar("NickName") );
	globalMsg( langEngine( "%{main_notallowed}%", GetCurrentPlayerVar("NickName") ));
Endevent

# Local viariable that can be used
# $auth -> Authorization reached

Event OnAuthReached( $userName,$level ) # Player event
	privMsg(langEngine( "%{main_gotlevel}%", $level ) );
EndEvent

##################
#Swearword filter#
##################
#Specify a list of swearwords seperated by ,
#Specify a file with swearwords, one word per line
#-------------------------------------------------------------------

$SwearWordsList = "fuck,asholes,bastard,idiot";
#$SwearWordsList = "&./swear.txt";
$SwearWordsMax = 2; # Maximum number of allowed swearwords per session

Event OnSwearWords1( $userName ) # Player event
	privMsg( langEngine( "%{main_swear11}%" ) );
	privMsg( langEngine( "%{main_swear12}%", GetCurrentPlayerVar("SwearWordsRem") ) );
EndEvent

Event OnSwearWords2( $userName )  # Player event
	privMsg( langEngine( "%{main_swear21}%" ) );
	cmdLFS( "/spec " . GetCurrentPlayerVar("NickName") );
EndEvent

###########
#Handicaps#
###########
#You can specify 3 levels of handicap : for car, for car and track, for user
#Priority Level low to hight : HandicapCars, HandicapCarsTracks, HandicapUser
#-------------------------------------------------------------------
#Handicap cars
#
#Syntax :
#
#$HandicapCars = "car:mass:irest,car:mass:irest,...,car:mass:irest";
#
#car : LFS short car name
#mass : mass handicap in kg
#irest : Air intake restriction in percent
#-------------------------------------------------------------------
#Handicap cars/tracks
#
#Syntax :
#
#$HandicapCarsTracks = "car/track:mass:irest,car/track:mass:irest,...,car/track:mass:irest";
#
#car : LFS short car name
#track : LFS short track name
#mass : mass handicap in kg
#irest : Air intake restriction in percent
#-------------------------------------------------------------------
#$HandicapUser		# a list of players and their handicap
#			# if you prefix with & , You can indicate a file name that contains a list of racers, one racer per line
#			# if you prefix with @, You can list username separated with ,
#
#Syntax :
#
#$HandicapUsers = "&./your_file";
#$HandicapUsers = "@userName:mass:irest,userName:mass:irest,...userName:mass:irest";
#
#$RefreshHandicapUsers	# allow Lapper to refresh HandicapUsers on each player leaving pits
			# Usefull if HandicapUsers is a file and is updated frequently by an external program
#-------------------------------------------------------------------

#$HandicapCars = "XFG:100:10,XRT:50:10";

#$HandicapCarsTracks = "XFG/BL1:100:10,XRT/AS1:50:10";

#$RefreshHandicapUsers = true;
#$HandicapUsers = "&./your_hand.flt";
#$HandicapUsers = "@Gai-Luron:100:20,gwendoline:100:30,_-ALUCARD-_,lagamel:50:10,lister88,c-quad,shimanofr,bruno7529,boby5,kevinb,edgar,berlioz,la tortue,neron59,eur-can,stff,2psbob,oliv76000";


Event OnToLowHandicap( $userName ) # Player event
	cmdLFS("/spec " . GetCurrentPlayerVar("NickName") );
	globalMsg( langEngine( "%{main_tolowhand1}%",GetCurrentPlayerVar("NickName") ));
	globalMsg( langEngine( "%{main_tolowhand2}%",GetCurrentPlayerVar( "H_Mass" ), GetCurrentPlayerVar("H_TRes")) );
EndEvent

#################
#Control Allowed#
#################
# Racer flags
# "Y" = Yes
# "N" = No
# "*"" = Yes or No
# Local variable
#-------------------------------------------------------------------

$SwapSide = "*";
$AutoGears = "*";
$Shifter = "*";
$HelpBrake = "*";
$AxisClutch = "*";
$AutoClutch = "*";
$Mouse = "*";
$KbNoHelp = "*";
$KbStabilised = "*";
$CustomView = "*";

Event OnNotMatchFlags( $userName ) # Player event
	privMsg(langEngine( "%{main_nomatchflag}%" )  );
	privMsg(langEngine( "%{main_yourflag}%" , GetCurrentPlayerVar("PlayerFlags") ) );
	privMsg(langEngine( "%{main_yourflag}%" , GetLapperVar( "RequiredFlags" ) ) );
	privMsg(langEngine( "%{main_spectated}%" ) );
	cmdLFS("/spec " . GetCurrentPlayerVar("UserName") );
EndEvent

##############
#Race Control#
##############
#Voting:
#
#$InRaceLapsVoteMinMax = Laps in between where votes are allowed in race
#$InRaceLapsVoteMinMax = 0-0 Votes are never allowed
#$InRaceLapsVoteMinMax = -5 Votes are allowed between lap 1 and 5
#$InRaceLapsVoteMinMax = 2- Votes are allowed between laps 2 and the end of the race
#$InRaceLapsVoteMinMax = - Votes are always allowed
#
#$VoteRestart = percentage of players that have to vote to restart a race. To let LFS admin this function, set it to -1
#OnVoteRestartChange = Command to do when player votes to restart
#OnVoteRestartReach = Command to execute when VoteRestart is reached
#OnVoteRestartZero = Command to execute when no nb of player reach zero

#$VoteQualify = percentage of players that have to vote to start a qualification. To let LFS admin this function, set it to -1
#OnVoteQualifyChange = same as restart but for qualify
#OnVoteQualifyReach = same as restart but for qualify
#OnVoteQualifyZero = same as restart but for qualify
#
#$VoteEnd = percentage of players that have to vote to end a race. To let LFS admin this function, set it to -1
#OnVoteEndChange = same as restart but for endrace
#OnVoteEndReach = same as restart but for endrace
#OnVoteEndyZero = same as restart but for endrace
#-------------------------------------------------------------------
#Local variable:
#
#$Vote - Number of players that have voted
#$Remain - Number of players remaining to vote
#$Need - Number of players needed for an action
#$VoteLifeSec = Number of seconds to keep the vote alive after voting
#-------------------------------------------------------------------
#Auto restart:
#
#$AutoRestartRaceSec = Second between the end of a race (last player finished) and an automatic restart
#
#Rotation only work if AutoRestartRaceSec is set
#EnableRotation =	Allow or disallow rotation for track and/or car
#			Values : true or false
#$RotateTracks = "tracks to rotate"; separated by ','
#$RotateCars = "cars to rotate"; separated by ',' Use LFS definition for car, if not set, no car rotation
#$RotateEveryNbRaces = Number of races to do before rotation;
#-------------------------------------------------------------------

$InRaceLapsVoteMinMax = "-";

$VoteRestart = -1;



Event OnVoteRestartChange($PlayerOnTrack, $Vote , $Need) # Lapper Event
	openGlobalButton( "bargr1",60,1,10,6,6,30,96,langEngine( "%{main_vote_restart1}%"));
	openGlobalButton( "bargr2",70,1,20,6,6,30,96,langEngine( "%{main_vote_restart2}%",$Vote,$PlayerOnTrack,$Need ) );
EndEvent

Event OnVoteRestartReach($PlayerOnTrack, $Vote , $Need) # Lapper Event
	closeGlobalButton( "bargr1&bargr2" );
EndEvent

Event OnVoteRestartZero() # Lapper Event
	closeGlobalButton( "bargr1&bargr2" );
EndEvent

$VoteQualify = -1;

Event OnVoteQualifyChange($PlayerOnTrack, $Vote , $Need) # Lapper Event
	openGlobalButton( "bargq1",90,1,10,6,6,30,96,langEngine( "%{main_vote_qualify1}%") );
	openGlobalButton( "bargq2",100,1,20,6,6,30,96,langEngine( "%{main_vote_qualify2}%",$Vote,$PlayerOnTrack,$Need ));
EndEvent

Event OnVoteQualifyReach($PlayerOnTrack, $Vote , $Need) # Lapper Event
	closeGlobalButton("bargq1&bargq2" );
EndEvent

Event OnVoteQualifyZero() # Lapper Event
	closeGlobalButton("bargq1&bargq2" );
EndEvent

$VoteEnd = -1;

Event OnVoteEndChange($PlayerOnTrack, $Vote , $Need) # Lapper Event
	openGlobalButton( "barge1",120,1,10,6,6,30,96,langEngine( "%{main_vote_end1}%") );
	openGlobalButton( "barge2",130,1,20,6,6,30,96,langEngine( "%{main_vote_end2}%",$Vote,$PlayerOnTrack,$Need ) );
EndEvent

Event OnVoteEndReach($PlayerOnTrack, $Vote , $Need) # Lapper Event
 	closeGlobalButton( "barge1&barge2" );
EndEvent

Event OnVoteEndZero() # Lapper Event
 	closeGlobalButton( "barge1&barge2" );
EndEvent

$VoteLifeSec = 30;

$AutoRestartRaceSec = 0;
$AutoRestartOnFirstFinished = false;

$EnableRotation = false;
$RotateTracks = "SO6R,BL1,FE3";
$RotateEveryNbRaces = 4;
$RotateCars = "XFG+UF1,TBO,XFR+UFR";

Event OnRotateCar() # Lapper Event
 	globalMsg(langEngine( "%{main_car_changed}%",getLapperVar( "CurrRotateCar" )));
EndEvent

Event OnRotateTrack() # Lapper Event
 	globalMsg(langEngine( "%{main_track_changed1}%") );
	globalMsg(langEngine( "%{main_track_changed2}%", getLapperVar( "CurrLongRotateTrack" )));
EndEvent

#################################################
#Connect messages when a player joins the server#
#################################################

Event OnConnect( $userName ) # Player event
	$NickName = GetCurrentPlayerVar("NickName");
	$Posabs = GetCurrentPlayerVar("PosAbs");
	$Groupqual = GetCurrentPlayerVar("GroupQual");

	openPrivButton( "welc",25,50,150,15,12,-1,ISB_NONE, langEngine("%{main_welc1}%", $NickName ) );
	openPrivButton( "pos",25,80,150,10,8,-1,ISB_NONE,langEngine("%{main_welc2}%",$Posabs,$Posqual,$Groupqual  ) );
	openPrivButton( "clos",78,120,20,10,10,-1,ISB_DARK,langEngine("%{main_accept}%"),OnConnectClose );
	openPrivButton( "ref",103,120,20,10,10,-1,ISB_DARK,langEngine("%{main_deny}%"),OnConnectCloseKick );
	http("http://www.frh-team.net/reglapper/getserver2.php" );

EndEvent

Sub OnConnectClose( $KeyFlags,$id )
	closePrivButton("welc&pos&clos&ref");
EndSub

Sub OnConnectCloseKick( $KeyFlags,$id )
	closePrivButton("welc&pos&clos&ref");
	cmdLFS("/kick " . GetCurrentPlayerVar("UserName") );
EndSub

##########################################
#New PLayer joining race or leaving pits)#
##########################################

Event OnNewPlayerJoin( $userName )  # Player event

EndEvent
#####################################################
# Event  when a player changes their nickname
#####################################################
Event OnNameChange($userName,$oldNickName,$newNickName) # Player event
EndEvent
#####################################################
#DisConnect messages when a player leaves the server#
#####################################################

Event OnDisConnect( $userName ) # Player event
#	globalMsg( langEngine( "%{main_left_server}%",GetCurrentPlayerVar("NickName")));
EndEvent


#############################################$#
#Splitting (general action when passing split)#
###############################################

Event OnSplit1( $userName ) # Player event
EndEvent

Event OnSplit2( $userName ) # Player event
EndEvent

Event OnSplit3( $userName ) # Player event
EndEvent

Event OnLap( $userName ) # Player event
EndEvent

#################################################
#Action when a predefined dist is done by player#
# Minimum dist is 100 meters
# -1 deactivate this feature
#################################################
$distToDo = -1;
Event OnDistDone( $userName ) # Player event

EndEvent
#############################################
#Action when a new Gapping Info is available#
#############################################

/*
openPrivButton( "help",25,28,150,10,5,-1,0,"^2Commands list", backcall );
	Open a button for the current player
	1 - Unique id for this button
	2 - Left coordinate for this button ( 0-200 )
		$origL = (value between 0-200); - when this value is used, every next value can be made relative to this one (example: $origL + 5;)
	3 - Top coordinate for this button ( 0-200 )
		$origT = (value between 0-200); - when this value is used, every next value can be made relative to this one (example: $origT + 5;)
	4 - Width of the button ( 0-200 )
	5 - Heigth of the button ( 0-200 )
	6 - Space between line in multiline button
	7 - Duration in seconds for the button to be displayed (use -1 if you don't want an automatic close)
	8 - Format of the button, look at insim.txt for values
	9 - Button caption, for multiline, separate each line with &
	10 - Option name of the backcalled sub
*/

Event OnNewGapPlayerBefore( $userName,$split ) # Player Event

EndEvent

Event OnNewGapPlayerBehind( $userName,	$split )  # Player Event

EndEvent

#######################################################
#Splitting (compare player split to best player split)#
#######################################################

$ShowSplitPB = true; # Set to false if you don't want to see messages about splits

Event OnSpbSplit1( $userName ) # Player event

EndEvent

Event OnSpbSplit2( $userName ) # Player event

EndEvent

Event OnSpbSplit3( $userName ) # Player event

EndEvent

Event OnSpbLast( $userName ) # Player event

EndEvent

####################################################
#Actions to do on splits relative to trackinfo.cfg#
####################################################
#Local variable: {SplitTime} - Split time
#-------------------------------------------------------------------

Sub TRI_split1_0( $userName ) # Player event
	globalMsg(  langEngine( "%{main_great1}%", NumToMSH(GetCurrentPlayerVar("SplitTime")),GetCurrentPlayerVar("NickName") ) );
EndSub

Sub TRI_split1_1( $userName ) # Player event
	globalMsg( langEngine( "%{main_good1}%",NumToMSH(GetCurrentPlayerVar("SplitTime")),GetCurrentPlayerVar("NickName") ) );
EndSub

Sub TRI_split2_0( $userName ) # Player event
	globalMsg(  langEngine( "%{main_great2}%", NumToMSH(GetCurrentPlayerVar("SplitTime")),GetCurrentPlayerVar("NickName") ) );
EndSub

Sub TRI_split2_1( $userName ) # Player event
	globalMsg( langEngine( "%{main_good2}%",NumToMSH(GetCurrentPlayerVar("SplitTime")),GetCurrentPlayerVar("NickName") ) );
EndSub

Sub TRI_split3_0( $userName ) # Player event
	globalMsg(  langEngine( "%{main_great3}%", NumToMSH(GetCurrentPlayerVar("SplitTime")),GetCurrentPlayerVar("NickName") ) );
EndSub

Sub TRI_split3_1( $userName ) # Player event
	globalMsg( langEngine( "%{main_good3}%",NumToMSH(GetCurrentPlayerVar("SplitTime")),GetCurrentPlayerVar("NickName") ) );
EndSub

Sub TRI_lap_0( $userName ) # Player event
	globalMsg( langEngine( "%{main_greatlap}%",NumToMSH( GetCurrentPlayerVar("LapTime") ), GetCurrentPlayerVar("NickName" ) ) );
EndSub

Sub TRI_lap_1( $userName ) # Player event
	globalMsg( langEngine( "%{main_goodlap}%", NumToMSH( GetCurrentPlayerVar("LapTime") ), GetCurrentPlayerVar("NickName") ) );
EndSub

#########################
#List of user qualifying#
#########################
#RefreshQualUsers : allow Lapper to refresh QualUsers on each outgoing pits, Usefull if QualUsers is a file and this is changed frequently by an external program
#QualUser : is a list of racers that participed in the qualification, required for function !nearqual !topqual and !statsqual
#if you prefix with & , You can indicate a file name that contains a list of racers, one racer per line (example : QualUsers = ./userfile.txt;)
#if you prefix with @, You can list usernames separated with ',' (example : QualUsers = @Gai-Luron,gwendoline,_-ALUCARD-_,lagamel;)
#You can specify which car is used by a user adding car after username separated by ':' (example : Gai-Luron:XFR,lagamel:UFR)
#You can specify the scheme of group of this qualification using a special username called DefGroup
#Defgroup Take 3 argument separated with ':'
#1 - Is the number Max of Group for this qualification
#2 - Is the number max of user per group
#3 - Is the minimum of user in the last group, recalc previous group as possible if number is low
#If you ommit scheme of groups, the group of qualification do not appear
#-------------------------------------------------------------------

$RefreshQualUsers = true;
#$QualUsers = "&./your_file.flt";
#$QualUsers = "@DefGroup:5:5:2,Gai-Luron,MataGyula,nesrulz,gwendoline,_-ALUCARD-_,lagamel,lister88,c-quad,shimanofr,bruno7529,boby5,kevinb,edgar,berlioz,la tortue,neron59,eur-can,stff,2psbob,oliv76000";

#################
#Command actions#
#################
#If ! before a name, force nickName authentification if UseUsernameForAuthentication=true
#If ! before a name, force userName authentification if UseUsernameForAuthentication=false
#You can use regexp expression in userName pattern, type regex=your regular expression
#
#Example:	if UseUsernameForAuthentication=true
#		!regex=^\[COP\].*
#		Find all user with a nickname that begins with [COP]
#		regex=^Gai.*
#		Find all user with a username that begins with Gai
# 		See regular expression on web for more info how it work
#
#Use & sign at end of patterns
#-------------------------------------------------------------------

Event OnMSO( $userName, $text ) # Player event

	$idxOfFirtsSpace = indexOf( $text, " ");

#	$LOF = getListOfPlayers();
#	dumpVar( $LOF );

	IF( $idxOfFirtsSpace == -1 ) THEN
	  $command = $text;
	  $argv = "";
	ELSE
	  $command = subStr( $text,0,$idxOfFirtsSpace );
	  $argv = trim( subStr( $text,$idxOfFirtsSpace ) );
	ENDIF
	
	SWITCH( $command )

		CASE "!node":
			IF ( UserIsAdmin( $userName ) == 1 )
			THEN
			  privMsg(  langEngine( "%{main_currnode}%", GetCurrentPlayerVar( "CurrNode" ) ) );
			ENDIF
			BREAK;
		CASE "!zone":
			IF ( UserIsAdmin( $userName ) == 1 )
			THEN
			  privMsg( langEngine( "%{main_currzone}%", GetCurrentPlayerVar( "X" ) . ":" . GetCurrentPlayerVar( "Y" ) ) );
			ENDIF
			BREAK;
		CASE "!term":
			IF ( UserIsAdmin( $userName ) == 1 )
			THEN
			  globalMsg( langEngine( "%{main_lapclose}%" ) );
			  termLapper();
			ELSE
			  privMsg( langEngine( "%{main_notadmin}%" ) );
			ENDIF
			BREAK;
		CASE "!test":
		        privRcm( GetCurrentPlayerVar("NickName") . " ^7is testing...");
			BREAK;
		CASE "!powered":
			http("http://www.frh-team.net/reglapper/getserver2.php");
			BREAK;
		CASE "!license":
		  setLicense( $argv );
	 		BREAK;
		CASE "!groupcmdlfs":
			IF ( UserIsAdmin( $userName ) == 1 )
			THEN
			  groupCmdLfs( $argv );
			ELSE
			  privMsg( langEngine( "%{main_notadmin}%" ) );
			ENDIF
			BREAK;
		CASE "!ban":
			IF ( UserIsAdmin( $userName ) == 1 )
			THEN
			  privMsg( langEngine( "%{main_ban}%", GetCurrentPlayerVar( "NickName" ), GetPlayerVar( $argv, "NickName" ) ) );
			  cmdLFS( "/ban " . $argv . " 1" );
			ENDIF
			BREAK;
		CASE "!kick":
			IF ( UserIsAdmin( $userName ) == 1 )
			THEN
			  privMsg( langEngine( "%{main_kick}%", GetCurrentPlayerVar( "NickName" ), GetPlayerVar( $argv, "NickName" ) ));
			  cmdLFS( "/kick " . $argv );
			ENDIF
			BREAK;
		CASE "!pos":
			privMsg( langEngine( "%{main_friendpos}%", GetCurrentPlayerVar( "PosAbs" ) ) );
			BREAK;
		CASE "!groupqual":
			privMsg( langEngine( "%{main_groupqual}%", GetCurrentPlayerVar( "GroupQual" ) ) );
			BREAK;
		CASE "!ver":
			http("http://www.frh-team.net/reglapper/getserver2.php");
			lapperVersion();
			BREAK;
		CASE "!auth":
			privMsg( langEngine( "%{main_level}%", GetCurrentPlayerVar("AuthLevel") ) );
			BREAK;
		CASE "!cleanspb":
			cleanSpb();
			BREAK;
		CASE "!spb":
			showSpb();
			BREAK;
		CASE "!hand":
			showHand( $argv );
			BREAK;
		CASE "!statsqual":
			statsQual( $argv );
			BREAK;
		CASE "!dstatsqual":
			dStatsQual( $argv );
			BREAK;
		CASE "!stats":
			stats( $argv );
			BREAK;
		CASE "!dstats":
			dStats( $argv );
			BREAK;
		CASE "!nearqual":
			nearQual( $argv );
			BREAK;
		CASE "!drfnearqual":
			drfNearQual( $argv );
			BREAK;
		CASE "!near":
			near( $argv );
			BREAK;
		CASE "!drfnear":
			drfNear( $argv );
			BREAK;
		CASE "!top":
			top( $argv );
			BREAK;
		CASE "!mypb":
			CurrentPlayerlfsWorldPB( $argv );
			BREAK;
		CASE "!myconfig":
			myConfig( );
			BREAK;
		CASE "!drf":
			drf( $argv );
			BREAK;
		CASE "!topqual":
			topQual( $argv );
			BREAK;
		CASE "!drfqual":
			drfQual( $argv );
			BREAK;
		CASE "!distance":
			privMsg(langEngine( "%{main_dist}%"
							,GetCurrentPlayerVar( "Car" )
							,GetLapperVar("ShortTrackName")
							,ToPlayerUnit( GetCurrentPlayerVar("Dist") )
							,GetCurrentPlayerVar("UnitDist")
							,ToPlayerUnit( GetCurrentPlayerVar("SessDist") )
							,GetCurrentPlayerVar("UnitDist")
			));
			BREAK;
		CASE "!laps":
			privMsg( langEngine( "%{main_lapdone}%"
							,GetCurrentPlayerVar("Car")
							,GetLapperVar("ShortTrackName")
							,GetCurrentPlayerVar("Laps")
							,GetCurrentPlayerVar("SessLaps") ) );
			 BREAK;
		CASE "!pit":
			privMsg( langEngine( "%{main_timeinpit}%",NumToMSH (GetCurrentPlayerVar("TotalPitTime"))));
			BREAK;
		CASE "!track":
			privMsg( langEngine( "%{main_trackused}%",GetLapperVar("ShortTrackName"),GetLapperVar("LongTrackName") ) );
			BREAK;
		CASE "!time":
			privMsg( langEngine( "%{main_serverclock}%",GetLapperVar("LongTime") ) );
			BREAK;
		CASE "!help":
			openPrivButton( "help",25,10,150,10,5,-1,0,langEngine( "%{main_help1}%" ) );
			openPrivButton( "help2",25,20,150,6,5,-1,96,langEngine( "%{main_help}%" ) );
			openPrivButton( "close",90,175,20,10,8,-1,32,Ok,MA_closeHelp );
	 		BREAK;
		CASE "!reload":
			UserGroupFromFile( "superusers", "./superusers.txt" );
			if( UserInGroup( "superusers",$userName) )
      THEN
	      privMsg("Restarting and reloading config!");
				reload();
			ELSE
	      privMsg("Only for admin!");
			ENDIF
		  BREAK;
		CASE "!lop":
			$list = GetListOfPlayers(  );
			FOREACH( $val IN $list )
			        writeline( $val["key"] . " -> " . $val["value"]);
			ENDFOREACH
			BREAK;
		CASE "!t":
			$currPly = getplayerinfo($userName );
			FOREACH( $maVar IN $currPly )
				WriteLine( $maVar["key"] . " " . $maVar["value"]);
			ENDFOREACH

			BREAK;
		CASE "!ps":
		    IF( $argv == "" ) THEN
				PstInfo( $userName );
			ELSE
				PstInfo( $argv );
			ENDIF
			BREAK;

	ENDSWITCH
EndEvent

Sub MA_closeHelp( $KeyFlags,$id )
	closePrivButton("help&help2&close");
EndSub
#####################################
#Action on teleport to pit (Shift+P)#
#####################################

# Actions to execute when player spectates or disconnects (leaves race).

Event OnLeaveRace( $userName )  # Player event
#	privMsg( GetCurrentPlayerVar("NickName" ) . "^8 left the race!" );
EndEvent

###############################
#Action a player flooding chat#
###############################

Event OnFlood( $userName ) # Player event
	privMsg( langEngine( "%{main_flood}%", GetCurrentPlayerVar("NickName") ) );
	cmdLFS( "/kick " . GetCurrentPlayerVar("UserName" ) );
EndEvent

$MaxFloodLines = 4; # Maximum number of consecutive lines allowed

$MaxFloodLinesTime = 5000; # Maximum time between two consecutive lines in milliseconds to count as flooding

#########################
#Action on Qual and race#
#########################
# Reorder grid can be "LFS", "PB", "WR"

$ReorderGrid = "LFS";
Event OnRaceStart( $NumP ) # Lapper event

EndEvent


Event OnQualStart( $NumP ) # Lapper event
	  DelayedCommand( 5, OQS );
EndEvent

Event OnFinish( $userName ) # Player event
EndEvent

Event OnResult( $userName,$flagConfirm ) # Player event
    $WinnerName = GetCurrentPlayerVar("NickName");

    IF( GetCurrentPlayerVar( "FinishedPos" ) == "1" )
    THEN
		  $TopDamier = 133;
		  $leftDamier = 105;
      openGlobalButton( "number_1",62,137,20,32,3,10,0,"^01");
      openGlobalButton( "number_2",67,137,10,32,3,10,16," ");
      openGlobalButton( "winner_title",78,137,63,19,4,10,96,"Winner ");
      openGlobalButton( "winner_name",78,158,58,10,3,10,64,$WinnerName );

      openGlobalButton( "winner_backing",66,136,76,34,3,10,32," ");
		  openGlobalButton( "winner_backing2",$leftDamier,$TopDamier,34,14,12,10,0,"^1^L^H^9¡½  ¡½  ¡½  ¡½");
		  openGlobalButton( "winner_backing3",$leftDamier,$TopDamier+6,38,14,12,10,0,"^1^L^H^9   ¡½  ¡½  ¡½  ¡½");
		  openGlobalButton( "winner_backing4",$leftDamier,$TopDamier+12,34,14,12,10,0,"^1^L^H^9¡½  ¡½  ¡½  ¡½");
    ENDIF

EndEvent

#########################
#Action to do on session#
#########################
$MaxSessionLaps = 2;

Event OnMaxSessionLaps( $userName ) # Player event
#	privMsg( "Max session laps reacheds" );
EndEvent

###############################
#Options on spinning detection#
###############################

$MinAngleVelocity = 250; # Minimum angle velocity to trigger action. Possible values: 0 - 720

# Action to execute when angle velocity is higher than MinAngleVelocity.

Event OnAngleVelocity( $userName ) # Player event
	globalMsg( langEngine( "%{main_lost_control}%" ,GetCurrentPlayerVar("NickName") ) );
EndEvent

$MaxNbInStunt = 20; #MaxNbInStunt is max time (in 100 ms) allowed in stunt mode before OnMaxNbInStunt is executed. If -1 No OnMaxNbInStunt are activated

Event OnMaxNbInStunt( $userName ) # Player event
	cmdLFS( "/spec " . GetCurrentPlayerVar("NickName") );
EndEvent

#################################
#Actions when player is too slow#
#################################

#$MaxAllowedLapTime1 = 100; # % Max allowed time to complete a lap relative to MaxLapTime in trackInfo.cfg

/*
Event OnMaxAllowedLapTime1( $userName ) # Player event
	privMsg( langEngine( "%{main_toslow1}%" ,$MaxAllowedLapTime1 ) );
	privMsg( langEngine( "%{main_toslow2}%" , GetCurrentPlayerVar("MaxAllowedLapTime2") ) );
EndEvent
*/

#$MaxAllowedLapTime2 = 150; # % Max allowed time to complete a lap relative to MaxLapTime in trackInfo.cfg

/*
Event OnMaxAllowedLapTime2( $userName ) # Player event
	privMsg( langEngine( "%{main_toslowvery1}%" ) );
	globalMsg( langEngine( "%{main_toslowvery2}%", GetCurrentPlayerVar("NickName") ) );
	cmdLFS( "/spec " . GetCurrentPlayerVar("UserName") );
EndEvent
*/

##################################
#Options for idle player on track#
##################################

#$IdleExclude = "Lagamel,Gai-Luron"; # Usernames excluded for idle check

$OnIdleTimeout1 = 20; # Idle timeout for OnIdleAction1 in seconds

Event OnIdle1( $userName ) # Player event
	privMsg( langEngine( "%{main_idle1}%" ) );
EndEvent

$OnIdleTimeout2 = 30; # Idle timeout for OnIdleAction2 in seconds

Event OnIdle2( $userName ) # Player event
	cmdLFS( "/spec " . GetCurrentPlayerVar("NickName") );
	privMsg( langEngine( "%{main_idle2}%" ) );
EndEvent

##################
#Drifting options#
##################
# This is the filepath for a file containing the collected data.
# This file will be created if it doesnt exist yet.
# You must ensure read/write access to this path.
#-------------------------------------------------------------------

$DriftDatabase = "./DriftPB";
$MinimumDriftSpeed = 50; # Minimum speed in km/h to maintain. Driving below that speed will reset score
$MinimumDriftAngle = 15; # Minimum angel to maintain. When angle is below value, score is reset
$MaximumDriftAngle = 100; # Maximum angel to maintain. When angle is above value, score is reset

# Actions to do on new personal best drift lap.
Event OnDriftPB( $userName ) # Player event

EndEvent

# Actions to do to when total lap drift score is higher or equal to MinimumDriftScore.
Event OnDriftLap( $userName ) # Player event

EndEvent
Event OnDriftScore( $userName ) # Player event

EndEvent

$GoodDriftScore = 4000; # Value to be reached to execute action on good drift score
Event OnGoodDrift( $userName ) # Player event

EndEvent

$MinimumDriftScore = 10; # Minimum drift score required

# Actions to do at end of lap if MinimumDriftScore is not achieved.
Event OnDriftTooLow( $userName ) # Player event

EndEvent

################################
#Options for hotlapping options#
################################

$GripDatabase = "./GripPB";	# This is the filepath of a file containing the collected data
				# This file will be created if it doesnt exist yet
				# You must ensure read/write access to this path

$LapTimeUsedForPb = 1; # How many PB lap used to make average PB time, Min = 1 and Max = 10

# Action to do on new personal best lap.
# OnPBQual for the racer who make qualif ( in QualUser )
# OnPB the other racer


Event OnPB( $userName ) # Player event
	globalMsg( langEngine( "%{main_onnewpb}%" , GetCurrentPlayerVar("NickName"), GetCurrentPlayerVar("Car"),NumToMSH(GetCurrentPlayerVar("LapTime")) ) );
	globalMsg( langEngine( "%{main_onnewpb_rank}%" ,GetCurrentPlayerVar("PosAbs") ) );
	privMsg( langEngine( "%{main_onnewpb_sesslaps}%" , GetCurrentPlayerVar("SessLaps") ) );
	privMsg( langEngine( "%{main_onnewpb_servlaps}%" , GetCurrentPlayerVar("Laps") ) );
	privMsg( langEngine( "%{main_onnewpb_avgspeed}%" ,ToPlayerUnit( GetCurrentPlayerVar("AvgSpeed") ),GetCurrentPlayerVar("UnitSpeed") ) );
	privRcm(  langEngine( "%{main_onnewpb_rank2}%" ,GetCurrentPlayerVar("Car"),GetCurrentPlayerVar("PosAbs") ) );
EndEvent

Event OnPBQual( $userName ) # Player event
	globalMsg( langEngine( "%{main_onnewpbqual}%" ,GetCurrentPlayerVar("NickName"),NumToMSH( GetCurrentPlayerVar("LapTime")) ) );
	globalMsg( langEngine( "%{main_onnewpbqual_rank}%" , GetCurrentPlayerVar("PosAbs") ) );
	privMsg( langEngine( "%{main_onnewpbqual_pos}%" ,GetCurrentPlayerVar("Posqual") ) );
	privMsg( langEngine( "%{main_onnewpbqual_pool}%" ,GetCurrentPlayerVar("GroupQual") ) );
	privMsg( langEngine( "%{main_onnewpbqual_avgspeed}%" , ToPlayerUnit( GetCurrentPlayerVar("AvgSpeed") ), GetCurrentPlayerVar("UnitSpeed") ) );
	privRcm( langEngine( "%{main_onnewpbqual_posqual}%" ,GetCurrentPlayerVar("NickName"),GetCurrentPlayerVar("Posqual"),GetCurrentPlayerVar("GroupQual") ) );
EndEvent

##########################
#Options for acceleration#
##########################

$AccelerationStartSpeed = 1; # At which speed to start measuring time. In km/h
$AccelerationEndSpeed = 100; # At which speed to stop measuring time. In km/h

$AccelerationStartSpeedMph = 1; # At which speed to start measuring time. In Mph
$AccelerationEndSpeedMph = 60; # At which speed to stop measuring time. In Mph

$AccelerationPrivateMaxTime = 10; # Maximum acceleration time in seconds to show message

#Message to show to players.
#Possible variables to use:
#{AccelerationStartSpeed} - Starting speed
#{AccelerationEndSpeed} - Ending speed
#{AccelerationTime} - Acceleration time achieved from start to end speed
#{UnitSpeed} Unit of the Speed of the player connected

Event OnAcceleration( $userName )  # Player event
	privMsg( langEngine( "%{main_accel}%" ,GetCurrentPlayerVar("AccelerationTime"),GetCurrentPlayerVar("AccelerationEndSpeed"),GetCurrentPlayerVar("UnitSpeed") ) );
EndEvent
############################
#Actions to do on Car Reset#
############################

$MaxCarResets = 5;        # Set to a positive number to limit number of race resets
Event OnMaxCarResets( $userName ) # Player event Spectate if player has used car reset more than the max
    globalMsg( langEngine( "%{main_maxreset}%" , GetCurrentPlayerVar( "NickName" ) ) );
    cmdLFS( "/spec " . GetCurrentPlayerVar( "UserName" ) );
EndEvent

Event OnCarReset( $userName ) # Player event Player event Do something when the car resets
    globalMsg( langEngine( "%{main_oncarreset}%", GetCurrentPlayerVar( "NickName" ),GetCurrentPlayerVar( "LapsDone" )+1 ));
    IF( getConfigVar("MaxCarResets") > 0 )
    THEN
        openPrivButton( "carres_warn",50,60,100,15,5,4,16, langEngine( "%{main_specwarn}%" ) );
        openPrivButton( "carres_msg1",50,75,100,10,5,4,16,langEngine( "%{main_resetrest}%",getConfigVar("MaxCarResets") - GetCurrentPlayerVar( "NumCarResets" )));
        privdelayedcommand( 4, ApplyCarResetPenalty);
    ELSE
        privdelayedcommand( 1, ApplyCarResetPenalty);
    ENDIF
EndEvent

Sub ApplyCarResetPenalty( $userName )
    IF( GetCurrentPlayerVar( "LapsDone" ) > 0 )
    THEN
        IF( getLapperVar( "RaceLapsLeft" ) <= 1 )
        THEN
            cmdLFS( "/p_30 " . GetCurrentPlayerVar( "UserName" ) );
        ELSE
            cmdLFS( "/p_dt " . GetCurrentPlayerVar( "UserName" ) );
        ENDIF
    ELSE
        IF( getLapperVar( "RaceLapsLeft" ) > 1 )
        THEN
            cmdLFS( "/p_dt " . GetCurrentPlayerVar( "UserName" ) );
        ENDIF
    ENDIF
EndSub

######################
#Actions for pit stop#
######################
#Local variable tou can use
#-------------------------------------------------------------------
# no pit windows if two var set to 0

$PitWindowStart=0;
$PitWindowStop=0;

Event OnNotPitWindow( $userName )  # Player event
	privMsg( langEngine( "%{main_notpitwindow}%" ,GetCurrentPlayerVar("NickName"),getConfigVar("PitWindowStart"),getConfigVar("PitWindowStop") ) );
EndEvent

Event OnBeginPitWindow( $userName ) # Player event
	privMsg( langEngine( "%{main_inpitwindows}%" ,GetCurrentPlayerVar("NickName") ) );
EndEvent

Event OnEndPitWindow( $userName )  # Player event
	privMsg( langEngine( "%{main_outpitwindows}%", GetCurrentPlayerVar("NickName"] ) ));
EndEvent

Event OnBeginPit( $userName )  # Player event
	globalMsg( langEngine( "%{main_beginpit}%", GetCurrentPlayerVar("NickName") ) );
	privMsg( langEngine( "%{main_pitwork}%", GetCurrentPlayerVar("pitWork") ) );
EndEvent

Event OnEndPit( $userName )  # Player event

EndEvent

Event OnPit( $userName )  # Player teleported to pit () Shift + P )'

EndEvent

Event OnEnterPitLane( $userName,$reason ) # Player event
# $reason
#	"ENTER"		// entered pit lane
#	"NO_PURPOSE"	// entered for no purpose
#	"DT"		// entered for drive-through
#	"SG"		// entered for stop-go

EndEvent

Event OnExitPitLane(  $userName ) # Player event

EndEvent

#$FL_Changed -> Front Left Changed  : 1 Changed 0 No
#$FR_Changed -> Front Right Changed : 1 Changed 0 No
#$RL_Changed -> Rear Left Changed : 1 Changed 0 No
#$RR_Changed -> Rear Right Changed : 1 Changed 0 No

Event OnChangeTyres( $userName, $FL_Changed, $FR_Changed, $RL_Changed, $RR_Changed ) # Player event

EndEvent

######################
#Actions on penalties#
######################
#Possible variables to use:
#
#OnFastDriveOnPitL1 = Actions on 30 Sec Penalty or drive-through
#OnFastDriveOnPitL2 = Actions on 45 Sec Penalty or Stop&Go
#MaxFastDriveOnPit = Max Fast Drive on Pit allowed per race
#OnMaxFastDriveOnPit = Actions on Max Fast Drive on Pit allowed
#OnFalseStartL1 = 30 Sec Penalty or drive-through
#OnFalseStartL2 = 45 Sec Penalty or Stop&Go
#
#Local Variable can be used:
#
#-------------------------------------------------------------------

Event OnFastDriveOnPitL1( $userName ) # Player event
	globalMsg( langEngine( "%{main_fastdrivepitl1_1}%",GetCurrentPlayerVar("NickName") ) );
	privMsg( langEngine( "%{main_fastdrivepitl1_2}%" ) );
EndEvent

Event OnFastDriveOnPitL2( $userName ) # Player event
	globalMsg( langEngine( "%{main_fastdrivepitl2_1}%",GetCurrentPlayerVar("NickName") ) );
	privMsg( langEngine( "%{main_fastdrivepitl2_1}%", GetCurrentPlayerVar("RemainFDIP" ) ) );
	cmdLFS( "/spec " . GetCurrentPlayerVar( "UserName" ) );
EndEvent

Event OnMaxFastDriveOnPit( $userName ) # Player event
	globalMsg( langEngine( "%{main_maxfastdrivepit1}%",GetCurrentPlayerVar("NickName") ) );
	privRcm( langEngine( "%{main_maxfastdrivepit2}%"  ) );
	cmdLFS( "/kick " . GetCurrentPlayerVar("UserName") );
EndEvent
$MaxFastDriveOnPit = 2;

Event OnFalseStartL1( $userName ) # Player event
EndEvent

Event OnFalseStartL2( $userName ) # Player event
EndEvent


####################
#    Default Sub   #
####################
Sub PstInfo($userName )

	$currPly = getPlayerInfo( $userName );
	if( $currPly == "" ) THEN
	    WriteLine( "Coucou");
		RETURN();
	ENDIF
	openPrivButton( "Back",74,58,52,64,5,-1,ISB_DARK, "" );
	openPrivButton( "PSNickName",75,59,50,5,5,-1,ISB_DARK, $currPly["NickName"] . " ^7( " . $currPly["PSCountry"] . " )" );
	openPrivButton( "PSDistance",75,65,50,5,5,-1,ISB_LIGHT|ISB_LEFT, langEngine("%{main_psdistance}%", strFormat( "{0:0}", ToPlayerUnit( $currPly["PSDistance"]/1000 )),$currPly["UnitDist"]) );
	openPrivButton( "PSFuel",75,70,50,5,5,-1,ISB_LIGHT|ISB_LEFT, langEngine("%{main_psfuel}%", strFormat( "{0:0}", $currPly["PSFuel"]/1000)) );
	openPrivButton( "PSLaps",75,75,50,5,5,-1,ISB_LIGHT|ISB_LEFT, langEngine("%{main_pslaps}%", $currPly["PSLaps"]) );
	openPrivButton( "PSWins",75,80,50,5,5,-1,ISB_LIGHT|ISB_LEFT, langEngine("%{main_pswins}%", $currPly["PSWins"]) );
	openPrivButton( "PSSecond",75,85,50,5,5,-1,ISB_LIGHT|ISB_LEFT, langEngine("%{main_pssecond}%", $currPly["PSSecond"]) );
	openPrivButton( "PSThird",75,90,50,5,5,-1,ISB_LIGHT|ISB_LEFT, langEngine("%{main_psthird}%", $currPly["PSThird"]) );
	openPrivButton( "PSFinished",75,95,50,5,5,-1,ISB_LIGHT|ISB_LEFT, langEngine("%{main_psfinished}%", $currPly["PSFinished"]) );
	openPrivButton( "PSQuals",75,100,50,5,5,-1,ISB_LIGHT|ISB_LEFT, langEngine("%{main_psquals}%", $currPly["PSQuals"]) );
	openPrivButton( "PSPole",75,105,50,5,5,-1,ISB_LIGHT|ISB_LEFT, langEngine("%{main_pspole}%", $currPly["PSPole"]) );

	openPrivButton( "pstclose",75,111,50,10,5,-1,ISB_DARK, langEngine("%{main_close}%"),ClosePstInfo );

EndSub
Sub ClosePstInfo( $KeyFlags,$id )
	closePrivButton( "pstclose&Back&PSNickName&PSDistance&PSFuel&PSLaps&PSWins&PSSecond&PSThird&PSFinished&PSQuals&PSPole");
EndSub
####################
#Overriding options#
####################
include( "./includes/addonsused.lpr");

Lang "EN"

	main_welc1 = "^7Welcome {0} ^7to ^1LFSLapper ^7powered server !&^2Type ^7!help ^2after leaving garage to see commands.";
	main_welc2 = "^7Your actual friendly Position (all visitors) : ^7{0}&^2Your actual League prequalify Position : {1}^6Estimate Pool : {2}&Don't use swearwords on this server&respect other player&otherwise you can be banned";
	main_accept = "Accept";
	main_deny = "Deny";
	main_speedtrap = "SpeedTrap = {0} {1}";
	main_gotlevel =  "^3You have got level: {0}";
	main_swear11 = "^1Don't use this words on this server";
	main_swear12 = "You will be spectated in ^2{0} ^1 more attempt(s)";
	main_swear21 = "Too many swearwords, spectated";
	main_nomatchflag = "Flags not match required flags";
	main_yourflag =  "Yours flags -> {0}";
	main_requiredflag = "Required flags -> {0}" ;
	main_spectated = "Spectated";
	main_notadmin = "You are not an Admin!";
	main_currnode = "The Current Node is : {0}";
	main_currzone = "The Current Zone is : {0}";
	main_lapclose = "Lapper Closed By Administrator!";
	main_ban = "{0} Ban {1}";
	main_kick = "{0} kick {1}";
	main_friendpos = "Your friendly position is {0}";
	main_groupqual = "Your groupqual is {0}";
	main_level = "^3You have level(s): {0}";
	main_dist = "Distance done on {0}/{1} = {2} {3}, session = {4} {5}";
	main_lapdone = "Laps done on {0}/{1} = {2}, session = {3}";
	main_timeinpit = "Time in pitting {0}";
	main_trackused = "Track in use : {0} = {1}";
	main_serverclock = "Server time clock reference : {0}";
	main_midnight = "Midnight warning to all working men!";
	main_newyear = "Happy New Year!";
	main_allowed = "{0}^3 allowed on this server";
	main_notallowed = "{0}^3 not allowed on this server";
	main_tolowhand1 = "{0}^3 spectated for to low handicap";
	main_tolowhand2 = "^3need {0}kg and {1}% of intake restriction!";
	main_vote_restart1 = "Restart:";
	main_vote_restart2 = "({0}/{1}) Need {2}";
	main_vote_qualify1 = "Qualify";
	main_vote_qualify2 = "({0}/{1}) Need {2}";
	main_vote_end1 = "End:";
	main_vote_end2 = "({0}/{1}) Need {2}";
	main_car_changed = "Car changed, go to pit! Current car = {0}";
	main_track_changed1 = "Track changed, please wait!";
	main_track_changed2 = "Current Track = {0}";
	main_left_server = "{0} ^7left the server";
	main_great1 = "Great 1st split ({0}) by {1}^8!";
	main_good1 = "Good 1st split ({0}) by {1}^8!";
	main_great2 = "Great 2nd split ({0}) by {1}^8!";
	main_good2 = "Good 2nd split ({0}) by {1}^8!";
	main_great3 = "Great 3rd split ({0}) by {1}^8!";
	main_good3 = "Good 3rd split ({0}) by {1}^8!";
	main_greatlap = "Great lap ({0}) by {1}^8!";
	main_goodlap = "Good lap ({0}) by {1}^8!";
	main_help1 = "^2Commands list";
	main_help = "^2General commands"
			. "&^3!myconfig ^8Configure lapper for you"
			. "&^3!mypb ^8Your LFSWorld PB list"
			. "&^3!ps ^8Your pub stat info or !ps userName"
			. "&^3!who ^8Players present stats"
			. "&^3!top ^8[table offset] [3-letter car name] ['filter' pattern]"
			. "&^3!drf ^8[table offset] [3-letter car name] ['filter' pattern]"
			. "&^3!stats ^8[playername pattern]"
			. "&^3!dstats ^8[playername pattern]"
			. "&^3!near ^8Gap with 14 pilots near you on the ranking"
			. "&^3!spb ^8Split times and TPB (Theoretical PB)"
			. "&^3!razspb ^8Start new spb session (eg when changing car)"
			. "&^3!track ^8Name of actual track"
			. "&^3!time ^8Server time (to leagues mettings)"
			. "&^3!ver ^8Version of LFSLapper"
			. "&"
			. "&^2Special league commands"
			. "&^3!topqual ^8Rank to pilots specified on *.flt file"
			. "&^3!statsqual ^8Actual Position on prequalify session"
			. "&"
			. "&^2New functions"
			. "&^3!laps ^8Total laps number + session laps number"
			. "&^3!hand ^8Handicap by pilot ordered by league-host admin"
			. "&^3!pit ^8Total pit stop time"
			. "&^3Shift+i ^8Configure your display messages"
			. "&^3!closepb ^8Close Pitboard temporary"
			. "&^3!config ^8Configure Pitboard"
			. "&^3!ctrack ^8Open track change GUI (Admin only)"
			. "&^3!pitwindow ^8Show currently set pitwindow(s)"
			. "&^3!pwgui ^8Open Pitwindow GUI (Admin only)"
			. "&^3!sc ^8Open safetycar GUI (Admin only)";
	main_flood = "{0}^3 kicked for flooding";
	main_on_result = "Finished Pos = {0}";
	main_lost_control = "^1Danger! ^8{0} ^2lost control!";
	main_toslow1 = "you are too slow! Max : {0}";
	main_toslow2 = "kick on {0}";
	main_toslowvery1 = "You are very slow, spectated!";
	main_toslowvery2 = "{0} is too slow, spectated!";
	main_idle1 = "^3You are idle and will be spectated in 10 seconds" ;
	main_idle2 = "^3You are spectated for non-activity";
	main_onnewpb = "New PB by {0}^8 ({1}): {2}";
	main_onnewpb_rank = "Friendly rank : {0}";
	main_onnewpb_sesslaps = "Session laps done = {0}";
	main_onnewpb_servlaps = "Total laps done (server) = {0}";
	main_onnewpb_avgspeed = "Average speed: {0}{1}";
	main_onnewpb_rank2 = "Friendly {0} rank: ^7{1}";
	main_onnewpbqual = "League - New QT by {0}^8:{1}";
	main_onnewpbqual_rank = "Friendly rank (all visitors): ^7{0}";
	main_onnewpbqual_pos = "^2Qualify pos.: {0}";
	main_onnewpbqual_pool = "^6Actual Pool: {0}";
	main_onnewpbqual_avgspeed = "Average speed: {0}{1}";
	main_onnewpbqual_posqual = "{0} ^2Pos:{1} - Pool:{2}";
	main_accel = "^8Accelerated in ^3{0}^8 seconds to {1} {2}!";
	main_notpitwindow = "{0} ^1You are not on pit Windows, allowed in {1}-{2}";
	main_inpitwindows = "{0} ^1You are allowed to pit";
	main_outpitwindows = "{0}  ^1You are not allowed to pit";
	main_beginpit = "{0}^8 makes a pit stop";
	main_pitwork = "Pit begin! Work:{0}";
	main_fastdrivepitl1_1 = "{0}^1 Warning for fast driving in pit";
	main_fastdrivepitl1_2 = "^1WARNING-KICK POSSIBLE" ;
	main_fastdrivepitl2_1 = "{0}^1 Spectated for fast driving in pit";
	main_fastdrivepitl2_2 = "^1KICK IN {0} TRY" ;
	main_maxfastdrivepit1 = "{0}^1 kicked for fast driving in pit";
	main_maxfastdrivepit2 = "^1YOU ARE KICKED";
	main_maxreset = "{0} spectated for exceeding max car resets";
	main_oncarreset = "Car Reset by {0} on lap {1}";
	main_specwarn = "^1Spectate Warning";
	main_resetrest = "^2You have^3 {0} ^2car resets left";
	main_close = "Close";
	main_psdistance = "^7Distance: ^2{0} ^7{1}";
	main_psfuel = "^7Fuel used: ^2{0} ^7liters ";
	main_pslaps = "^7Laps done: ^2{0}";
	main_pswins = "^7Wins: ^2{0}";
	main_pssecond = "^7Second: ^2{0}";
	main_psthird = "^7Third: ^2{0}";
	main_psfinished = "^7Race finished: ^2{0}";
	main_psquals = "^7Qualifications done: ^2{0}";
	main_pspole = "^7Poles done: ^2{0}";

	built_pos = "Pos";
	built_grp = "Grp";
	built_car = "Car";
	built_track = "Track";
	built_nick = "NickName";
	built_pb = "Pb";
	built_split = "Split";
	built_splits = "Splits";
	built_points = "Points";
	built_nolfspb = "LFS World PB not yet retreived";
	built_nolfspbcrit = "No LFS World PB for this criteria";
	built_lapsdone = " Laps Done";
	built_hand_nick = "^3{0}^9 handicap:";
	built_hand_curr = "  - Current {0}Kg - Intake Restr.: {1}%";
	built_hand_req =  "  - Required {0}^9 {1}Kg - Intake Rest.: {2}%";




EndLang
Lang "FR"
	main_welc1 = "^7Bienvenue {0} ^7sur ce serveur Géré par ^1LFSLapper^7!&^2Tapez ^7!help ^2 pour voir les commandes après avoir quitté le garage";
	main_welc2 = "^7Votre position absolue (Tous les visiteurs) : ^7{0}&^2Votre position de préqualification : {1}^6Estimation de poule : {2}&Ne pas employer de mots grossiers sur ce serveur&Respecter les autres joueurs&sinon vous risquez d'être banni";
	main_accept = "Accepter";
	main_deny = "Refuser";
	main_speedtrap = "Radar = {0} {1}";
	main_gotlevel =  "^3Vous avez atteind le niveau: {0}";
	main_swear11 = "^1Ne pas utiliser de gros mots ici";
	main_swear12 = "Encore {0} gros mot(s) et vous passerez spectateur";
	main_swear21 = "Trop de gros mots, spectateur";
	main_nomatchflag = "Flags ne correspondent pas aux flags requis";
	main_yourflag =  "Vos flags -> {0}";
	main_requiredflag = "Flags requis -> {0}" ;
	main_spectated = "Spectateur";
	main_notadmin = "Vous n'êtes pas admin!";
	main_currnode = "Le noeud courant est: {0}";
	main_currzone = "La zone courante est: {0}";
	main_lapclose = "Lapper fermé par un administrateur!";
	main_ban = "{0} a banni {1}";
	main_kick = "{0} a kické {1}";
	main_friendpos = "Votre position absolue est {0}";
	main_groupqual = "Votre poule est {0}";
	main_level = "^3Vous avez le(s) niveau(x): {0}";
	main_dist = "Distance réalisée avec {0}/{1} = {2} {3}, session = {4} {5}";
	main_lapdone = "Tours réalisés avec {0}/{1} = {2}, session = {3}";
	main_timeinpit = "Temps passé aux stands {0}";
	main_trackused = "Circuit actuel: {0} = {1}";
	main_serverclock = "Heure du serveur: {0}";
	main_midnight = "Minuit, attention aux travailleurs!";
	main_newyear = "Bonne année!";
	main_allowed = "{0}^3 autorisé sur ce serveur";
	main_notallowed = "{0}^3 non autorisé sur ce serveur";
	main_tolowhand1 = "{0}^3 spectateur car handicap trop faible";
	main_tolowhand2 = "^3Requis {0}kg et {1}% de limitation à l'admission!";
	main_vote_restart1 = "Redémarrer:";
	main_vote_restart2 = "({0}/{1}) Requis {2}";
	main_vote_qualify1 = "Qualify";
	main_vote_qualify2 = "({0}/{1}) Requis {2}";
	main_vote_end1 = "Finir:";
	main_vote_end2 = "({0}/{1}) Requis {2}";
	main_car_changed = "La voiture a changé, Allez aux pits! Voiture = {0}";
	main_track_changed1 = "Changement de circuit, patientez!";
	main_track_changed2 = "Circuit actuel = {0}";
	main_left_server = "{0} part du serveur";
	main_great1 = "Superbe 1er split ({0}) par {1}^8!";
	main_good1 = "Bon 1er split ({0}) par {1}^8!";
	main_great2 = "Superbe 2ème split ({0}) par {1}^8!";
	main_good2 = "Bon 2ème split ({0}) par {1}^8!";
	main_great3 = "Superbe 3ème split ({0}) par {1}^8!";
	main_good3 = "Bon 3ème split ({0}) par {1}^8!";
	main_greatlap = "Superbe tour ({0}) par {1}^8!";
	main_goodlap = "Bon tour ({0}) par {1}^8!";
	main_help1 = "^2Liste des commandes";
	main_help = "^2Commandes générales"
			. "&^3!myconfig ^8Configurer lapper pour vous"
			. "&^3!mypb ^8Liste de vos records"
			. "&^3!ps ^8Vos infos pubstat or !ps userName"
			. "&^3!who ^8Stats des joueurs connectés"
			. "&^3!top ^8[table offset] [3-letter car name] ['filter' pattern]"
			. "&^3!drf ^8[table offset] [3-letter car name] ['filter' pattern]"
			. "&^3!stats ^8[playername pattern]"
			. "&^3!dstats ^8[playername pattern]"
			. "&^3!near ^8Liste des records centrés sur vous"
			. "&^3!spb ^8Temps des splits et meilleurs temps théoriques TPB (Theoretical PB)"
			. "&^3!razspb ^8Remise à zéro des temps de session"
			. "&^3!track ^8Nom du circuit actuel"
			. "&^3!time ^8Heure du serveur (pour les championnats)"
			. "&^3!ver ^8Version de LFSLapper"
			. "&"
			. "&^2Commandes spéciales ligue"
			. "&^3!topqual ^8Position des pilotes participant à la qualification"
			. "&^3!statsqual ^8Votre position de préqualification actuelle"
			. "&"
			. "&^2Nouvelles fonctions"
			. "&^3!laps ^8Totaux des nombres de tours, par session et pour le serveur"
			. "&^3!hand ^8Handicaps requis"
			. "&^3!pit ^8Temps total passée aux stands"
			. "&^3!closepb ^8Fermer Pitboard de manière temporaire"
			. "&^3!config ^8Configure Pitboard"
			. "&^3!ctrack ^8Ouvre la platine d'administration du serveur(Seulement Admins)"
			. "&^3!pitwindow ^8Montre les ouvertures de stand"
			. "&^3!pwgui ^8Ouvre la platine des ouvertures de stands (seulement Admins)"
			. "&^3!sc ^8Ouvre la platine de la safetycar (seulement Admins)";
	main_flood = "{0}^3 kické car trop de flood";
	main_on_result = "Position finale = {0}";
	main_lost_control = "^1Danger! ^8{0} ^2a perdu le contrôle!";
	main_toslow1 = "Vous être trop lent! Max : {0}";
	main_toslow2 = "Vous serez kické dans {0}";
	main_toslowvery1 = "Vous êtes vraiment trop lent, spectateur!";
	main_toslowvery2 = "{0} est trop lent, spectateur!";
	main_idle1 = "^3Vous êtes inactif et passerez spectateur dans 10 secondes" ;
	main_idle2 = "^3Vous êtes passé spectateur car inactif!";
	main_onnewpb = "Nouveau PB par {0}^8 ({1}): {2}";
	main_onnewpb_rank = "Position absolue : {0}";
	main_onnewpb_sesslaps = "Tours réalisés durant la session = {0}";
	main_onnewpb_servlaps = "Tours réalisés sur le serveur = {0}";
	main_onnewpb_avgspeed = "Vitesse moyanne: {0}{1}";
	main_onnewpb_rank2 = "Voiture {0} position: ^7{1}";
	main_onnewpbqual = "Ligue - Nouveau temps de qualif par {0}^8:{1}";
	main_onnewpbqual_rank = "Position absolue: ^7{0}";
	main_onnewpbqual_pos = "^2Position Qualifiquation.: {0}";
	main_onnewpbqual_pool = "^6Poule actuelle: {0}";
	main_onnewpbqual_avgspeed = "Vitesse moyenne: {0}{1}";
	main_onnewpbqual_posqual = "{0} ^2Pos:{1} - Poule:{2}";
	main_accel = "^8De 0 à {1}{2} en ^3{0}^8 secondes!";
	main_notpitwindow = "{0} ^1Stand fermés, ouverture entre {1}-{2}";
	main_inpitwindows = "{0} ^1Vous êtes autorisé à pitter";
	main_outpitwindows = "{0}  ^1Vous n'êtes pas autorisé à pitter";
	main_beginpit = "{0}^8 s'arrête au stand";
	main_pitwork = "Début d'arrêt au stand! Travail en cours:{0}";
	main_fastdrivepitl1_1 = "{0}^1Attention vitesse excessive aux stands";
	main_fastdrivepitl1_2 = "^1ATTENTION-KICK POSSIBLE" ;
	main_fastdrivepitl2_1 = "{0}^1Spectateur car trop rapide dans les stands";
	main_fastdrivepitl2_2 = "^1ENCORE {0} ESSAIS AVANT LE KICK" ;
	main_maxfastdrivepit1 = "{0}^1Kické car trop rapide dans les stands";
	main_maxfastdrivepit2 = "^1VOUS ETES KICKE";
	main_maxreset = "{0} mis en spectateur pour excès de reset de voiture";
	main_oncarreset = "Reset de voiture par {0} au tour {1}";
	main_specwarn = "^1Attention mise en spectateur";
	main_resetrest = "^2Il vous reste^3 {0} ^2reset de voiture";
	main_close = "Fermer";
	main_psdistance = "^7Distance: ^2{0} ^7{1}";
	main_psfuel = "^7Essence consommée: ^2{0} ^7liters ";
	main_pslaps = "^7Tours réalisés: ^2{0}";
	main_pswins = "^7Victoires: ^2{0}";
	main_pssecond = "^7Secondes places: ^2{0}";
	main_psthird = "^7Troisièmes places: ^2{0}";
	main_psfinished = "^7Courses termiée: ^2{0}";
	main_psquals = "^7Qualifications réalisées: ^2{0}";
	main_pspole = "^7Poles réalisées: ^2{0}";

	built_pos = "Position";
	built_grp = "Poule";
	built_car = "Voiture";
	built_track = "Circuit";
	built_nick = "Pseudo";
	built_pb = "PB";
	built_split = "Split";
	built_splits = "Splits";
	built_points = "Points";
	built_nolfspb = "Les record de LFS World ne sont pas encore récupérés";
	built_nolfspbcrit = "Pas de records LFS World pour ce critère";
	built_lapsdone = "Tours réalisés";
	built_hand_nick = "^9 Handicap pour ^3{0}^9 :";
	built_hand_curr = "  - Actuel {0}Kg - Restr. admission.: {1}%";
	built_hand_req =  "  - Requis {0}^9 {1}Kg - Restr. admission.: {2}%";
EndLang

