/*
    LFSRelax, Insim Utilities for Live For Speed Game
    Copyright (C) 2007  Robert B. alias Gai-Luron and Monkster: lfsgailuron@free.fr

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
using System;
using System.Collections.Generic;
using System.Text;
using ISMB;
using TSR;


namespace TSView
{
    class TSView
    {
        bool flagConnected = false;
        int currChannelID = 0;
        bool SeeHimSelf = false;
        int Lbutton = 0;
        int Tbutton = 0;
        int Wbutton = 0;
        int Hbutton = 0;
        InSim.Connect insimConnection;

        System.Collections.ArrayList plSpeak = new System.Collections.ArrayList();
        insimButton[] listButton = new insimButton[6];


        public TSView(InSim.Connect pInsimConnection, int pLbutton, int pTbutton, int pWbutton, int pHbutton, bool pSeeHimSelf )
        {
            TSRemote.TtsrVersion TSInfo = TSRemote.ClientVersion;
            this.SeeHimSelf = pSeeHimSelf;
            this.Hbutton = pHbutton;
            this.Tbutton = pTbutton;
            this.Hbutton = pHbutton;
            this.Wbutton = pWbutton;
            this.insimConnection = pInsimConnection;
            Console.WriteLine("Connected to TeamSpeak version: " + TSInfo.Major + "." + TSInfo.Minor + "." + TSInfo.Release + "." + TSInfo.Build);
            for (int i = 0; i < 6; i++)
            {
                listButton[i] = new insimButton(insimConnection, Lbutton, Tbutton + (i * Hbutton), Wbutton, Hbutton, 0, (int)InSim.BTN_style.ISB_LIGHT | 3, "", "");
            }

        }
        public void display()
        {
                if (TSRemote.ServerInfo.ChannelCount == 0)
                {
                    flagConnected = false;
                }
                if (flagConnected == false)
                {
                    if (TSRemote.ServerInfo.ChannelCount != 0)
                    {
                        Console.WriteLine("Host: " + TSRemote.ServerInfo.ServerHost);
                        Console.WriteLine("Ip: " + TSRemote.ServerInfo.ServerIp);
                        Console.WriteLine(TSRemote.ServerInfo.WelcomeMessage);
                        currChannelID = TSRemote.UserInfo.Player.ChannelID;
                        flagConnected = true;
                    }
                }

                if (flagConnected)
                {
                    plSpeak.Clear();
                    TSRemote.TtsrPlayerInfo[] pi = new TSRemote.TtsrPlayerInfo[0];
                    TSRemote.TtsrChannelInfo ci = TSRemote.GetChannelInfo(currChannelID, ref pi);
                    int[] spID = TSRemote.SpeakerIds;
                    for (int i = 0; i < spID.GetUpperBound(0) + 1; i++)
                    {
                        for (int j = 0; j < pi.Length; j++)
                        {
                            if (pi[j].PlayerID == spID[i])
                            {
                                if (SeeHimSelf || pi[j].PlayerID != TSRemote.UserInfo.Player.PlayerID)
                                    plSpeak.Add(pi[j].NickName);
                            }
                        }
                    }
                    // Erase all button
                    for (int i = 0; i < 6; i++)
                    {
                        listButton[i].hide();
                    }
                    for (int i = 0; i < plSpeak.Count; i++)
                    {
                        listButton[i].buttonText = plSpeak[i].ToString();
                        listButton[i].show();
                        if (i > 5)
                            break;
                    }
                }
            }        
    }
}
