/*
    LFSRelax, Insim Utilities for Live For Speed Game
    Copyright (C) 2007  Robert B. alias Gai-Luron and Monkster: lfsgailuron@free.fr

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
using System;
using System.Text;
using System.Collections;



namespace LFSRelax
{

    public class infoPlayer
    {
        public class nodeLap
        {
            public int lap;
            public long Time;
            public nodeLap(int P_Lap, long P_Time)
            {
                this.lap = P_Lap;
                this.Time = P_Time;
            }
        }
        public int UCID;
        public int PLID;
        public string userName;
        public string nickName;
        public bool demoPlayer = false;
        public long splitLast;
        public long[] split = new long[(int)paramLapper.maxSplit];
        public long Ltime = 0;
        public long PermLtime = 0;
        public int lapDone = 0;
        public double totDistMeter = 0;
        public string PBDate;
        public string PBTime;
        public long[] PBSplit = new long[(int)paramLapper.maxSplit];
        public long[] infoPBSplit = new long[(int)paramLapper.maxSplit];
        public long[] PBBestSplitDiff = new long[(int)paramLapper.maxSplit];
        public long[] infoSessBestSplitDiff = new long[(int)paramLapper.maxSplit];
        public long PBBestSplitDiffLast;
        public long infoSessBestSplitDiffLast;


//        public long currSplit;
//        public long diffSplit;
//        public long bestSplit;
        public bool newSessBestSplit;
        public bool newPBBestSplit;
        public bool newWRBestSplit;

        public int position;
        public int laps;
        public double bestSpeed;
        public string CName;
        public long PBLTime;
        public long infoPBLTime;
        public bool isNewPBLtime;
        public int oldNode;
        public float currFuel = -1;
        public float lastLapFuel = 0;
        public float usedFuel = 0;
        public bool reserveFuel = false;
        public bool forceFuelNotify = true;
        public bool forceLastLapFuel = false;
        public double old_X;
        public double old_Y;
        public double old_Z;
        public bool accelerationInProgress;
        public System.DateTime timeSinceZeroSpeed;
        public System.TimeSpan accelerationTime;
        public bool accelerationTimeValid;
        public double avgSpeed = 0;

        //        public System.Collections.ArrayList nodeTime = new System.Collections.ArrayList();
        public nodeLap[] nodeTime = new nodeLap[2000];



        public static string lfsStripColor(string str)
        {
            str = str.Replace("^0", "")
                        .Replace("^1", "")
                        .Replace("^2", "")
                        .Replace("^3", "")
                        .Replace("^4", "")
                        .Replace("^5", "")
                        .Replace("^6", "")
                        .Replace("^7", "")
                        .Replace("^8", "")
                        .Replace("^9", "")
                        .Replace("^O", "")
                        .Replace("^a", "*")
                        .Replace("^c", ":")
                        .Replace("^d", "\\")
                        .Replace("^l", "<")
                        .Replace("^q", "?")
                        .Replace("^r", ">")
                        .Replace("^s", "/")
                        .Replace("^t", "\"")
                        .Replace("^v", "|")
                        .Replace("^^", "^")
                        .Replace("^L", "")
                        .Replace("^G", "")
                        .Replace("^C", "")
                        .Replace("^J", "")
                        .Replace("^E", "")
                        .Replace("^M", "")
                        .Replace("^T", "")
                        .Replace("^B", "")
                ;
            return str;
        }


        public infoPlayer(int SUCID, string Susername, string Snickname, string SProduct )
        {
//For demo player Only            
            if (Susername == null || Susername == "" || SProduct == "DEMO")
            {
                Susername = Snickname;
                this.demoPlayer = true;
            }
            else
            {
                this.demoPlayer = false;
            }
            this.UCID = SUCID;
            this.PLID = -1;
            this.userName = Susername;
            this.nickName = Snickname;

            this.CName = "";
            this.PBLTime = 0;
            this.position = 0;
            this.laps = 0;

        }
        public void updateSplit(int Split, long STime, string track)
        {
            long sessDiffSplit;

            int idxSplit = Split - 1;
            // Clear Last Split on first Split
            if (idxSplit == 0)
                this.splitLast = 0;

            this.split[idxSplit] = STime;
            if (Split == 1)
            {
                this.split[1] = 0;
                this.split[2] = 0;
            }
            long currDiffSplit = STime - this.splitLast;

            sessDiffSplit = currDiffSplit - this.PBBestSplitDiff[idxSplit];
            if (sessDiffSplit < 0 || this.PBBestSplitDiff[idxSplit] == 0)
            {
                this.PBBestSplitDiff[idxSplit] = currDiffSplit;
                this.newPBBestSplit = true;
            }
            else
            {
                this.newPBBestSplit = false;
            }
            infoSessBestSplitDiff[idxSplit] = sessDiffSplit;
            infoPBSplit[idxSplit] = this.split[idxSplit] - PBSplit[idxSplit];
            this.splitLast = STime;
        }
        public void updateLap(long LTime, int lapDone, bool isMph, string track )
        {
            long sessDiffSplit;

            this.lapDone = lapDone;

            this.laps += 1;

            this.newPBBestSplit = false;

            long currDiffSplit = LTime - this.splitLast;

            this.Ltime = LTime;
            this.PermLtime = LTime;
            sessDiffSplit = currDiffSplit - this.PBBestSplitDiffLast;
            if (currDiffSplit < this.PBBestSplitDiffLast || this.PBBestSplitDiffLast == 0)
            {
                this.PBBestSplitDiffLast = currDiffSplit;
                this.newPBBestSplit = true;
            }
            infoSessBestSplitDiffLast = sessDiffSplit;
            this.splitLast = 0;
            this.infoPBLTime = Ltime - this.PBLTime;
            if (LTime < this.PBLTime || this.PBLTime == 0)
            {
                this.PBLTime = LTime;
                for (int i = 0; i < (int)paramLapper.maxSplit; i++)
                {
                    this.PBSplit[i] = this.split[i];
                }
                this.newPBBestSplit = true;
                this.PBDate = System.DateTime.Now.ToShortDateString();
                this.PBTime = System.DateTime.Now.ToShortTimeString();

            }
            if (this.lastLapFuel != -1)
            {
                this.usedFuel = this.lastLapFuel - this.currFuel;
//                Console.WriteLine("Fuel = " + this.currFuel + " Used = " + this.usedFuel + " Total = " + (this.currFuel + this.usedFuel));
            }
            this.lastLapFuel = this.currFuel;

            this.avgSpeed = this.getSpeed(isMph, wr.getAvgSpeed(track, LTime));
        }
        public double getSpeed(bool isMph, double speed)
        {
            if (!isMph)
                return speed;
            else
                return speed / 1.609344;
        }

        public void clearSessionInfo()
        {
            this.raznode();
        }
        public void raznode()
        {
            for (int i = 0; i < 2000; i++)
                nodeTime[i] = null;
        }
        public void raz()
        {

            this.splitLast = 0;
            for (int i = 0; i < (int)paramLapper.maxSplit; i++)
            {
                this.split[i] = 0;
            }
            this.Ltime = 0;
            this.PermLtime = 0;
            this.lapDone = 0;
            this.position = 0;
            this.oldNode = 0;
            this.old_X = 0;
            this.old_Y = 0;
            this.old_Z = 0;
            this.raznode();
        }
        public void UpdateState(double x, double y, double z, double speed, double direction, double heading, double anglevelocity, int node, int Vposition, int currLap, double accelStartSpeed, double accelEndSpeed)
        {

            if (speed > this.bestSpeed)
                this.bestSpeed = speed;
            this.position = Vposition;
            long toto = DateTime.Now.Ticks / TimeSpan.TicksPerMillisecond;
            if (node < 2000)
            {
                this.nodeTime[node] = new nodeLap( currLap, toto );
            }

//            this.totDistmeter += distOneNode;
            if (old_X != 0 && old_Y != 0 && old_Z != 0)
            {
                double diffx = this.old_X - x;
                double diffy = this.old_Y - y;
                double addMeter = Math.Sqrt((diffx * diffx) + (diffy * diffy));
                this.totDistMeter += addMeter;
            }
            this.old_X = x;
            this.old_Y = y;
            this.old_Z = z;
            if ( speed < accelStartSpeed/*0.1*/)
            {
                this.timeSinceZeroSpeed = System.DateTime.Now;
                this.accelerationInProgress = true;
               //System.Console.WriteLine("measurement started");
            }
            else if (speed > accelEndSpeed/*100*/ && this.accelerationInProgress)
            {
                this.accelerationTime = System.DateTime.Now - this.timeSinceZeroSpeed;
                this.accelerationInProgress = false;
                this.accelerationTimeValid = true;
            }

        }
        public void Rename( string newnick )
        {
            this.nickName = newnick;
            if( this.demoPlayer )
                 this.userName = newnick;
        }
        //public void updateSaved(LFS.PlayerStats plys)
        //{
        //    if (plys != null)
        //    {
        //        this.PBLTime = plys.personalBestLapTime;
        //        this.PBDate = plys.datePb;
        //        this.PBTime = plys.timePb;
        //        this.PBSplit[0] = plys.splitTime[0];
        //        this.PBSplit[1] = plys.splitTime[1];
        //        this.PBSplit[2] = plys.splitTime[2];
        //        this.laps = plys.laps;
        //        this.PBBestSplitDiff[0] = plys.PBBestSplitDiff[0];
        //        this.PBBestSplitDiff[1] = plys.PBBestSplitDiff[1];
        //        this.PBBestSplitDiff[2] = plys.PBBestSplitDiff[2];
        //        this.PBBestSplitDiffLast = plys.PBBestSplitDiffLast;
        //    }
        //    else
        //    {
        //        this.PBLTime = 0;
        //        this.PBDate = "";
        //        this.PBTime = "";
        //        this.PBSplit[0] = 0;
        //        this.PBSplit[1] = 0;
        //        this.PBSplit[2] = 0;
        //        this.laps = 0;
        //        this.PBBestSplitDiff[0] = 0;
        //        this.PBBestSplitDiff[1] = 0;
        //        this.PBBestSplitDiff[2] = 0;
        //        this.PBBestSplitDiffLast = 0;
        //    }
        //}

    }

    public class listPlayers
    {
        public Hashtable playersUCID = new Hashtable();
        public Hashtable playersPLID = new Hashtable();
        public void newPlayer(int UCID, string username, string nickname, string Product )
        {
            playersUCID[UCID] = new infoPlayer(UCID,username,nickname, Product );
        }
        public infoPlayer getPlayerByUCID(int UCID)
        {
            if (playersUCID.ContainsKey(UCID))
                return (infoPlayer)playersUCID[UCID];
            else
                return null;
        }
        public infoPlayer getPlayerByPLID(int PLID)
        {
            if (playersPLID.ContainsKey(PLID))
                return (infoPlayer)playersPLID[PLID];
            else
                return null;
        }
        public void getPlayerByPLID2(infoPlayer currInfoPlayer, int PLID)
        {
            if (playersPLID.ContainsKey(PLID))
            {
                currInfoPlayer = (infoPlayer)playersPLID[PLID];
            }
        }
        public void removePlayer(int UCID)
        {
            if ((playersUCID[UCID] as infoPlayer).PLID != -1)
                playersPLID.Remove((playersUCID[UCID] as infoPlayer).PLID);
            playersUCID.Remove(UCID);
        }
        public void removeIndexPLID(int PLID)
        {
            (playersPLID[PLID] as infoPlayer).PLID = -1;
            playersPLID.Remove(PLID);
        }

        public void majIndexPLID(int UCID, int PLID )
        {
            playersPLID[PLID] = playersUCID[UCID];
            (playersUCID[UCID] as infoPlayer).PLID = PLID;
        }
        public void raceRestart()
        {
            foreach (DictionaryEntry de in playersUCID)
            {
                infoPlayer p = (infoPlayer)de.Value;
                p.raz();
            }
        }
        public void changeTrack()
        {
            foreach (DictionaryEntry de in playersUCID)
            {
                infoPlayer p = (infoPlayer)de.Value;
                p.totDistMeter = 0;
                p.old_X = 0;
                p.old_Y = 0;
                p.old_Z = 0;
            }
        }
        public void removeAllPlayer()
        {
            playersPLID.Clear();
            playersUCID.Clear();
        }

    }
}
