#define MONO



using System;
using System.Net;
using System.Net.Sockets;
namespace OutGauge
{
    public class Connect
    {
        public bool connected = false;
        public string Product;
        public string Version;
        public int InSimVersion;
        private System.Net.Sockets.UdpClient uc;
        Socket _socket = new Socket(AddressFamily.InterNetwork, SocketType.Dgram, ProtocolType.Udp);
        System.Net.IPEndPoint remoteEP = new System.Net.IPEndPoint(System.Net.IPAddress.Any, 29998);



        public Connect()
        {
        }
        public void OutGaugeConnect(string host, int port, string adminPassword, string mode, string nameApp, bool isLocal)
        {
            _socket.Bind(remoteEP);
        }
        public void Send(byte[] outMsg, int Length)
        {
            _socket.Send(outMsg);
        }
        public bool Available
        {
            get
            {
                if (_socket.Available > 0)
                    return true;
                else
                    return false;
            }

        }
        public byte[] Receive()
        {
            if( _socket.Available > 0 ){
                byte[] ret = new byte[ _socket.Available ];
                _socket.Receive( ret );
                return ret;
            }
            return null;
        }
        public void Close()
        {
            _socket.Close();
        }
    }


	public class Decoder
	{
		/// <summary>
		/// Version packet decoder
		/// </summary>
        static int pakGetByte(byte[] pak, int first)
        {
            return (int)pak[first];
        }
        static string pakGetString(byte[] pak, int first, int len)
        {
            return InSim.CodePage.GetString(pak, first, len);
        }
        static int pakGetWord(byte[] pak, int first)
        {
            return (int)System.BitConverter.ToUInt16(pak, first);
        }
        static int pakGetShort(byte[] pak, int first)
        {
            return (int)System.BitConverter.ToInt16(pak, first);
        }
        static long pakGetUnsigned(byte[] pak, int first)
        {
            return (long)System.BitConverter.ToUInt32(pak, first);
        }
        static int pakGetInt(byte[] pak, int first)
        {
            return (int)System.BitConverter.ToInt32(pak, first);
        }
        static float pakGetFloat(byte[] pak, int first)
        {
            return (float)System.BitConverter.ToSingle(pak, first);
        }
        public class OUTGAUGE
        {
            public readonly int ReqI;
            public readonly string SubT;

            public OUTGAUGE(byte[] packet)
            {
            }
        }



	}
}

