/*
    LFSRelax, Insim Utilities for Live For Speed Game
    Copyright (C) 2007  Robert B. alias Gai-Luron and Monkster: lfsgailuron@free.fr

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
using System;
using System.Collections;
using System.Text;
using System.Net;
using System.IO;


namespace LFSRelax
{
    class wr
    {
        static System.Collections.Hashtable trackTable = new System.Collections.Hashtable();

        public class wrInfo
        {
            public string track;
            public string CName;
            public long WRTime;
            public long[] split = new long[3];
            public long[] sectorSplit = new long[3];
            public long sectorSplitLast;

            public wrInfo(string track, string CName, long WRTime, long split1, long split2, long split3, long sectorSplit1, long sectorSplit2, long sectorSplit3, long sectorSplitLast)
            {
                this.track = track;
                this.CName = CName;
                this.WRTime = WRTime;
                this.split[0] = split1;
                this.split[1] = split2;
                this.split[2] = split3;
                this.sectorSplit[0] = sectorSplit1;
                this.sectorSplit[1] = sectorSplit2;
                this.sectorSplit[2] = sectorSplit3;
                this.sectorSplitLast = sectorSplitLast;
            }
        }
        public class trackInfo : System.IComparable
        {
            public string track;
            public System.Collections.Hashtable carTable = new System.Collections.Hashtable();
            public trackInfo(string track)
            {
                this.track = track;
            }
            public int CompareTo(object x)
            {
                if (string.Compare((x as trackInfo).track, this.track) < 0)
                    return 1;
                else if (string.Compare((x as trackInfo).track, this.track) > 0)
                    return -1;
                else
                    return 0;
            }
        }
        public static double lenTrack(string track)
        {
            string cp = track.Substring(0, 3);
            switch (cp)
            {
                case "BL1":
                    return 3.4;
                case "BL2":
                    return 2.0;
                case "SO1":
                    return 2.0;
                case "SO2":
                    return 2.0;
                case "SO3":
                    return 1.3;
                case "SO4":
                    return 4.0;
                case "SO5":
                    return 3.1;
                case "FE1":
                    return 1.6;
                case "FE2":
                    return 3.1;
                case "FE3":
                    return 3.5;
                case "FE4":
                    return 6.6;
                case "FE5":
                    return 2;
                case "FE6":
                    return 0.7;
                case "KY1":
                    return 3.0;
                case "KY2":
                    return 5.1;
                case "KY3":
                    return 7.4;
                case "WE1":
                    return 5.2;
                case "AS1":
                    return 1.9;
                case "AS2":
                    return 3.1;
                case "AS3":
                    return 5.6;
                case "AS4":
                    return 8.1;
                case "AS5":
                    return 8.8;
                case "AS6":
                    return 8.0;
                case "AS7":
                    return 5.2;
                default:
                    return 0.0;
            }
        }
        static public double getAvgSpeed(string track, long STime)
        {
            double retVal = 0;

            if (track != "" && track != null)
                retVal = lenTrack( track ) * timeConv.HMSToLong("60.00.00") / STime;
            return retVal;
        }

        static string convTrack(string track)
        {
            string retValue = "";
            switch (track[0])
            {
                case '0':
                    retValue = "BL";
                    break;
                case '1':
                    retValue = "SO";
                    break;
                case '2':
                    retValue = "FE";
                    break;
                case '3':
                    retValue = "AU";
                    break;
                case '4':
                    retValue = "KY";
                    break;
                case '5':
                    retValue = "WE";
                    break;
                case '6':
                    retValue = "AS";
                    break;
            }
            retValue += (int.Parse(track[1].ToString()) + 1).ToString();
            if (track[2] == '1')
                retValue += "R";
            return retValue;
        }
        public static wrInfo getWR(string track, string CName )
        {
            wrInfo wi;
            try
            {
                trackInfo tt = (trackTable[track] as trackInfo);
                wi = (wrInfo)tt.carTable[CName];
                return wi;
            }
            catch { return null; }

        }
        public static bool load(string user, string pass, string idk)
        {
            string readLine;

            long split1 = 0;
            long split2 = 0;
            long split3 = 0;
            long lastSplit = 0;
            long sectorSplit1 = 0;
            long sectorSplit2 = 0;
            long sectorSplit3 = 0;
            long sectorSplitLast = 0;
            long WRTime = 0;


            string url;
            if (idk == "" && user == "" && pass == "")
            {
                return false;
            }
            if (idk != "")
                url = "http://www.lfsworld.net/pubstat/get_stat2.php?version=1.3&idk=" + idk + "&action=wr";
            else
                url = "http://www.lfsworld.net/pubstat/get_stat2.php?version=1.3&user=" + user + "&pass=" + pass + "&action=wr";
            WebRequest req = WebRequest.Create(url);
            WebResponse result = req.GetResponse();
            Stream receiveStream = result.GetResponseStream();
            using (StreamReader sr = new StreamReader(receiveStream))
            {
                while (true)
                {
                    readLine = sr.ReadLine();
                    if (readLine == null)
                        break;
                    if (readLine.IndexOf("Identification") != -1)
                        return false;
                    if (readLine.IndexOf("can't") != -1)
                        return false;
                    string[] mline = readLine.Split(' ');
                    string track = convTrack( mline[1] );
                    string car = mline[2];
                    lastSplit = 0;
                    sectorSplit1 = 0;
                    sectorSplit2 = 0;
                    sectorSplit3 = 0;
                    sectorSplitLast = 0;
                    split1 = long.Parse(mline[3]);
                    sectorSplit1 = split1 - lastSplit;
                    lastSplit = split1;

                    split2 = long.Parse(mline[4]);
                    if( split2 != 0 ){
                        sectorSplit2 = split2 - lastSplit;
                        lastSplit = split2;
                    }

                    split3 = long.Parse(mline[5]);
                    if( split3 != 0 ){
                        sectorSplit3 = split3 - lastSplit;
                        lastSplit = split3;
                    }
                    WRTime = long.Parse(mline[6]);
                    sectorSplitLast = WRTime - lastSplit;
                    if (!trackTable.ContainsKey(track))
                    {
                        trackTable[track] = new trackInfo(track);
                    }
                    trackInfo tt = (trackTable[track] as trackInfo);
                    if (!tt.carTable.ContainsKey(car))
                    {
                        tt.carTable[car] = new wrInfo(track, car, WRTime, split1, split2, split3, sectorSplit1, sectorSplit2, sectorSplit3, sectorSplitLast );
                    }
                }
            }
            return true;
        }
    }
}
