/*
    LFSRelax, Insim Utilities for Live For Speed Game
    Copyright (C) 2007  Robert B. alias Gai-Luron and Monkster: lfsgailuron@free.fr

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
using System;
using System.Text;
using System.Timers;

namespace ISMB
{
    class insimButton
    {
        static bool flagFirst = true;
        static bool[] isUsed = new bool[255];
        InSim.Connect insimConnection;
        public int T = 0;
        public int L = 0;
        public int W = 10;
        public int H = 30;
        public int nbBlink = -1;
        public int nbSecondVisible = -1;
        int lclickID = -1;
        bool isShowed = false;
        public int BStyle = (int)InSim.BTN_style.ISB_LIGHT;
        public int TypeIn = 0;
        public string buttonText = "Not initialised";
        public string oldButtonText = "Not initialised";
        public string caption = "Not initialised";
        bool visibleBlink = true;
        
        Timer tim;


        ~insimButton()
        {
            isUsed[this.clickID] = false;
        }

        public insimButton(string id, InSim.Connect IC, string coord, int P_TypeIn, int P_BSTyle, string P_caption, string P_buttonText)
        {
            int[] coordSplit = new int[4];
            string[] sCoord = coord.Split(',');
            try
            {
                for (int i = 0; i < 4; i++)
                    coordSplit[i] = int.Parse(sCoord[i]);
            }
            catch
            {
                throw new System.Exception(string.Format("Wrong format coord button ('{1}')",id));
            }
            this.SetInsimButton(IC, coordSplit[0], coordSplit[1], coordSplit[2], coordSplit[3], P_TypeIn, P_BSTyle, P_caption, P_buttonText);
        }
        public insimButton(InSim.Connect IC, int P_L, int P_T, int P_W, int P_H, int P_TypeIn, int P_BSTyle, string P_caption, string P_buttonText)
        {
            this.SetInsimButton(IC, P_L, P_T, P_W, P_H, P_TypeIn, P_BSTyle, P_caption, P_buttonText);
        }
        public insimButton(InSim.Connect IC)
        {
            this.SetInsimButton(IC, 0, 0, 10, 30, 0, (int)InSim.BTN_style.ISB_LIGHT, "Not initialised", "Not initialised");

        }
        public void SetInsimButton( InSim.Connect IC, int P_L, int P_T, int P_W, int P_H, int P_TypeIn, int P_BSTyle, string P_caption, string P_buttonText )
        {
// First Time all button are unused
            if (flagFirst)
            {
                flagFirst = false;
                for (int i = 0; i < 255; i++)
                    isUsed[i] = false;
            }
// Find first unused button
            for (int i = 1; i < 239; i++)
            {
                if (isUsed[i] == false)
                {
                    isUsed[i] = true;
                    this.lclickID = i;
                    break;
                }
            }
            if (this.lclickID > 200)
            {
              // Console.WriteLine("Je collecte");
               // GC.Collect();
            }
            this.L = P_L;
            this.T = P_T;
            this.W = P_W;
            this.H = P_H;
            this.TypeIn = P_TypeIn;
            this.BStyle = P_BSTyle;
            this.caption = P_caption;
            this.buttonText = P_buttonText;
            this.insimConnection = IC;
            this.isShowed = false;
//           Console.WriteLine(this.clickID);

            tim = new Timer();
            tim.Interval = 1000;
            tim.Elapsed += new ElapsedEventHandler(blink);
            tim.Start();

        }
        public void blink(object source, ElapsedEventArgs e)
        {
            if (this.nbBlink != -1 && this.isShowed )
            {
                nbBlink--;
                if (visibleBlink)
                    this.lhide(0);
                else
                    this.lshow(0);
                if (nbBlink == 0)
                {
                    this.lshow(0);
                    nbBlink = -1;
                }
            }
            if (this.isShowed && nbSecondVisible != -1)
            {
                nbSecondVisible--;
                if (nbSecondVisible < 0)
                    this.hide(0);
            }
            visibleBlink = !visibleBlink;
        }
        public void updateText()
        {
            if (this.oldButtonText != this.buttonText || this.isShowed == false)
            {
                this.oldButtonText = this.buttonText;
                this.show();
            }
        }
        public void show()
        {
            this.show(0);
        }
        public void show(int P_UCID)
        {
            this.lshow(P_UCID);
            this.isShowed = true;
        }
        void lshow(int P_UCID)
        {
            byte[] btn = InSim.Encoder.BTN(1, this.L, this.T, this.W, this.H, P_UCID, this.lclickID, this.BStyle, this.TypeIn, this.caption, this.buttonText);
            insimConnection.Send(btn, btn.Length);
        }
        public void hide()
        {
            this.hide(0);
            this.isShowed = false;
        }
        public void lhide(int P_UCID)
        {
            if (this.isShowed)
            {
                byte[] bfn = InSim.Encoder.BFN(0, 0, P_UCID, this.lclickID);
                insimConnection.Send(bfn, bfn.Length);
            }
        }
        public void hide(int P_UCID)
        {
            this.lhide(P_UCID);
            this.isShowed = false;
        }
        public int clickID
        {
            get
            {
                return lclickID;
            }
        }
    }
}
