"""Example 6: OutGauge

Simple example that receives OutGauge packets and checks the shift-light and 
pitlane speed limiter flags.

"""
import pyinsim

# Event-handler for OutGaugePack.
def outgaugePacket(out, og):
    # Check shift-light flag.
    if og.ShowLights & pyinsim.DL_SHIFT:
        print 'Shift-light on'
    if og.ShowLights & pyinsim.DL_PITSPEED:
        print 'Pitland speed limiter on'

# Event-handler called if OutGauge times out.
def outgaugeTimeout(out, timeout):
    print 'OutGauged timed out in', timeout, 'seconds'
    
# Initailise OutGauge object and bind events.
out = pyinsim.OutGauge(timeout=10.0)
out.bind(pyinsim.ISP_OUTGAUGE, outgaugePacket)
out.bind(pyinsim.EVT_TIMEOUT, outgaugeTimeout)

# Start OutGauge listener.
try:
    out.start('localhost', 30000)
    out.run()
except pyinsim.socket.error, err:
    print 'OutGauge Error:', err[1]