"""Example 5: MCI updates

A simple example of dealing the MCI (multi-car info) packets. We loop through
each car in the MCI packet and check the speed of each one. If a car goes above
80 KPH the player is spectated and a chat message is sent.

"""

import pyinsim

# Dict to store players list.
players = {}

# Add player to players dict.
def playerJoined(insim, npl):
    players[npl.PLID] = npl
    
# Delete player from players dict.
def playerLeft(insim, pll):
    del players[pll.PLID]
    
# MCI update event-handler.
def carUpdate(insim, mci):
    # Loop through each car in the MCI packet.
    for car in mci.CompCars: 
        # Get player from PLID.
        npl = players[car.PLID]
        
        # Convert speed to KPH.
        kph = pyinsim.speedToKph(car.Speed)
        if kph > 80:
            # Send command to spectate player.
            insim.send(pyinsim.ISP_MST, Msg='/spec %s' % npl.PName)
            # Send message to chat.
            insim.send(pyinsim.ISP_MST, Msg='%s ^3spectated for speeding!' % npl.PName)
            
insim = pyinsim.InSim()

# Bind events.
insim.bind(pyinsim.ISP_NPL, playerJoined)
insim.bind(pyinsim.ISP_PLL, playerLeft)
insim.bind(pyinsim.ISP_MCI, carUpdate)

try:
    insim.connect('localhost', 29999)
    
    # To activate MCI updates we must set the ISF_MCI flag and also the Interval
    # in milliseconds at which updates will be sent.
    insim.send(pyinsim.ISP_ISI, Admin='pass', IName='^3pyinsim', 
               Flags=pyinsim.ISF_MCI, Interval=100)
               
    # Request players to be sent.
    insim.send(pyinsim.ISP_TINY, ReqI=1, SubT=pyinsim.TINY_NPL)
    
    insim.run()
except pyinsim.socket.error, err:
    print 'InSim Error:', err[1]