"""Example 2: Event Handling

Connect to InSim and request a IS_VER version packet to be sent. 

"""

import pyinsim

# Event-handler which is called when an IS_VER packet is received.
def versionCheck(insim, ver):
    # Check InSim version against pyinsim's built-in INSIM_VERSION constant.
    if ver.InSimVer == pyinsim.INSIM_VERSION:
        print 'InSim connected (LFS: %s InSim: %d)' % (ver.Product, ver.InSimVer)
    else:
        print 'Invalid InSim version detected'
        insim.close()
        
# Event-handler which is called when an EVT_CLOSED event occurs.
def insimClosed(insim, reason):
    # Check the close reason.
    if reason == pyinsim.CLOSE_REQUEST:
        print 'Connection closed by call to InSim.close()'
    elif reason == pyinsim.CLOSE_LFS:
        print 'Connection closed as LFS closed'
    
insim = pyinsim.InSim()

# Bind the ISP_VER packet event to our versionCheck event-handler.
insim.bind(pyinsim.ISP_VER, versionCheck)

# Bind the EVT_CLOSED event-handler.
insim.bind(pyinsim.EVT_CL0SED, insimClosed)

try:
    insim.connect('localhost', 29999)
    
    # By setting ReqI to non-zero InSim sends a IS_VER packet on connecting.
    insim.send(pyinsim.ISP_ISI, ReqI=1, Admin='pass', IName='^3pyinsim')
    
    insim.run()
except pyinsim.socket.error, err:
    print 'InSim Error:', err[1]