"""Example 1: Hello, InSim!

Connect to InSim and send the message 'Hello, InSim!' to the chat.

"""

import pyinsim

try:
    # Create new InSim object.
    insim = pyinsim.InSim()
    
    # Connect to InSim.
    insim.connect('localhost', 29999)
    
    # Send initialsation packet.
    insim.send(pyinsim.ISP_ISI, ReqI=0, UDPPort=0, Flags=0, Prefix='!', 
               Interval=0, Admin='pass', IName='^3pyinsim')
               
    # Send message 'Hello, InSim!' to the chat.
    insim.send(pyinsim.ISP_MST, Msg='^3Hello, InSim!')
               
    # Stop console from exiting while connection is active.        
    insim.run()
except pyinsim.socket.error, err:
    # Catch any errors.
    print 'InSim error:', err[1]