"""Example 3: Managing the connections list.

We store the connection and player lists in dictionaries, with the UCID and 
PLID as the dictionary keys. After connecting we request for all connections
and players to be sent by LFS to populate our lists.

"""

import pyinsim

# Dicts to store connection and player lists.
connections = {}
players = {}

# Add connection to connections dict.
def connectionJoined(insim, ncn):
    connections[ncn.UCID] = ncn
    
# Delete connection from connections dict.
def connectionLeft(insim, cnl):
    del connections[cnl.UCID]

# Add player to players dict.
def playerJoined(insim, npl):
    players[npl.PLID] = npl
    
# Delete player from players dict.
def playerLeft(insim, pll):
    del player[pll.PLID]
    
# Update player name and plate.
def playerRenamed(insim, cpr):
    ncn = connections[cpr.UCID]
    npl = filter(lambda p: p.UCID == cpr.UCID, players)[0]
    ncn.PName = cpr.PName
    npl.PName = cpr.PName
    npl.Plate = cpr.Plate
    
# Update players UCID.
def tookOverCar(insim, toc):
    npl = players[toc.PLID]
    npl.UCID = toc.NewUCID
    
insim = pyinsim.InSim()

# Bind our packet events.
insim.bind(pyinsim.ISP_NCN, connectionJoined)
insim.bind(pyinsim.ISP_CNL, connectionLeft)
insim.bind(pyinsim.ISP_NPL, playerJoined)
insim.bind(pyinsim.ISP_PLL, playerLeft)
insim.bind(pyinsim.ISP_CPR, playerRenamed)
insim.bind(pyinsim.ISP_TOC, tookOverCar)

try:
    insim.connect('localhost', 29999)
    insim.send(pyinsim.ISP_ISI, Admin='pass', IName='^3pyinsim')
    
    # Request for all NCN and NPL packets to be sent by LFS.
    insim.send(pyinsim.ISP_TINY, ReqI=1, SubT=pyinsim.TINY_NCN)
    insim.send(pyinsim.ISP_TINY, ReqI=1, SubT=pyinsim.TINY_NPL)
    
    insim.run()
except pyinsim.socket.error, err:
    print 'InSim Error:', err[1]