/*
You can use config var inEvent of Sub using this array var
$ConfVar["NameOfVar"]

To use $Host Var in your script type:
$ConfVar["Host"]

This is case sensitive

List of All variable that can be used in player events or in other event if you have username
This can be retreived with function:
GetCurrentPlayerVar( idOfVar )
GetPlayerVar( username, idOfVar )

example:
$CurrNickName = GetCurrentPlayerVar( "NickName" );
$SpecificNickName = GetPlayerVar( "gai-luron","NickName" );

Nickname		-> Nickname
Username		-> UserName
Laps			-> Total number of laps done on the current track and with the current car
SessLaps		-> Total number of laps done this session on current track and with the current car
TotalPitTime		-> Totaltime used for a pit stop
Car			-> Current car of the player
Posabs			-> Current absolute position
Posqual			-> Current qualification position
Groupqual		-> Current group qualification
SwearWordsRem		-> Remaining number of swearwords to be used before OnSwearWords2 is triggered
H_Mass			-> Current Required Handicap User mass
H_TRes			-> Current Required Handicap Restriction
P_Mass			-> Current player Mass
P_TRes			-> Current player restriction
SplitTime		-> Last Split time done by player
LapsDone		-> Laps done for the current player in current qualification/race

Split1			-> Last First Split, updated when doing new Split1
Split2			-> Last First Split, erased when doing Split1
Split3			-> Last First Split, erased when doing Split1
LapTime			-> Current Lap Time, erased when doing New LapTime
PBLapTime		-> Current PB on current Combo
diffLapTimeToPB		-> Laptime - PBLTime, Last PBLTime is new realised

SectorSplit1		-> Last First sector Split, updated when doing new Split1
SectorSplit2		-> Last second sector Split, erased when doing Split1
SectorSplit3		-> Last third sector Split, erased when doing Split1
SectorSplitLast		-> Last Last sector Split, erased when doing Split1

BestSectorSplit1	-> Best Split duration for the sector 1
BestSectorSplit2	-> Best Split duration for the sector 2
BestSectorSplit3	-> Best Split duration for the sector 3
BestSectorSplitLast	-> BestSplit duration for the last sector

DiffSectorSplit1	-> $SectorSplit1 - $BestSectorSplit1
DiffSectorSplit2	-> $SectorSplit2 - $BestSectorSplit2
DiffSectorSplit3	-> $SectorSplit3 - $BestSectorSplit3
DiffSectorSplitLast	-> $SectorSplitLast - $BestSectorSplitLast

isBestSectorSplit1	-> 1 if this sector split is best than previous Best, otherwise 0
isBestSectorSplit2	-> 1 if this sector split is best than previous Best, otherwise 0
isBestSectorSplit3	-> 1 if this sector split is best than previous Best, otherwise 0
isBestSectorSplitLast	-> 1 if this sector split is best than previous Best, otherwise 0

BestSpeed		-> Best Speed done on this combo by player
UnitSpeed		-> Speedunit of the current player
AvgSpeed		-> Avg Speed on last Lap Time
Tpb			-> Theoretical PB
DriftScore		-> Drift score
typ			-> {typ} - = "Sess" if split PB for Session "PB" if split PB for PB file;
AngleVelocity		-> Last Angle velocity in degrees
LastDriftScore		-> Last drift score
AccelerationTime	-> Acceleration time achieved from start to end speed
MaxAllowedLapTime1	-> Max Allowed Time before trigger Event OnMaxAllowedLapTime1
MaxAllowedLapTime2	-> Max Allowed Time before trigger Event OnMaxAllowedLapTime2
Dist			-> Distance done on current combo/track by player
SessDist		-> Distance done on current combo/track by player this session

pitWork			-> Work do on car on the pit
PlayerFlags		-> Flag(s) for the current player

RemainFDIP		-> Remain count for fast drive in pit

Pos			-> display the current position of the player
UNameBefore		-> the username of the player before you in race
UNameBehind		-> the username of the player behind you in race
GapBefore		-> gap between you and the player before you in race in mm.ss.hh
GapBehind		-> gap between you and of the player behind you in race in mm.ss.hh

FinishedPos		-> finish or qualify pos (1 = win / 256 = not added to table)
RaceTotalTime		-> race time (ms) the use of NumToMsh is needed
RacePBTime		-> race time (ms) the use of NumToMsh is needed

CurrNode		-> is the node on the track where the player is, -1 is player is not on track


List of all variables that can be used in all events
This can be retreived with function:
getLapperVar( idOfVar )

example:
$CurrTrack = getLapperVar( "LongTrackName" );

RotateIn		-> Races remaining before Rotation
HostName		-> Current host Name
ShortTrackName		-> Track Name in Short format : SO6
LongTrackName		-> Track Name in long format : South City Chicane
ShortTime		-> Server Time in short format
LongTime		-> Server Time in long format
ShortDate		-> Date in short format
LongDate		-> Date in long format
CurrRotateCar		-> Current rotated Car
CurrRotateTrack		-> Current rotated Track
CurrLongRotateTrack	-> Current rotated Track
NextRotateCar		-> Next rotated Car
NextRotateTrack		-> Next rotated Track
NextLongRotateTrack	-> Next rotated Track
RequiredFlags		-> Flag(s) required on this server

Additionnal variable that can be used in OnAuthReached.

$auth			-> Authorization reached
*/

/*
Command block to run when a LFS Special event is triggered
Event EventId()
...
EndEvent

Command block used by backcall command like button or scheduled action or when received a command by player
Sub SubId()
...
EndSub

RegisterScheduleAction( "0 0 0 * * * *", SA_mid );
	You can register a subfunction to call when a time is reached
	Firts arg = cron format ss mm hh dayOfWeek dd MM YYYY
	dayOfWeek start at 0 = Sunday
	Second arg = Sub to call when player type this text

Command allowed on Event and Sub

cmdLFS("Command_text");
	Send a command to Lapper, see command.txt in LFS Doc

privMsg( "Message_text");
	Send a private message to the player that has triggered the event

openPrivButton( "help",25,28,150,10,5,-1,0,"^2Commands list" );
openPrivButton( "help",25,28,150,10,5,-1,0,"^2Commands list", backcall );
	Open a button for the current player
	1 - Unique id for this button
	2 - Left coordinate for this button ( 0-200 )
		$origL = (value between 0-200); - when this value is used, every next value can be made relative to this one (example: $origL + 5;)
	3 - Top coordinate for this button ( 0-200 )
		$origT = (value between 0-200); - when this value is used, every next value can be made relative to this one (example: $origT + 5;)
	4 - Width of the button ( 0-200 )
	5 - Heigth of the button ( 0-200 )
	6 - Space between line in multiline button
	7 - Duration in seconds for the button to be displayed (use -1 if you don't want an automatic close)
	8 - Format of the button, look at insim.txt for values
	9 - Button caption, for multiline, separate each line with &
	10 - Option name of the backcalled sub
	
Backcalled Sub receive the keyboardflag to have the key pressed when click
// CFlags byte : click flags

			1		// left click
			2		// right click
			4		// ctrl + click
			8		// shift + click
			
			if left click and right click, you receive 2 + 1 = 3

closePrivButton("welc&pos&clos&ref");
	Close one or more button(s), you specify ID of the button to close, multiple ID's have to be separated by a &

openGlobalButton( "bargr1",60,1,10,6,6,30,96,"Restart:" );
	Same as openPrivButton, but open button for all players connected

closeGlobalButton("welc&pos&clos&ref");
	Same as closePrivButton, but close button for all players connected

WriteLine( "My test");
	To display message on the Lapper console with carriage return
Write( "My test");
	To display message on the Lapper console without carriage return

There are another functions, look in config file

Codes that can be used on button format:

0 - transparent button
16 - light button
32 - dark button
64 - align text to left
128 - align text to right

If you want to make a light colored button with text aligned to the left, combine the codes to one new code, for example 16+64 = 80
*/

/*
To create colored text, use the following codes in front of the text you want to color:

^0 - black
^1 - red
^2 - green
^3 - yellow
^4 - blue
^5 - violet
^6 - cyan
^7 - white
^8 - no color

Other variables that could be used on expressions
&&			-> and
||			-> or
+			-> plus
-			-> minus
/			-> devide
*			-> multiply
^			-> pow
==			-> equal to
!=			-> not equal to
>			-> bigger then
<			-> smaller then
<=			-> smaller then and equal to
>=			-> bigger then and equal to
*/

#################
#General options#
#################

$Password = "yourpass"; # Put in the admin password used on the LFS Server

$StoredValueDbs = "storedvalue"; # Name of the database in which additional values are stored

$TrackInfoFile = "trackInfo.cfg"; # Path to the TrackInfoFile used to compare splits

$TCPmode = true; # Connection to LFS in UDP mode or TCP mode

$EnableRegisterWeb = true; # When set to "true" your LFS Server is displayed on the FRH Team website

# To receive a notification via mail when an error occur on Lapper
$adminEmail = "";
$smtpServer = "";
$loginMail = "";
$passMail = "";

$DateFormat = "dd/MM/yyyy";
$LongDateFormat = "dddd dd MMMM yyyy";
				# Date format used for the exported elp files
				# Look at C#-format for date/time, little help
				# HH = Hour in 0-23 format
				# hh = Hour in 0-12 format
				# mm = Minute
				# tt = PM or AM
				# dd = Day
				# MM = Month
				# yyyy = year with 4 digits

$MessageTime = 5000; # Time in milliseconds for a racecontrol message (started by: rcm_all) to be displayed on screen

#$PubStatIdk = "";	# Indentification code for a connection to PubStat.
			# To obtain a PubStatId go to www.lfsworld.net , select My LFSW Setting, tab Pubstat Access
			# Remove # before PubStatIdK to activate this option

$ShowPlayerControl = False; # Set option to "true" if you want to show the control configuration of players when leaving the pits.

##############
#FTP transfer#
##############
# Results files can also be transferred to an FTP server
# Define the following parameters to use this feature
# Remove # before line to activate it
# -------------------------------------------------------------------

#$FtpServer = "your ftp server"; # Name/IP-address of your FTP server
#$FtpLogin = "your login"; # Loginname for your FTP server
#$FtpPasswd = "your password"; # Password for your FTP server
#$FtpRemotePath = "your remote dir"; # Directorname

#############
#Default Car#
#############
# Default car to show, when no car is specified in command !top or !drf and when a player haven't used a car on this server
# You can combine several cars by using + (example: "XFG+XRG";)
# -------------------------------------------------------------------

#$DefaultTopCar = "UF1";
#$DefaultTopCar = "XFG";
#$DefaultTopCar = "XRG";
$DefaultTopCar = "XRT";
#$DefaultTopCar = "RB4";
#$DefaultTopCar = "FXO";
#$DefaultTopCar = "LX4";
#$DefaultTopCar = "LX6";
#$DefaultTopCar = "RAC";
#$DefaultTopCar = "FZ5";
#$DefaultTopCar = "MRT";
#$DefaultTopCar = "XFR";
#$DefaultTopCar = "UFR";
#$DefaultTopCar = "FOX";
#$DefaultTopCar = "FO8";
#$DefaultTopCar = "FXR";
#$DefaultTopCar = "XRR";
#$DefaultTopCar = "FZR";
#$DefaultTopCar = "BF1";
#$DefaultTopCar = "FBM";

###################################
#Event triggered when lapper start#
###################################
Sub DisplaySpeed( )
#	PrivMsg("SpeedTrap = " . ToPlayerUnit( GetCurrentPlayerVar( "InstantSpeed" ) . " " . GetCurrentPlayerVar("UnitSpeed"));
	cmdLfs( "/msg SpeedTrap = " . GetCurrentPlayerVar( "InstantSpeed")  . " kph or  " .  ToMph( GetCurrentPlayerVar( "InstantSpeed") ) . " Mph" );

EndSub
Event OnLapperStart()
	RegisterScheduleAction( "0 0 0 * * * *", SA_mid );
	RegisterScheduleAction( "0 0 0 * 1 1 *", SA_newyear );
	
	RegisterNodeAction( "BL1" , 140 , DisplaySpeed );
	RegisterNodeAction( "BL1R" , 245 , DisplaySpeed );

	RegisterZoneAction( "BL1" , -78,200, 5 , DisplaySpeed );


#	MoveUserToGroup( "admin" , "Gai-Luron");

	GlobalVar $enable_pitboard;
	GlobalVar $enable_pitwindow_gui;
	GlobalVar $enable_safetycar_gui;
	GlobalVar $enable_ctrack_gui;
	GlobalVar $enable_config_gui;

	initAddons();

	IF ( $enable_pitboard == "true" )
	THEN
		OnLapperStart_Pitboard();
	ENDIF

	IF ( $enable_ctrack_gui == "true" )
	THEN
	  OnLapperStart_Ctrack();
	ENDIF
	IF ( $enable_config_gui == "true" )
	THEN
		OnLapperStart_config_Gui();
	ENDIF

EndEvent

Sub SA_mid() # Lapper Event
	cmdLFS("/rcm Midnight warning to all working men!");
	cmdLFS("/rcm_all");
EndSub

Sub SA_newyear() # Lapper Event
	cmdLFS("/rcm Happy New Year!");
	cmdLFS("/rcm_all");
EndSub

###################################
#Authorization Options ( license )#
###################################
#Authorization Options
#
#$Auth1 $Auth2 ... $Auth10 variable
#Syntax : $AuthX = "Label,Carname:Trackname:MinimumTime&Carname:Trackname:MinimumTime&...| Carname:Trackname:MinimumTime&Carname:Trackname:MinimumTime&... | ...";
#& -> And condition
#| -> Or condition
#
#$AuthAllowPlayer="Auth1|...|AuthX|@username1,username2,...,usernameN";
#or
#$AuthAllowPlayer="All";
#-------------------------------------------------------------------

#$Auth1 = "Bronze,XFG:BL1:1.45.00 | XRT:SO4:1.20.20";
#$Auth2 = "Silver,XFG:BL1:1.40.00 | XRT:SO4:1.20.20";
#$Auth3 = "Gold,XFG:BL1:1.35.00";

$AuthAllowPlayer = "All";

$AuthMinPlayer = 0;	# Minimum number of players on the server to auto enable authorization
			# If number of players is below value, alle players are allowed
			# If number of players is above value, only AuthAllowPlayer are allowed

Event OnAuthAllowed() # Player event
	cmdLFS( "/msg "  . GetCurrentPlayerVar("Nickname") . "^3 allowed on this server" );
Endevent

Event OnAuthNotAllowed() # Player event
	cmdLFS("/spec "  . GetCurrentPlayerVar("Nickname") );
	cmdLFS("/msg " . GetCurrentPlayerVar("Nickname") . "^3 not allowed on this server");
Endevent

# Local viariable that can be used
# $auth -> Authorization reached

Event OnAuthReached( $level ) # Player event
	privMsg("^3You have got level: " . $level );
EndEvent

##################
#Swearword filter#
##################
#Specify a list of swearwords seperated by ,
#Specify a file with swearwords, one word per line
#-------------------------------------------------------------------

$SwearWordsList = "fuck,asholes,bastard,idiot";
#$SwearWordsList = "&./swear.txt";
$SwearWordsMax = 2; # Maximum number of allowed swearwords per session

Event OnSwearWords1() # Player event
	privMsg( "^1Don't use this words on this server" );
	privMsg( "You will be spectated in ^2" . GetCurrentPlayerVar("SwearWordsRem") . " ^1 more attempt(s)" );
EndEvent

Event OnSwearWords2()  # Player event
	privMsg( "Too many swearwords, spectated" );
	cmdLFS( "/spec " . GetCurrentPlayerVar("Nickname") );
EndEvent

###########
#Handicaps#
###########
#You can specify 3 levels of handicap : for car, for car and track, for user
#Priority Level low to hight : HandicapCars, HandicapCarsTracks, HandicapUser
#-------------------------------------------------------------------
#Handicap cars
#
#Syntax :
#
#$HandicapCars = "car:mass:irest,car:mass:irest,...,car:mass:irest";
#
#car : LFS short car name
#mass : mass handicap in kg
#irest : Air intake restriction in percent
#-------------------------------------------------------------------
#Handicap cars/tracks
#
#Syntax :
#
#$HandicapCarsTracks = "car/track:mass:irest,car/track:mass:irest,...,car/track:mass:irest";
#
#car : LFS short car name
#track : LFS short track name
#mass : mass handicap in kg
#irest : Air intake restriction in percent
#-------------------------------------------------------------------
#$HandicapUser		# a list of players and their handicap
#			# if you prefix with & , You can indicate a file name that contains a list of racers, one racer per line
#			# if you prefix with @, You can list username separated with ,
#
#Syntax :
#
#$HandicapUsers = "&./your_file";
#$HandicapUsers = "@userName:mass:irest,userName:mass:irest,...userName:mass:irest";
#
#$RefreshHandicapUsers	# allow Lapper to refresh HandicapUsers on each player leaving pits
			# Usefull if HandicapUsers is a file and is updated frequently by an external program
#-------------------------------------------------------------------

#$HandicapCars = "XFG:100:10,XRT:50:10";

#$HandicapCarsTracks = "XFG/BL1:100:10,XRT/AS1:50:10";

#$RefreshHandicapUsers = true;
#$HandicapUsers = "&./your_hand.flt";
#$HandicapUsers = "@Gai-Luron:100:20,gwendoline:100:30,_-ALUCARD-_,lagamel:50:10,lister88,c-quad,shimanofr,bruno7529,boby5,kevinb,edgar,berlioz,la tortue,neron59,eur-can,stff,2psbob,oliv76000";


Event OnToLowHandicap() # Player event
	cmdLFS("/spec " . GetCurrentPlayerVar("Nickname") );
	cmdLFS("/msg " . GetCurrentPlayerVar("Nickname") . "^3 spectated for to low handicap" );
	cmdLFS("/msg ^3need " . GetCurrentPlayerVar( "H_Mass" ) . "kg and " . GetCurrentPlayerVar("H_TRes") . "% of intake restriction!");
EndEvent

#################
#Control Allowed#
#################
# Racer flags
# "Y" = Yes
# "N" = No
# "*"" = Yes or No
# Local variable
#-------------------------------------------------------------------

$SwapSide = "*";
$AutoGears = "*";
$Shifter = "*";
$HelpBrake = "*";
$AxisClutch = "*";
$AutoClutch = "*";
$Mouse = "*";
$KbNoHelp = "*";
$KbStabilised = "*";
$CustomView = "*";

Event OnNotMatchFlags( ) # Player event
	privMsg( "Flags not match required flags" );
	privMsg("Yours flags -> " . GetCurrentPlayerVar("PlayerFlags") );
	privMsg("Required flags -> " . GetLapperVar( "RequiredFlags" ) );
	privMsg("Spectated" );
	cmdLFS("/spec " . GetCurrentPlayerVar("Username") );
EndEvent

##############
#Race Control#
##############
#Voting:
#
#$InRaceLapsVoteMinMax = Laps in between where votes are allowed in race
#$InRaceLapsVoteMinMax = 0-0 Votes are never allowed
#$InRaceLapsVoteMinMax = -5 Votes are allowed between lap 1 and 5
#$InRaceLapsVoteMinMax = 2- Votes are allowed between laps 2 and the end of the race
#$InRaceLapsVoteMinMax = - Votes are always allowed
#
#$VoteRestart = percentage of players that have to vote to restart a race. To let LFS admin this function, set it to -1
#OnVoteRestartChange = Command to do when player votes to restart
#OnVoteRestartReach = Command to execute when VoteRestart is reached
#OnVoteRestartZero = Command to execute when no nb of player reach zero

#$VoteQualify = percentage of players that have to vote to start a qualification. To let LFS admin this function, set it to -1
#OnVoteQualifyChange = same as restart but for qualify
#OnVoteQualifyReach = same as restart but for qualify
#OnVoteQualifyZero = same as restart but for qualify
#
#$VoteEnd = percentage of players that have to vote to end a race. To let LFS admin this function, set it to -1
#OnVoteEndChange = same as restart but for endrace
#OnVoteEndReach = same as restart but for endrace
#OnVoteEndyZero = same as restart but for endrace
#-------------------------------------------------------------------
#Local variable:
#
#$Vote - Number of players that have voted
#$Remain - Number of players remaining to vote
#$Need - Number of players needed for an action
#$VoteLifeSec = Number of seconds to keep the vote alive after voting
#-------------------------------------------------------------------
#Auto restart:
#
#$AutoRestartRaceSec = Second between the end of a race (last player finished) and an automatic restart
#
#Rotation only work if AutoRestartRaceSec is set
#EnableRotation =	Allow or disallow rotation for track and/or car
#			Values : true or false
#$RotateTracks = "tracks to rotate"; separated by ','
#$RotateCars = "cars to rotate"; separated by ',' Use LFS definition for car, if not set, no car rotation
#$RotateEveryNbRaces = Number of races to do before rotation;
#-------------------------------------------------------------------

$InRaceLapsVoteMinMax = "-";

$VoteRestart = -1;

Event OnVoteRestartChange($PlayerOnTrack, $Vote , $Need) # Lapper Event
	openGlobalButton( "bargr1",60,1,10,6,6,30,96,"Restart:" );
	openGlobalButton( "bargr2",70,1,20,6,6,30,96,"(" . $Vote ."/" . $PlayerOnTrack . ") Need " . $Need );
EndEvent

Event OnVoteRestartReach($PlayerOnTrack, $Vote , $Need) # Lapper Event
	closeGlobalButton( "bargr1&bargr2" );
EndEvent

Event OnVoteRestartZero() # Lapper Event
	closeGlobalButton( "bargr1&bargr2" );
EndEvent

$VoteQualify = -1;

Event OnVoteQualifyChange($PlayerOnTrack, $Vote , $Need) # Lapper Event
	openGlobalButton( "bargq1",90,1,10,6,6,30,96,"Qualify" );
	openGlobalButton( "bargq2",100,1,20,6,6,30,96,"(" . $Vote . "/" . $PlayerOnTrack . ") Need " . $Need );
EndEvent

Event OnVoteQualifyReach($PlayerOnTrack, $Vote , $Need) # Lapper Event
	closeGlobalButton("bargq1&bargq2" );
EndEvent

Event OnVoteQualifyZero() # Lapper Event
	closeGlobalButton("bargq1&bargq2" );
EndEvent

$VoteEnd = -1;

Event OnVoteEndChange($PlayerOnTrack, $Vote , $Need) # Lapper Event
	openGlobalButton( "barge1",120,1,10,6,6,30,96,"End:" );
	openGlobalButton( "barge2",130,1,20,6,6,30,96,"(" . $Vote . "/" . $PlayerOnTrack . ") Need " . $Need );
EndEvent

Event OnVoteEndReach($PlayerOnTrack, $Vote , $Need) # Lapper Event
 	closeGlobalButton( "barge1&barge2" );
EndEvent

Event OnVoteEndZero() # Lapper Event
 	closeGlobalButton( "barge1&barge2" );
EndEvent

$VoteLifeSec = 30;

$AutoRestartRaceSec = 0;

$EnableRotation = false;
$RotateTracks = "SO6R,BL1,FE3";
$RotateEveryNbRaces = 4;
$RotateCars = "XFG+UF1,TBO,XFR+UFR";

Event OnRotateCar() # Lapper Event
 	cmdLFS("/msg Car changed, go to pit! Current car = " . getLapperVar( "CurrRotateCar" );
EndEvent

Event OnRotateTrack() # Lapper Event
 	cmdLFS("/msg Track changed, please wait!" );
	cmdLFS("/msg Current Track = " . getLapperVar( "CurrLongRotateTrack" );
EndEvent

#################################################
#Connect messages when a player joins the server#
#################################################

Event OnConnect() # Player event
	$NickName = GetCurrentPlayerVar("NickName");
	$Posabs = GetCurrentPlayerVar("Posabs");
	$Groupqual = GetCurrentPlayerVar("Groupqual");

	openPrivButton( "welc",25,50,150,15,12,-1,0,"^7Welcome " .  $NickName . " ^7to ^1LFSLapper ^7powered server !&^2Type ^7!help ^2after leaving garage to see commands." );
	openPrivButton( "pos",25,80,150,10,8,-1,0,"^7Your actual friendly Position (all visitors) : ^7" . $Posabs
		. "&^2Your actual League prequalify Position : " . $Posqual . " ^6Estimate Pool : " . $Groupqual
		. "&Don't use swearwords on this server"
		. "&respect other player"
		. "&otherwise you can be banned "
	);
	openPrivButton( "clos",78,120,20,10,10,-1,32,"Accept",OnConnectClose );
	openPrivButton( "ref",103,120,20,10,10,-1,32,"Deny",OnConnectCloseKick );
	http("http://www.frh-team.net/reglapper/getserver2.php" );

	IF ( $enable_pitboard == "true" )
	THEN
	  OnConnect_Pitboard();
	ENDIF
EndEvent

Sub OnConnectClose( $KeyFlags,$id )
	closePrivButton("welc&pos&clos&ref");

	IF ( $enable_pitboard == "true" )
	THEN
	  OnConnectClose_Pitboard();
	ENDIF
EndSub

Sub OnConnectCloseKick( $KeyFlags,$id )
	closePrivButton("welc&pos&clos&ref");
	cmdLFS("/kick " . GetCurrentPlayerVar("UserName") );
EndSub

##########################################
#New PLayer joining race or leaving pits)#
##########################################

Event OnNewPlayerJoin()
	IF ( $enable_pitboard == "true" )
	THEN
	  OnNewPlayerJoin_Pitboard();
	ENDIF
EndEvent

#####################################################
#DisConnect messages when a player leaves the server#
#####################################################

Event OnDisConnect() # Player event
	cmdLFS( "/msg " . GetCurrentPlayerVar("NickName") . " left the server" );

	IF ( $enable_pitboard == "true" )
	THEN
	  OnDisConnect_Pitboard();
	ENDIF
EndEvent


#############################################$#
#Splitting (general action when passing split)#
###############################################

Event OnSplit1() # Player event
EndEvent

Event OnSplit2() # Player event
EndEvent

Event OnSplit3() # Player event
EndEvent

Event OnLap() # Player event
EndEvent

#############################################
#Action when a new Gapping Info is avaiaible#
#############################################

/*
openPrivButton( "help",25,28,150,10,5,-1,0,"^2Commands list", backcall );
	Open a button for the current player
	1 - Unique id for this button
	2 - Left coordinate for this button ( 0-200 )
		$origL = (value between 0-200); - when this value is used, every next value can be made relative to this one (example: $origL + 5;)
	3 - Top coordinate for this button ( 0-200 )
		$origT = (value between 0-200); - when this value is used, every next value can be made relative to this one (example: $origT + 5;)
	4 - Width of the button ( 0-200 )
	5 - Heigth of the button ( 0-200 )
	6 - Space between line in multiline button
	7 - Duration in seconds for the button to be displayed (use -1 if you don't want an automatic close)
	8 - Format of the button, look at insim.txt for values
	9 - Button caption, for multiline, separate each line with &
	10 - Option name of the backcalled sub
*/

Event OnNewGapPlayerBefore( $split )

	IF ( $enable_pitboard == "true" )
	THEN
	  OnNewGapPlayerBefore_Pitboard( $split );
	ELSE
	  $y = 187;
	  $x = 62;

	  IF( GetCurrentPlayerVar( "UNameBefore" ) != "" )
	  THEN
	    $nickName = GetPlayerVar( GetCurrentPlayerVar( "UNameBefore" ),"nickName" );
	    $larg = 15;
	    openPrivButton("Before1",$x,$y,$larg,5,10,-1,32, "Before: " );
	    $x = $x + $larg;
	    $larg = 30;
	    openPrivButton("Before2",$x,$y,$larg,5,10,-1,32, $nickName );
	    $x = $x + $larg;
	    $larg = 30;
	    openPrivButton("Before3",$x,$y,$larg,5,10,-1,32, GetCurrentPlayerVar( "GapBefore" ));
	  ELSE
	    closePrivButton( "Before1");
	    closePrivButton( "Before2");
	    closePrivButton( "Before3");
	  ENDIF
	ENDIF
EndEvent

Event OnNewGapPlayerBehind( $split )
	IF ( $enable_pitboard == "true" )
	THEN
	  OnNewGapPlayerBehind_Pitboard( $split );
	ELSE
	  $y = 195;
	  $x = 62;

	  IF( GetCurrentPlayerVar( "UNameBehind" ) != "" )
	  THEN
	    $nickName = GetPlayerVar( GetCurrentPlayerVar( "UNameBehind" ),"nickName" );
	    $larg = 15;
	    openPrivButton("behind1",$x,$y,$larg,5,10,-1,32, "Behind: " );
	    $x = $x + $larg;
	    $larg = 30;
	    openPrivButton("behind2",$x,$y,$larg,5,10,-1,32, $nickName );
	    $x = $x + $larg;
	    $larg = 30;
	    openPrivButton("behind3",$x,$y,$larg,5,10,-1,32, GetCurrentPlayerVar( "GapBehind" ));
	  ELSE
	    closePrivButton( "behind1");
	    closePrivButton( "behind2");
	    closePrivButton( "behind3");
	  ENDIF
	ENDIF
EndEvent

#######################################################
#Splitting (compare player split to best player split)#
#######################################################

$ShowSplitPB = true; # Set to false if you don't want to see messages about splits

Event OnSpbSplit1() # Player event
	IF ( $enable_pitboard == "true" )
	THEN
	  OnSpbSplit1_Pitboard();
	ELSE
	  IF( GetCurrentPlayerVar("isBestSectorSplit1") == 1 )
	  THEN
	    $color = "^2";
	  ELSE
	    $color = "^1";
	  ENDIF
	  openPrivButton( "id_spb",50,55,100,10,10,5,0,$typ
		. " ^7SP1"
		. ": " . NumToMSH( GetCurrentPlayerVar("SectorSplit1")) . " "
		. $color
		. "(" . NumToMSH( GetCurrentPlayerVar("DiffSectorSplit1")) . ")"
		. "&^7TPB:" . NumToMSH(GetCurrentPlayerVar("Tpb")) );
	ENDIF
EndEvent

Event OnSpbSplit2() # Player event
	IF ( $enable_pitboard == "true" )
	THEN
	  OnSpbSplit2_Pitboard();
	ELSE
	  IF( GetCurrentPlayerVar("isBestSectorSplit2")  == 1 ) # Player event
	  THEN
	    $color = "^2";
	  ELSE
	    $color = "^1";
	  ENDIF
	  openPrivButton( "id_spb",50,55,100,10,10,5,0,$typ
		. " ^7SP2"
		. ": " . NumToMSH(GetCurrentPlayerVar("SectorSplit2")) . " "
		. $color
		. "(" . NumToMSH( GetCurrentPlayerVar("DiffSectorSplit2")) . ")"
		. "&^7TPB:" . NumToMSH(GetCurrentPlayerVar("Tpb")) );
	ENDIF
EndEvent

Event OnSpbSplit3() # Player event
	IF ( $enable_pitboard == "true" )
	THEN
	  OnSpbSplit3_Pitboard();
	ELSE
	  IF( GetCurrentPlayerVar("isBestSectorSplit3")  == 1 )
	  THEN
	    $color = "^2";
	  ELSE
	    $color = "^1";
	  ENDIF
	  openPrivButton( "id_spb",50,55,100,10,10,5,0,$typ
		. " ^7SP3"
		. ": " . NumToMSH(GetCurrentPlayerVar("SectorSplit3")) . " "
		. $color
		. "(" . NumToMSH( GetCurrentPlayerVar("DiffSectorSplit3")) . ")"
		. "&^7TPB:" . NumToMSH(GetCurrentPlayerVar("Tpb")));
	ENDIF
EndEvent

Event OnSpbLast() # Player event
	IF ( $enable_pitboard == "true" )
	THEN
	  OnSpbLast_Pitboard();
	ELSE
	  IF( GetCurrentPlayerVar("isBestSectorSplitLast")  == 1 )
	  THEN
	    $color = "^2";
	  ELSE
	    $color = "^1";
	  ENDIF
	  openPrivButton( "id_spb",50,55,100,10,10,5,0,$typ
		. " ^7SPL: "
		. NumToMSH( GetCurrentPlayerVar("SectorSplitLast")) . " "
		. $color
		. "(" . NumToMSH(GetCurrentPlayerVar("DiffSectorSplitLast"))
		. ")&^7TPB:" . NumToMSH(GetCurrentPlayerVar("Tpb")) . " Avg:" . ToPlayerUnit( GetCurrentPlayerVar("AvgSpeed") ) . " " . GetCurrentPlayerVar("UnitSpeed") );
	ENDIF
EndEvent

####################################################
#Actions to do on splits relative to trackinfo.cfg#
####################################################
#Local variable: {SplitTime} - Split time
#-------------------------------------------------------------------

Sub TRI_split1_0() # Player event
	cmdLFS( "/msg Great 1st split (" . NumToMSH(GetCurrentPlayerVar("SplitTime")) . ") by " . GetCurrentPlayerVar("Nickname") . "^8!" );
EndSub

Sub TRI_split1_1() # Player event
	cmdLFS( "/msg Good 1st split (" . NumToMSH(GetCurrentPlayerVar("SplitTime")) . ") by " . GetCurrentPlayerVar("Nickname") . "^8!" );
EndSub

Sub TRI_split2_0() # Player event
	cmdLFS( "/msg Great 2nd split (" . NumToMSH(GetCurrentPlayerVar("SplitTime")) . ") by " . GetCurrentPlayerVar("Nickname") . "^8!" );
EndSub

Sub TRI_split2_1() # Player event
	cmdLFS( "/msg Good 2nd split (" . NumToMSH(GetCurrentPlayerVar("SplitTime")) . ") by " . GetCurrentPlayerVar("Nickname") . "^8!" );
EndSub

Sub TRI_split3_0() # Player event
	cmdLFS( "/msg Great 3rd split (" . NumToMSH(GetCurrentPlayerVar("SplitTime")) . ") by " . GetCurrentPlayerVar("Nickname") . "^8!" );
EndSub

Sub TRI_split3_1() # Player event
	cmdLFS( "/msg Good 3rd split (" . NumToMSH(GetCurrentPlayerVar("SplitTime")) . ") by " . GetCurrentPlayerVar("Nickname") . "^8!" );
EndSub

Sub TRI_lap_0() # Player event
	cmdLFS( "/msg Great lap (" . NumToMSH( GetCurrentPlayerVar("LapTime") ) . ") by " . GetCurrentPlayerVar("Nickname" ) . "^8!" );
EndSub

Sub TRI_lap_1() # Player event
	cmdLFS( "/msg Good lap (" . NumToMSH( GetCurrentPlayerVar("LapTime") ) . ") by " . GetCurrentPlayerVar("Nickname") . "^8!" );
EndSub

#########################
#List of user qualifying#
#########################
#RefreshQualUsers : allow Lapper to refresh QualUsers on each outgoing pits, Usefull if QualUsers is a file and this is changed frequently by an external program
#QualUser : is a list of racers that participed in the qualification, required for function !nearqual !topqual and !statsqual
#if you prefix with & , You can indicate a file name that contains a list of racers, one racer per line (example : QualUsers = ./userfile.txt;)
#if you prefix with @, You can list usernames separated with ',' (example : QualUsers = @Gai-Luron,gwendoline,_-ALUCARD-_,lagamel;)
#You can specify which car is used by a user adding car after username separated by ':' (example : Gai-Luron:XFR,lagamel:UFR)
#You can specify the scheme of group of this qualification using a special username called DefGroup
#Defgroup Take 3 argument separated with ':'
#1 - Is the number Max of Group for this qualification
#2 - Is the number max of user per group
#3 - Is the minimum of user in the last group, recalc previous group as possible if number is low
#If you ommit scheme of groups, the group of qualification do not appear
#-------------------------------------------------------------------

$RefreshQualUsers = true;
#$QualUsers = "&./your_file.flt";
#$QualUsers = "@DefGroup:5:5:2,Gai-Luron,MataGyula,nesrulz,gwendoline,_-ALUCARD-_,lagamel,lister88,c-quad,shimanofr,bruno7529,boby5,kevinb,edgar,berlioz,la tortue,neron59,eur-can,stff,2psbob,oliv76000";

#################
#Command actions#
#################
#If ! before a name, force nickName authentification if UseUsernameForAuthentication=true
#If ! before a name, force userName authentification if UseUsernameForAuthentication=false
#You can use regexp expression in userName pattern, type regex=your regular expression
#
#Example:	if UseUsernameForAuthentication=true
#		!regex=^\[COP\].*
#		Find all user with a nickname that begins with [COP]
#		regex=^Gai.*
#		Find all user with a username that begins with Gai
# 		See regular expression on web for more info how it work
#
#Use & sign at end of patterns
#-------------------------------------------------------------------

Event OnMSO( $text ) # Player event

#	writeline( $text );
	$idxOfFirtsSpace = indexOf( $text, " ");
	
	$userName = GetCurrentPlayerVar("UserName");

	UserGroupFromFile( "admin", "./admin.txt" );
	
	IF( $idxOfFirtsSpace == -1 ) THEN
	  $command = $text;
	  $argv = "";
	ELSE
	  $command = subStr( $text,0,$idxOfFirtsSpace );
	  $argv = trim( subStr( $text,$idxOfFirtsSpace ) );
	ENDIF
	
	SWITCH( $command )

		CASE "!gui":
		        IF( $enable_config_gui == "true" )
		        THEN
				IF( UserInGroup( "admin",$userName ) == 1 )
				THEN
				  config_gui(0,0);
				ELSE
				  privMsg( "You are not an Admin!");
				ENDIF
			ENDIF
			BREAK;
		CASE "!node":
			IF( UserInGroup( "admin",$userName ) == 1 )
			THEN
			  privMsg( "The Current Node is : " . GetCurrentPlayerVar( "CurrNode" ) );
			ENDIF
			BREAK;
		CASE "!zone":
			IF( UserInGroup( "admin",$userName ) == 1 )
			THEN
			  privMsg( "The Current Zone is : " . GetCurrentPlayerVar( "X" ) . ":" . GetCurrentPlayerVar( "Y" ) );
			ENDIF
			BREAK;
		CASE "!term":
			IF( UserInGroup( "admin",$userName ) == 1 )
			THEN
			  cmdLfs( "/msg Lapper Closed By Administrator!");
			  termLapper();
			ELSE
			  privMsg( "You are not an Admin!");
			ENDIF
			BREAK;
		CASE "!test":
			cmdLFS("/rcm " . GetCurrentPlayerVar("Nickname") . " is testing...");
			cmdLFS("/rcm_ply " . GetCurrentPlayerVar( "Nickname" ) );
			BREAK;
		CASE "!powered":
			http("http://www.frh-team.net/reglapper/getserver2.php");
			BREAK;
		CASE "!license":
		  setLicense( $argv );
	 		BREAK;
		CASE "!groupcmdlfs":
			IF( UserInGroup( "admin",$userName ) == 1 )
			THEN
			  groupCmdLfs( $argv );
			ELSE
			  privMsg( "You are not an Admin!");
			ENDIF
			BREAK;
		CASE "!ban":
			IF( UserInGroup( "admin",$userName ) == 1 )
			THEN
			  privMsg( GetCurrentPlayerVar( "Nickname" ) . " Ban " . GetPlayerVar( $argv, "Nickname" ) );
			  cmdLFS( "/ban " . $argv . " 1" );
			ENDIF
			BREAK;
		CASE "!kick":
			IF( UserInGroup( "admin",$userName ) == 1 )
			THEN
			  privMsg( GetCurrentPlayerVar( "Nickname" ) . " kick " . GetPlayerVar( $argv, "Nickname" ) );
			  cmdLFS( "/kick " . $argv . " 1" );
			ENDIF
			BREAK;
		CASE "!pos":
			privMsg( "Your friendly position is " . GetCurrentPlayerVar( "Posabs" ) );
			BREAK;
		CASE "!groupqual":
			privMsg( "Your groupqual is " . GetCurrentPlayerVar( "Groupqual" ) );
			BREAK;
		CASE "!ver":
			http("http://www.frh-team.net/reglapper/getserver2.php");
			lapperVersion();
			BREAK;
		CASE "!auth":
			privMsg("^3You have level(s): " . GetCurrentPlayerVar("AuthLevel") );
			BREAK;
		CASE "!cleanspb":
			cleanSpb();
			BREAK;
		CASE "!spb":
			showSpb();
			BREAK;
		CASE "!hand":
			showHand( $argv );
			BREAK;
		CASE "!statsqual":
			statsQual( $argv );
			BREAK;
		CASE "!dstatsqual":
			dStatsQual( $argv );
			BREAK;
		CASE "!stats":
			stats( $argv );
			BREAK;
		CASE "!dstats":
			dStats( $argv );
			BREAK;
		CASE "!nearqual":
			nearQual( $argv );
			BREAK;
		CASE "!drfnearqual":
			drfNearQual( $argv );
			BREAK;
		CASE "!near":
			near( $argv );
			BREAK;
		CASE "!drfnear":
			drfNear( $argv );
			BREAK;
		CASE "!top":
			top( $argv );
			BREAK;
		CASE "!mypb":
			CurrentPlayerlfsWorldPB( $argv );
			BREAK;
		CASE "!drf":
			drf( $argv );
			BREAK;
		CASE "!topqual":
			topQual( $argv );
			BREAK;
		CASE "!drfqual":
			drfQual( $argv );
			BREAK;
		CASE "!distance":
			privMsg("Distance done on "
							. GetCurrentPlayerVar( "Car" )
							. "/" . GetLapperVar("ShortTrackName")
							. " = " . ToPlayerUnit( GetCurrentPlayerVar("Dist") ) . " " . GetCurrentPlayerVar("UnitDist")
							. ", session = " . ToPlayerUnit( GetCurrentPlayerVar("SessDist") ) . " " . GetCurrentPlayerVar("UnitDist")
			);
			BREAK;
		CASE "!laps":
			privMsg( "Laps done on " . GetCurrentPlayerVar("Car")
								. "/" . GetLapperVar("ShortTrackName")
								. " = " . GetCurrentPlayerVar("Laps")
								. ", session = " . GetCurrentPlayerVar("SessLaps") );
			 BREAK;
		CASE "!pit":
			privMsg( "Time in pitting " . NumToMSH (GetCurrentPlayerVar("TotalPitTime")) );
			BREAK;
		CASE "!track":
			privMsg( "Track in use :" . GetLapperVar("ShortTrackName") . " = " . GetLapperVar("LongTrackName") );
			BREAK;
		CASE "!time":
			privMsg( "Server time clock reference : " . GetLapperVar("LongTime") );
			BREAK;
		CASE "!help":
			openPrivButton( "help",25,28,150,10,5,-1,0,"^2Commands list" );
			openPrivButton( "help2",25,38,150,6,5,-1,96,"^2General commands"
			. "&^3!top ^8[table offset] [3-letter car name] ['filter' pattern]"
			. "&^3!drf ^8[table offset] [3-letter car name] ['filter' pattern]"
			. "&^3!stats ^8[playername pattern]"
			. "&^3!dstats ^8[playername pattern]"
			. "&^3!near ^8Gap with 14 pilots near you on the ranking"
			. "&^3!spb ^8Split times and TPB (Theoretical PB)"
			. "&^3!razspb ^8Start new spb session (eg when changing car)"
			. "&^3!track ^8Name of actual track"
			. "&^3!time ^8Server time (to leagues mettings)"
			. "&^3!ver ^8Version of LFSLapper"
			. "&"
			. "&^2Special league commands"
			. "&^3!topqual ^8Rank to pilots specified on *.flt file"
			. "&^3!statsqual ^8Actual Position on prequalify session"
			. "&"
			. "&^2New functions"
			. "&^3!laps ^8Total laps number + session laps number"
			. "&^3!hand ^8Handicap by pilot ordered by league-host admin"
			. "&^3!pit ^8Total pit stop time"
			. "&^3Shift+i ^8Configure your display messages"
			. "&^3!closepb ^8Close Pitboard temporary"
			. "&^3!config ^8Configure Pitboard"
			. "&^3!ctrack ^8Open track change GUI (Admin only)"
			. "&^3!pitwindow ^8Show currently set pitwindow(s)"
			. "&^3!pwgui ^8Open Pitwindow GUI (Admin only)"
			. "&^3!sc ^8Open safetycar GUI (Admin only)" );
			openPrivButton( "close",90,175,20,10,8,-1,32,Ok,MA_closeHelp );
	 		BREAK;
		CASE "!closepb":
			IF ( $enable_pitboard == "true" )
			THEN
			  close_pitboard( $KeyFlags );
			ENDIF
			BREAK;
		CASE "!config":
			IF ( $enable_pitboard == "true" )
			THEN
			  Config_Pitboard( $KeyFlags );
			ENDIF
			BREAK;
		CASE "!pitwindow":
			IF ( $enable_pitboard == "true" )
			THEN
			  Pitwindow( $KeyFlags ); 
			ENDIF
			BREAK;
		CASE "!pwgui":
			IF ( $enable_pitwindow_gui == "true" )
			THEN
			  IF( UserInGroup( "admin", $userName ) == 1 )
			  THEN
			    MA_pwgui(0,0);
			  ELSE
			    privMsg( "^1You are not allowed to open that");
			  ENDIF
			ENDIF
			BREAK;
		CASE "!sc":
			IF ( $enable_safetycar_gui == "true" )
			THEN
			  IF( UserInGroup( "admin", $userName ) == 1 )
			  THEN
			    Safetycar_gui( $KeyFlags );
			  ELSE
			    privMsg( "^1You are not allowed to open that");
			  ENDIF
			ENDIF
			BREAK;
		CASE "!ctrack":
			IF ( $enable_ctrack_gui == "true" )
			THEN
			  IF( UserInGroup( "admin", $userName ) == 1 )
			  THEN
			    Ctrack(0,0);
			  ELSE
			    privMsg( "^1You are not allowed to open that");
			  ENDIF
			ENDIF
			BREAK;
	ENDSWITCH
EndEvent

Sub MA_closeHelp( $KeyFlags,$id )
	closePrivButton("help&help2&close");
EndSub
#####################################
#Action on teleport to pit (Shift+P)#
#####################################

/*
Event OnEnterPit()  # Player event
 	privMsg( GetCurrentPlayerVar("Nickname") . "^8 teleported to pits!" );
EndEvent
*/

# Actions to execute when player spectates or disconnects (leaves race).

/*
Event OnLeaveRace()  # Player event
	privMsg( GetCurrentPlayerVar("Nickname" ) . "^8 left the race!";
EndEvent
*/

###############################
#Action a player flooding chat#
###############################

Event OnFlood() # Player event
	privMsg( GetCurrentPlayerVar("Nickname") . "^3 kicked for flooding" );
	cmdLFS( "/kick " . GetCurrentPlayerVar("Username" ) );
EndEvent

$MaxFloodLines = 4; # Maximum number of consecutive lines allowed

$MaxFloodLinesTime = 5000; # Maximum time between two consecutive lines in milliseconds to count as flooding

#########################
#Action on Qual and race#
#########################

Event OnRaceStart( $NumP ) # Lapper event
	DelayedCommand( 5, ORS );
EndEvent

Sub ORS()
	IF ( $enable_pitboard == "true" )
	THEN
	  OnRaceStart_Pitboard();
	ELSE
	  cmdLFS( "/rcm ^3Please, brake in time!" );
	  cmdLFS( "/rcm_all" );
	ENDIF
EndSub

Event OnQualStart( $NumP ) # Lapper event
	  DelayedCommand( 5, OQS );
EndEvent

Sub OQS()
	IF ( $enable_pitboard == "true" )
	THEN
	  OnQualStart_Pitboard();
	ENDIF
EndSub

Event OnFinish()
EndEvent

Event OnResult( $flagConfirm )
	writeline ( "Finished Pos = " . GetCurrentPlayerVar("FinishedPos") );
EndEvent

#########################
#Action to do on session#
#########################

/*
$MaxSessionLaps = 2;

Event OnMaxSessionLaps() # Player event
	privMsg( "Max session laps reacheds" );
EndEvent
*/

###############################
#Options on spinning detection#
###############################

$MinAngleVelocity = 250; # Minimum angle velocity to trigger action. Possible values: 0 - 720

# Action to execute when angle velocity is higher than MinAngleVelocity.

Event OnAngleVelocity() # Player event
	cmdLFS( "/msg ^1Danger! ^8" . GetCurrentPlayerVar("Nickname") . " ^2lost control!" );
EndEvent

$MaxNbInStunt = 20; #MaxNbInStunt is max time (in 100 ms) allowed in stunt mode before OnMaxNbInStunt is executed. If -1 No OnMaxNbInStunt are activated

Event OnMaxNbInStunt() # Player event
	cmdLFS( "/spec " . GetCurrentPlayerVar("Nickname") );
EndEvent

#################################
#Actions when player is too slow#
#################################

#$MaxAllowedLapTime1 = 100; # % Max allowed time to complete a lap relative to MaxLapTime in trackInfo.cfg

/*
Event OnMaxAllowedLapTime1() # Player event
	privMsg( "you are too slow! Max : " . $MaxAllowedLapTime1 );
	privMsg( "kick on " . GetCurrentPlayerVar("MaxAllowedLapTime2") );
EndEvent
*/

#$MaxAllowedLapTime2 = 150; # % Max allowed time to complete a lap relative to MaxLapTime in trackInfo.cfg

/*
Event OnMaxAllowedLapTime2() # Player event
	privMsg( "You are very slow, spectated!" );
	cmdLFS( "/msg " . GetCurrentPlayerVar("Nickname") . " is too slow, spectated!" );
	cmdLFS( "/spec " . GetCurrentPlayerVar("Username") );
EndEvent
*/

##################################
#Options for idle player on track#
##################################

#$IdleExclude = "Lagamel,Gai-Luron"; # Usernames excluded for idle check

$OnIdleTimeout1 = 20; # Idle timeout for OnIdleAction1 in seconds

Event OnIdle1() # Player event
	privMsg( "^3You are idle and will be spectated in 10 seconds" );
EndEvent

$OnIdleTimeout2 = 30; # Idle timeout for OnIdleAction2 in seconds

Event OnIdle2() # Player event
	cmdLFS( "/spec " . GetCurrentPlayerVar("Nickname") );
	privMsg( "^3You are spectated for non-activity" );
EndEvent

##################
#Drifting options#
##################
# This is the filepath for a file containing the collected data.
# This file will be created if it doesnt exist yet.
# You must ensure read/write access to this path.
#-------------------------------------------------------------------

$DriftDatabase = "./DriftPB";

# Actions to do on new personal best drift lap.
/*
Event OnDriftPB() # Player event
	cmdLFS( "/rcm " . GetCurrentPlayerVar("Nickname") . "^3 made new PB: ^7" . GetCurrentPlayerVar("DriftScore") . " ^3pts!" );
	cmdLFS( "/rcm_all" );
EndEvent
*/

Event OnDriftPB()  # Player event
	cmdLFS( "/msg " . GetCurrentPlayerVar("Nickname") . "^3 made new PB: ^7" . GetCurrentPlayerVar("DriftScore") . " ^3pts!" );
EndEvent


# Actions to do to when total lap drift score is higher or equal to MinimumDriftScore.


Event OnDriftLap() # Player event
	cmdLFS("/msg " . GetCurrentPlayerVar("Nickname") . " ^3drifted to ^7" . GetCurrentPlayerVar("DriftScore") . " ^3pts" );
EndEvent


# Message to get on end of each drift.
# Possible variables to use:


Event OnDriftScore() # Player event
	privMsg( "Score: ^7" . GetCurrentPlayerVar("DriftScore") . " ^3" . GetCurrentPlayerVar("LastDriftScore") );
EndEvent


$GoodDriftScore = 4000; # Value to be reached to execute action on good drift score


Event OnGoodDrift() # Player event
	privMsg( GetCurrentPlayerVar("Nickname") . " ^3made excellent drift: ^7" . GetCurrentPlayerVar("LastDriftScore") ." ^3pts" );
EndEvent



#$MinimumDriftScore = 10; # Minimum drift score required

# Actions to do at end of lap if MinimumDriftScore is not achieved.

/*
Event OnDriftTooLow() # Player event
	privMsg( GetCurrentPlayerVar("Nickname") . "^3 disqualified" );
	cmdLFS( "/spec " . GetCurrentPlayerVar("Nickname") };
EndEvent
*/

#$MinimumDriftSpeed = 50; # Minimum speed in km/h to maintain. Driving below that speed will reset score
#$MinimumDriftAngle = 15; # Minimum angel to maintain. When angle is below value, score is reset
#$MaximumDriftAngle = 100; # Maximum angel to maintain. When angle is above value, score is reset

################################
#Options for hotlapping options#
################################

$GripDatabase = "./GripPB";	# This is the filepath of a file containing the collected data
				# This file will be created if it doesnt exist yet
				# You must ensure read/write access to this path

$LapTimeUsedForPb = 1; # How many PB lap used to make average PB time, Min = 1 and Max = 10

# Action to do on new personal best lap.
# OnPBQual for the racer who make qualif ( in QualUser )
# OnPB the other racer

/*
Event OnPB() # Player event
	cmdLFS( "New PB by " . GetCurrentPlayerVar("Nickname") . "^8 (" . GetCurrentPlayerVar("Car" ) . "): " . NumToMSH(GetCurrentPlayerVar("LapTime"));
EndEvent
*/

Event OnPB() # Player event
	cmdLFS("/msg New PB by " . GetCurrentPlayerVar("Nickname") . "^8 (" . GetCurrentPlayerVar("Car") . "): " . NumToMSH(GetCurrentPlayerVar("LapTime")) );
	cmdLFS("/msg Friendly rank : " . GetCurrentPlayerVar("Posabs") );
	cmdLFS("/msg Session laps done = " . GetCurrentPlayerVar("SessLaps") );
	cmdLFS("/msg Total laps done (server) = " . GetCurrentPlayerVar("Laps") );
	cmdLFS("/msg Average speed: " . ToPlayerUnit( GetCurrentPlayerVar("AvgSpeed") ) . " " . GetCurrentPlayerVar("UnitSpeed") );
	cmdLFS("/rcm Friendly " . GetCurrentPlayerVar("Car") . " rank: ^7" .  GetCurrentPlayerVar("Posabs") );
	cmdLFS("/rcm_ply " . GetCurrentPlayerVar("Username") );
EndEvent

Event OnPBQual()
	cmdLFS("/msg League - New QT by " . GetCurrentPlayerVar("Nickname") . "^8:" . NumToMSH( GetCurrentPlayerVar("LapTime")) );
	cmdLFS("/msg Friendly rank (all visitors): ^7" . GetCurrentPlayerVar("Posabs") );
	cmdLFS("/msg ^2Qualify pos.: " . GetCurrentPlayerVar("Posqual") );
	cmdLFS("/msg ^6Actual Pool: " . GetCurrentPlayerVar("Groupqual") );
	cmdLFS("/msg Average speed: " . ToPlayerUnit( GetCurrentPlayerVar("AvgSpeed") ) . " " . GetCurrentPlayerVar("UnitSpeed") );
	cmdLFS("/rcm " . GetCurrentPlayerVar("Nickname") . " ^2Pos:" . GetCurrentPlayerVar("Posqual") . " - Pool:" . GetCurrentPlayerVar("Groupqual") );
	cmdLFS("/rcm_All");
EndEvent

##########################
#Options for acceleration#
##########################

$AccelerationStartSpeed = 1; # At which speed to start measuring time. In km/h
$AccelerationEndSpeed = 100; # At which speed to stop measuring time. In km/h

$AccelerationStartSpeedMph = 1; # At which speed to start measuring time. In Mph
$AccelerationEndSpeedMph = 60; # At which speed to stop measuring time. In Mph

$AccelerationPrivateMaxTime = 10; # Maximum acceleration time in seconds to show message

#Message to show to players.
#Possible variables to use:
#{AccelerationStartSpeed} - Starting speed
#{AccelerationEndSpeed} - Ending speed
#{AccelerationTime} - Acceleration time achieved from start to end speed
#{UnitSpeed} Unit of the Speed of the player connected

Event OnAcceleration()  # Player event
	privMsg( "^8Accelerated in ^3" . GetCurrentPlayerVar("AccelerationTime") . "^8 seconds to " . GetCurrentPlayerVar("AccelerationEndSpeed") . " " . GetCurrentPlayerVar("UnitSpeed") ."!" );
EndEvent

######################
#Actions for pit stop#
######################
#Local variable tou can use
#-------------------------------------------------------------------
# no pit windows if two var set to 0

$PitWindowStart=0;
$PitWindowStop=0;

Event OnNotPitWindow()  # Player event
	privMsg( GetCurrentPlayerVar("Nickname") . " ^1You are not on pit Windows, allowed in " . $ConfVar["PitWindowStart"] . "-" . $ConfVar["PitWindowStop"] );
EndEvent

Event OnBeginPitWindow() # Player event
	privMsg( GetCurrentPlayerVar("Nickname") . " ^1You are allowed to pit" );
EndEvent

Event OnEndPitWindow()  # Player event
	privMsg(  GetCurrentPlayerVar("Nickname"] . " ^1You are not allowed to pit" );
EndEvent

Event OnBeginPit( )  # Player event
	cmdLFS( "/msg " . GetCurrentPlayerVar("Nickname") . "^8 makes a pit stop" );
	privMsg( "Pit begin! Work:" . GetCurrentPlayerVar("pitWork") );
EndEvent

Event OnEndPit()  # Player event
	IF ( $enable_pitboard == "true" )
	THEN
	  OnEndPit_Pitboard();
	ELSE
	  cmdLFS( "/msg " . GetCurrentPlayerVar("Nickname") . "^8 left pits in " . numToMSH(GetCurrentPlayerVar("PitTime")) );
	  privMsg( "Pit stop finished in " . numToMSH(GetCurrentPlayerVar("PitTime")) ." - Total Pit: " . numToMSH( GetCurrentPlayerVar("TotalPitTime")) );
	ENDIF
EndEvent

Event OnPit()  # Player teleported to pit

EndEvent

#$FL_Changed -> Front Left Changed  : 1 Changed 0 No
#$FR_Changed -> Front Right Changed : 1 Changed 0 No
#$RL_Changed -> Rear Left Changed : 1 Changed 0 No
#$RR_Changed -> Rear Right Changed : 1 Changed 0 No

Event OnChangeTyres( $FL_Changed, $FR_Changed, $RL_Changed, $RR_Changed )
EndEvent

######################
#Actions on penalties#
######################
#Possible variables to use:
#
#OnFastDriveOnPitL1 = Actions on 30 Sec Penalty or drive-through
#OnFastDriveOnPitL2 = Actions on 45 Sec Penalty or Stop&Go
#MaxFastDriveOnPit = Max Fast Drive on Pit allowed per race
#OnMaxFastDriveOnPit = Actions on Max Fast Drive on Pit allowed
#OnFalseStartL1 = 30 Sec Penalty or drive-through
#OnFalseStartL2 = 45 Sec Penalty or Stop&Go
#
#Local Variable can be used:
#
#-------------------------------------------------------------------

Event OnFastDriveOnPitL1() # Player event
	cmdLFS( "/msg " . GetCurrentPlayerVar("Nickname") . "^1 Warning for fast driving in pit" );
	privMsg( "^1WARNING-KICK POSSIBLE" );
EndEvent

Event OnFastDriveOnPitL2() # Player event
	cmdLFS( "/msg " . GetCurrentPlayerVar("Nickname") . "^1 Spectated for fast driving in pit" );
	privMsg( "^1KICK IN " . GetCurrentPlayerVar("RemainFDIP") . " TRY" );
	cmdLFS( "/spec " . GetCurrentPlayerVar( "Username" ) );
EndEvent

Event OnMaxFastDriveOnPit() # Player event
	cmdLFS( "/msg " . GetCurrentPlayerVar("Nickname") . "^1 kicked for fast driving in pit" );
	cmdLFS( "/rcm ^1YOU ARE KICKED"  );
	cmdLFS( "/rcm_ply " . GetCurrentPlayerVar("Username") );
	cmdLFS( "/kick " . GetCurrentPlayerVar("Username") );
EndEvent
$MaxFastDriveOnPit = 2;

Event OnFalseStartL1()
EndEvent

Event OnFalseStartL2()
EndEvent

####################
#Overriding options#
####################
include( "./includes/addonsused.lpr");
include( "./includes/pitboard.lpr");
include( "./includes/pitwindow_gui.lpr");
include( "./includes/safetycar.lpr");
include( "./includes/ctrack.lpr");
include( "./includes/guiconfig.lpr");
include( "./includes/myInc.lpr");
