package lfsqualifyingticker.structures;

import java.util.HashMap;

import net.sf.jinsim.response.ResultResponse;
import net.sf.jinsim.response.SplitTimeResponse;

/**
 * The interface for listeners to the TimingModel
 * @author Gus
 *
 */

public interface TimingModelListener {
	/**
	 * The given player has joined the qualifying session
	 * @param playerJoining
	 */
	public void playerJoinedSession(byte playerIDJoining);
	
	/**
	 * The given player has left the qualifying session
	 * @param playerLeaving
	 */
	public void playerLeftSession(byte playerIDLeaving);
	
	/**
	 * The given player has started a hotlap
	 * @param player
	 */
	public void playerStartedHotlap(byte playerID);
	
	/**
	 * The given player has pitted
	 * @param playerPitting
	 */
	public void playerPitted(byte playerIDPitting);
	
	/**
	 * The fastest lap in the session has been updated to the given lap
	 * @param fastestLap
	 */
	public void fastestLapUpdated(Lap fastestLap);
	
	/**
	 * The players positions have been updated
	 * @param playerPositions
	 */
	public void updatePlayerPositionNodes(HashMap<PlayerInfo, MiniCompCar> 
		playerPositions);
	
	/**
	 * The given Result has been received
	 * @param result
	 */
	public void resultReceived(ResultResponse result);
	
	/**
	 * The best split has been improved
	 * @param player
	 * @param split
	 */
	public void bestSplitUpdated(PlayerInfo player, SplitTimeResponse split);
	
	/**
	 * The given speed trap reading has been taken
	 * @param speedTrapReading
	 */
	public void bestSpeedTrapReadingReceived(SpeedTrapReading speedTrapReading);
}
