package lfsqualifyingticker.structures;

/**
 * Holds details about a speed trap reading
 * @author Gus
 *
 */

public class SpeedTrapReading {
	public static final String START_FINISH_LINE = "Start / Finish Line";
	public static final String SPLIT_1 = "Split 1";
	public static final String SPLIT_2 = "Split 2";
	public static final String SPLIT_3 = "Split 3";
	public static final String TOP_SPEED = "Top Speed";
	
	private PlayerInfo player;
	private short rawSpeed;
	private String speedTrapName;
	
	/**
	 * Create a new Speed trap reading
	 * @param player
	 * @param rawSpeed
	 * @param speedTrapName
	 */
	public SpeedTrapReading(PlayerInfo player, short rawSpeed, 
			String speedTrapName) {
		this.player = player;
		this.rawSpeed = rawSpeed;
		this.speedTrapName = speedTrapName;
	}
	
	/**
	 * Get the player for this speed trap reading
	 * @return
	 */
	public PlayerInfo getPlayer() {
		return player;
	}
	
	/**
	 * Get the raw speed for this speed trap reading
	 * @return
	 */
	public short getRawSpeed() {
		return rawSpeed;
	}
	
	/**
	 * Get the name of this speed trap (e.g. Split 1, Finish Line)
	 * @return
	 */
	public String getSpeedTrapName() {
		return speedTrapName;
	}
	
	/*
	 * (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return getSpeedTrapName()+" - "+
			Helper.getPlainPlayerName(getPlayer().getPlayerName())+
			": "+Helper.getSpeedInMilesPerHour(getRawSpeed(), 2)+
			"mph ("+Helper.getSpeedInKilometresPerHour(getRawSpeed(), 2)+
			"kph)";
	}
}
