package lfsqualifyingticker.structures;

import net.sf.jinsim.response.NewConnectionResponse;

/**
 * A shortened version of the NewConnectionResponse class to save memory
 * @author Gus
 *
 */

public class ConnectionInfo {
	private final byte connectionID;
	private final String username;
	
	/**
	 * 
	 * @param newConnection
	 */
	public ConnectionInfo(NewConnectionResponse newConnection) {
		connectionID = newConnection.getConnectionId();
		username = newConnection.getUsername();
	}
	
	/**
	 * 
	 * @return
	 */
	public byte getConnectionID() {
		return connectionID;
	}
	
	/**
	 * 
	 * @return
	 */
	public String getUsername() {
		return username;
	}
}
