package lfsqualifyingticker.structures;

import net.sf.jinsim.response.InSimResponse;

/**
 * Contains an InSimResponse and the time the packet was received 
 * to this application in nanoseconds
 * @author Gus
 *
 */

public class ResponseAndTime {
	private InSimResponse response;
	private final long timePacketReceivedNs;
	
	/**
	 * Construct a new ResponseAndTime object containing the response and 
	 * the time at which this response was received in nanoseconds
	 * @param response
	 * @param timePacketReceivedNs
	 */
	public ResponseAndTime(InSimResponse response, 
			long timePacketReceivedNs) {
		this.response = response;
		this.timePacketReceivedNs = timePacketReceivedNs;
	}
	
	/**
	 * Get the response contained within this ResponseAndTime object
	 * @return
	 */
	public InSimResponse getResponse() {
		return response;
	}
	
	/**
	 * Get the time this response was received to this application in 
	 * nanoseconds
	 * @return
	 */
	public long getTimePacketReceivedNs() {
		return timePacketReceivedNs;
	}
}
