package lfsqualifyingticker;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;

import lfsqualifyingticker.models.TrackModel;
import lfsqualifyingticker.structures.Helper;
import lfsqualifyingticker.structures.QualiTickerPrefs;

public class LFSQualifyingTickerStart {
	private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat(
			"EEE d MMM yyyy HH:mm:ss");

	public static void main(String[] args) {
		createLogFile();

		QualiTickerPrefs.loadPreferencesFromFile();

		/* 
		 * Check the path for the smx folder specified in the config file 
		 * is correct. If the path is incorrect the user will be
		 * notified and the application will stop
		 */
		TrackModel.checkSMXFolderPath();
		
		// Populate the map of InSim packet priorities
		Helper.populateInSimPacketPrioritiesMap();
		
		new LFSQualifyingTicker();
	}
	
	/**
	 * Create a log file for the LFS Qualifying Ticker application by redirecting 
	 * System.err output
	 */
	private static void createLogFile() {
		try {
			FileOutputStream fos = new FileOutputStream("LFSQualifyingTicker.log");
			PrintStream ps = new PrintStream(fos);
			System.setErr(ps);
		} catch (FileNotFoundException fnfe) {
			fnfe.printStackTrace();
			print("Error creating log file: "+fnfe.getMessage());
		}
	}
	
	/**
	 * Prints the given message to the console and to log file
	 * @param msg
	 */
	public static void print(String msg) {
		System.out.println(DATE_FORMAT.format(new Date())+" - "+msg);
		System.err.println(DATE_FORMAT.format(new Date())+" - "+msg);
	}
}
