package lfsqualifyingticker.structures;

import net.sf.jinsim.response.NewConnectionResponse;

/**
 * A shortened version of the NewConnectionResponse class to save memory
 * @author Gus
 *
 */

public class ConnectionInfo {
	private final byte connectionID;
	private final String username;
	
	public ConnectionInfo(NewConnectionResponse newConnection) {
		connectionID = newConnection.getConnectionId();
		username = newConnection.getUsername();
	}
	
	public byte getConnectionID() {
		return connectionID;
	}
	
	public String getUsername() {
		return username;
	}
}
