package lfsqualifyingticker.structures;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;

import javax.swing.JOptionPane;

import lfsqualifyingticker.LFSQualifyingTickerStart;

public class QualiTickerPrefs {
	private static final String APPLICATION_NAME = "LFS Qualifying Ticker";
	private static final String VERSION = "0.1.5 Alpha";
	
	// Strings used to identify parts of the config file
	private static final String SEPERATOR_CHAR = "*";
	private static final String HOST_NAME_STRING = "HostName";
	private static final String PORT_STRING = "Port";
	private static final String ADMIN_PASSWORD_STRING = "AdminPassword";
	private static final String DEBUG_STRING = "Debug";
	private static final String INSIM_BUFFER_DELAY_STRING = "InSimBufferDelay";
	private static final String UPDATE_LFS_DISPLAY_DELAY_STRING = "UpdateLFSDisplayDelay";
	private static final String REQUEST_CAMERA_POSITION_DELAY_STRING = "RequestCameraPositionDelay";
	private static final String NUM_NODES_FOR_GAP_AVERAGE_STRING = "NumberOfNodesForGapAverage";
	private static final String UPDATE_TRACK_MAP_DELAY_STRING = "UpdateTrackMapDelay";
	private static final String PERCENTAGE_OF_LAP_TO_COMPLETE_BEFORE_DISPLAYING_GAP_STRING = 
		"PercOfLapToCompleteBeforeDisplayingGap";
	private static final String LFS_DIRECTORY_PATH_STRING = "LFSFolderPath";
	private static final String NO_LAPS_COMPLETED_TEXT_STRING = "NoLapsCompletedText";
	private static final String PLAYER_NOT_ON_HOTLAP_TEXT_STRING = "PlayerNotOnHotlapText";
	private static final String NO_PLAYER_VIEWED_STRING = "NoPlayerViewedText";
	private static final String SHOW_GAP_AT_LAST_SPLIT_STRING = "ShowGapAtLastSplit";
	private static final String DISPLAY_MESSAGE_PANEL_STRING = "DisplayMessagePanel";
	private static final String DRAW_TRACK_MAP_STRING = "DrawTrackMap";
	// End strings used to identify parts of the config file
	
	private static String hostname=null, adminPassword=null, lfsDirectoryPath=null, 
		playerNotOnHotlapString="", noLapsCompletedString="", noPlayerViewedString="";
    private static int port=Integer.MIN_VALUE, inSimBufferDelay=Integer.MIN_VALUE, 
    	updateLFSDisplayDelay=Integer.MIN_VALUE, requestCameraPositionDelay=Integer.MIN_VALUE, 
    	numNodesForAverage=Integer.MIN_VALUE, updateTrackMapDelay=Integer.MIN_VALUE,
    	percentageOfLapToCompleteBeforeDisplayingGap=Integer.MIN_VALUE;
    private static boolean debug, showGapAtLastSplit=true, displayMessagePanel=false,
    	drawTrackMap=false;

	// Colours for LFS text
	public static final Color LFSTEXTBLACKCOLOR = Color.BLACK;
	public static final Color LFSTEXTWHITECOLOR = Color.WHITE;
	public static final Color LFSTEXTBLUECOLOR = Color.BLUE;
	public static final Color LFSTEXTGREENCOLOR = new Color(0, 128, 0);
	public static final Color LFSTEXTLIGHTBLUECOLOR = Color.CYAN;
	public static final Color LFSTEXTREDCOLOR = Color.RED;
	public static final Color LFSTEXTVIOLETCOLOR = new Color(255, 0, 255);
	public static final Color LFSTEXTYELLOWCOLOR = Color.YELLOW;
	public static final Color LFSTEXTDEFAULTCOLOR = Color.DARK_GRAY;
	
	/**
	 * Returns the name of this application
	 * @return
	 */
	public static String getApplicationName() {
		return APPLICATION_NAME;
	}
	
	/**
	 * Get the version number of the quali ticker application
	 * @return
	 */
	public static String getVersion() {
		return VERSION;
	}
	
	/**
	 * Get the hose name to connect to
	 * @return
	 */
	public static String getHostName() {
		return hostname;
	}
	
	/**
	 * Get the port to connect to
	 * @return
	 */
	public static int getHostPort() {
		return port;
	}
	
	/**
	 * Get the admin password for the LFS host
	 * @return
	 */
	public static String getAdminPassword() {
		return adminPassword;
	}
	
	/**
	 * Returns the delay between handling InSim responses
	 * @return
	 */
	public static int getInSimBufferDelay() {
		return inSimBufferDelay;
	}
	
	/**
	 * Returns the delay between updating the LFS display message
	 * @return
	 */
	public static int getUpdateLFSDisplayDelay() {
		return updateLFSDisplayDelay;
	}
	
	/**
	 * Returns the delay between requesting the current camera position
	 * from LFS
	 * @return
	 */
	public static int getRequestCameraPositionDelay() {
		return requestCameraPositionDelay;
	}
	
	/**
	 * Returns the number of nodes to be used in calculating the average
	 * gap
	 * @return
	 */
	public static int getNumberOfNodesForAverageGap() {
		return numNodesForAverage;
	}
	
	/**
	 * Returns the delay between updating the track map
	 * @return
	 */
	public static int getUpdateTrackMapDelay() {
		return updateTrackMapDelay;
	}
	
	/**
	 * Returns the percentage of the current lap that must be completed
	 * before displaying a gap to the fastest lap
	 * @return
	 */
	public static int getPercentageOfLapToCompleteBeforeDisplayingGap() {
		return percentageOfLapToCompleteBeforeDisplayingGap;
	}
	
	/**
	 * Returns the location of the main LFS folder (used to get pth 
	 * file information)
	 * @return
	 */
	public static String getLFSDirectoryPath() {
		return lfsDirectoryPath;
	}
	
	/**
	 * Returns the string to display in LFS when no laps have yet been 
	 * completed in the session
	 * @return
	 */
	public static String getNoLapsCompleted() {
		return noLapsCompletedString;
	}
	
	/**
	 * Returns the string to display in LFS when the viewed player is
	 * not on a hotlap
	 * @return
	 */
	public static String getPlayerNotOnHotlapString() {
		return playerNotOnHotlapString;
	}
	
	/**
	 * Returns the string to display when no player is currently viewed
	 * @return
	 */
	public static String getNoPlayerViewedString() {
		return noPlayerViewedString;
	}
	
	/**
	 * Returns true if the application is running in debug mode, 
	 * false otherwise
	 * @return
	 */
	public static boolean getDebug() {
		return debug;
	}
	
	/**
	 * Returns whether the gap at the last split should be shown
	 * @return
	 */
	public static boolean getShowGapAtLastSplit() {
		return showGapAtLastSplit;
	}
	
	/**
	 * Returns whether the message panel should be shown
	 * @return
	 */
	public static boolean getDisplayMessagePanel() {
		return displayMessagePanel;
	}
	
	/**
	 * Returns whether or not the track map should be drawn
	 * @return
	 */
	public static boolean getDrawTrackMap() {
		return drawTrackMap;
	}
	
	public static void loadPreferencesFromFile() {
		try {
			File preferencesFile = new File("config.cfg");
			FileReader fileReader = new FileReader(preferencesFile);
			BufferedReader bufReader = new BufferedReader(fileReader);
			
			String inputLine = bufReader.readLine();
			
			while(inputLine != null) {
				if(inputLine.startsWith("//") || inputLine.length() == 0) {
					// Ignore this line
					//print("ignoring input line: "+inputLine);
				} else {
					// Set the correct value depending on the input line
					String parameterType = inputLine.substring(0, inputLine.indexOf(SEPERATOR_CHAR));
					String parameterValue = inputLine.substring(inputLine.indexOf(SEPERATOR_CHAR)+1);

					if(parameterType.equals(HOST_NAME_STRING)) {
						hostname = parameterValue;
					} else if(parameterType.equals(PORT_STRING)) {
						port = Integer.parseInt(parameterValue);
					} else if(parameterType.equals(ADMIN_PASSWORD_STRING)) {
						adminPassword = parameterValue;
					} else if(parameterType.equals(DEBUG_STRING)) {
						if(parameterValue.equalsIgnoreCase("true")) {
							debug = true;
						} else {
							debug = false;
						}
					} else if(parameterType.equals(INSIM_BUFFER_DELAY_STRING)) {
						inSimBufferDelay = Integer.parseInt(parameterValue);
					} else if(parameterType.equals(UPDATE_LFS_DISPLAY_DELAY_STRING)) {
						updateLFSDisplayDelay = Integer.parseInt(parameterValue);
					} else if(parameterType.equals(REQUEST_CAMERA_POSITION_DELAY_STRING)) {
						requestCameraPositionDelay = Integer.parseInt(parameterValue);
					} else if(parameterType.equals(NUM_NODES_FOR_GAP_AVERAGE_STRING)) {
						numNodesForAverage = Integer.parseInt(parameterValue);
					} else if(parameterType.equals(UPDATE_TRACK_MAP_DELAY_STRING)) {
						updateTrackMapDelay = Integer.parseInt(parameterValue);
					} else if(parameterType.equals(PERCENTAGE_OF_LAP_TO_COMPLETE_BEFORE_DISPLAYING_GAP_STRING)) {
						percentageOfLapToCompleteBeforeDisplayingGap = Integer.parseInt(parameterValue);
					} else if(parameterType.equals(LFS_DIRECTORY_PATH_STRING)) {
						lfsDirectoryPath = parameterValue;
					} else if(parameterType.equals(NO_LAPS_COMPLETED_TEXT_STRING)) {
						noLapsCompletedString = parameterValue;
					} else if(parameterType.equals(PLAYER_NOT_ON_HOTLAP_TEXT_STRING)) {
						playerNotOnHotlapString = parameterValue;
					} else if(parameterType.equals(NO_PLAYER_VIEWED_STRING)) {
						noPlayerViewedString = parameterValue;
					} else if(parameterType.equals(SHOW_GAP_AT_LAST_SPLIT_STRING)) {
						if(parameterValue.equalsIgnoreCase("true")) {
							showGapAtLastSplit = true;
						} else {
							showGapAtLastSplit = false;
						}
					} else if(parameterType.equals(DISPLAY_MESSAGE_PANEL_STRING)) {
						if(parameterValue.equalsIgnoreCase("true")) {
							displayMessagePanel = true;
						} else {
							displayMessagePanel = false;
						}
					} else if(parameterType.equals(DRAW_TRACK_MAP_STRING)) {
						if(parameterValue.equalsIgnoreCase("true")) {
							drawTrackMap = true;
						} else {
							drawTrackMap = false;
						}
					} else {
						print("!!!Unknown parameter type: "+parameterType);
					}
				} 
				
				inputLine = bufReader.readLine();
			}
			
			fileReader.close();
			bufReader.close();
		} catch(Exception e) {
			e.printStackTrace();
			
			JOptionPane.showMessageDialog(null, 
					"There was a problem reading the configuration file\n" +
					"LFS Qualifying Ticker cannot continue.\n" +
					"Please re-download LFS Qualifying Ticker", 
					"Problem Reading Config File", 
					JOptionPane.ERROR_MESSAGE);
			
			System.exit(1);
		}
	}
	
	private static void print(String msg) {
		LFSQualifyingTickerStart.print("QualiTickerPrefs - "+msg);
	}
}
