package lfsqualifyingticker.structures;

import java.awt.BorderLayout;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.swing.BoundedRangeModel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.DefaultCaret;

import lfsqualifyingticker.LFSQualifyingTickerGUI;
import lfsqualifyingticker.LFSQualifyingTickerStart;

/**
 * Panel to hold race messages
 * @author Gus
 *
 */

public class QualiTickerMessagePanel extends JPanel {
	/**
	 * 
	 */
	private static final long serialVersionUID = -7073439139178654018L;
	
	private JTextArea messageArea;
	private JScrollPane scrollPane;

	private JScrollBar verticalScrollBar;

	private BoundedRangeModel model;
	
	private DefaultCaret caret;
	
	private final SimpleDateFormat messageDateFormat = new SimpleDateFormat("HH:mm:ss");
	
	public QualiTickerMessagePanel() {
		setupPanel();
	}
	
	private void setupPanel() {
		this.setLayout(new BorderLayout());
		
		messageArea = new JTextArea();

		caret = (DefaultCaret) messageArea.getCaret();
		
		scrollPane = new JScrollPane();

		verticalScrollBar = scrollPane.getVerticalScrollBar();
		model = verticalScrollBar.getModel();
		
		verticalScrollBar.addAdjustmentListener(new AdjustmentListener() { 
			public void adjustmentValueChanged(AdjustmentEvent e) {
				if (model.getValue() == model.getMaximum() - model.getExtent()) {
					caret.setDot(messageArea.getText().length());
					caret.setUpdatePolicy(DefaultCaret.ALWAYS_UPDATE);
				} else {
					caret.setUpdatePolicy(DefaultCaret.NEVER_UPDATE);
				}
			}
		});

		messageArea.setEditable(false);
		
		scrollPane.getViewport().add(messageArea);
		
		this.add(scrollPane, BorderLayout.CENTER);
		
		this.setBackground(LFSQualifyingTickerGUI.BACKGROUND_COLOUR);

		messageArea.setRows(8);
	}
	
	/**
	 * Add the given message to the message panel
	 * @param message
	 */
	public void addMessage(String message) {
		if(message == null) {
			return;
		}

		// Add the timestamp on the message
		if(messageArea.getText().length() > 0) {
			messageArea.append("\n"+messageDateFormat.format(new Date())+" - "+message);
		} else {
			messageArea.append(messageDateFormat.format(new Date())+" - "+message);
		}
	}
	
	/**
	 * Clear the current text from the message panel
	 */
	public void clearMessagePanel() {
		messageArea.setText("");
	}

	@SuppressWarnings("unused")
	private void print(String msg) {
		LFSQualifyingTickerStart.print(this.getClass().getSimpleName()+" : "+msg);
	}
}
