package lfsqualifyingticker.structures;

import net.sf.jinsim.response.NewPlayerResponse;

/**
 * A shortened version of the NewPlayerResponse class to use less memory
 * @author Gus
 *
 */

public class PlayerInfo {
	private final byte playerID, connectionID;
	private final String playerName;
	
	/**
	 * Construct a new PlayerInfo object using the given NewPlayerResponse
	 * @param player
	 */
	public PlayerInfo(NewPlayerResponse player) {
		playerID = player.getPlayerId();
		connectionID = player.getConnectionId();
		playerName = player.getPlayerName();
	}
	
	/**
	 * Get the playerID
	 * @return
	 */
	public byte getPlayerID() {
		return playerID;
	}
	
	/**
	 * Get the connectionID
	 * @return
	 */
	public byte getConnectionID() {
		return connectionID;
	}
	
	/**
	 * Get the player name
	 * @return
	 */
	public String getPlayerName() {
		return playerName;
	}
}
