package lfsqualifyingticker.structures;

import net.sf.jinsim.types.CompCar;

/**
 * Contains a CompCar object and the time the packet containing the CompCar
 * was received
 * @author Gus
 *
 */

public class MiniCompCarAndTime {
	private MiniCompCar compCar;
	private long time;
	
	/**
	 * 
	 * @param compCar
	 * @param time
	 */
	public MiniCompCarAndTime(CompCar compCar, long time) {
		this.compCar = new MiniCompCar(compCar);
		this.time = time;
	}
	
	/**
	 * Get the CompCar from this object
	 * @return
	 */
	public MiniCompCar getMiniCompCar() {
		return compCar;
	}
	
	/**
	 * Get the time this CompCar was received, in nanoseconds
	 * @return
	 */
	public long getTime() {
		return time;
	}
}
