package lfsqualifyingticker.structures;

import net.sf.jinsim.types.CompCar;
import net.sf.jinsim.types.InSimVector;

/**
 * A smaller version of the CompCar packet received from LFS (to 
 * save on memory requirements)
 * @author Gus
 *
 */

public class MiniCompCar {
	private final short speed, node, lap;
	private final InSimVector position;
	
	/**
	 * Construct a MiniCompCar object with the given CompCar
	 * @param compCar
	 */
	public MiniCompCar(CompCar compCar) {
		speed = compCar.getSpeed();
		node = compCar.getNode();
		position = compCar.getPosition();
		lap = compCar.getLap();
	}
	
	/**
	 * Get the speed
	 * @return
	 */
	public short getSpeed() {
		return speed;
	}
	
	/**
	 * Get the node
	 * @return
	 */
	public short getNode() {
		return node;
	}
	
	/**
	 * Get the position
	 * @return
	 */
	public InSimVector getPosition() {
		return position;
	}
	
	/**
	 * Get the lap
	 * @return
	 */
	public short getLap() {
		return lap;
	}
}
