package lfsqualifyingticker.structures;

/**
 * Used to convey what message to display in LFS
 * @author Gus
 *
 */

public class LFSDisplayMessage {
	// The possible message types (used to determine what to display to LFS)
	public enum MessageType {NO_DISPLAY_MESSAGE, NO_LAPS_COMPLETED_MESSAGE, 
		TIME_DIFFERENCE_ONLY_MESSAGE, TIME_DIFFERENCE_AND_POSITION_MESSAGE, 
		NO_PLAYER_VIEWED, PLAYER_NOT_ON_HOTLAP};
	
	private final MessageType messageType;
	
	private Lap currentLap, fastestLap;
	private Long gapNS;
	private int predictedPosition;

	/**
	 * Construct a new LFSDisplayMessage with only the given message type
	 * @param messageType
	 */
	public LFSDisplayMessage(MessageType messageType) {
		this.messageType = messageType;
	}
	
	/**
	 * 
	 * @param messageType
	 * @param currentLap
	 * @param fastestLap
	 * @param gapNS
	 * @param predictedPosition
	 */
	public LFSDisplayMessage(MessageType messageType, Lap currentLap, 
			Lap fastestLap, Long gapNS, 
			int predictedPosition) {
		this.messageType = messageType;
		this.currentLap = currentLap;
		this.fastestLap = fastestLap;
		this.gapNS = gapNS;
		this.predictedPosition = predictedPosition;
	}

	/**
	 * Returns which type of message this is. The message type is used to 
	 * determine what to display in the LFS button interface
	 * @return
	 */
	public MessageType getMessageType() {
		return messageType;
	}
	
	/**
	 * Returns the currently viewed lap from this display message
	 * @return
	 */
	public Lap getCurrentLap() {
		return currentLap;
	}
	
	/**
	 * Returns the fastest lap in this session from this display message
	 * @return
	 */
	public Lap getFastestLap() {
		return fastestLap;
	}
	
	/**
	 * Get the predicted position for the viewed player's current
	 * lap using the relative time at the same point in other player's
	 * fastest laps
	 * @return
	 */
	public int getPredictedPosition() {
		return predictedPosition;
	}
	
	/**
	 * 
	 * @return
	 */
	public Long getGapNS() {
		return gapNS;
	}
}
