VERSION 5.00
Begin VB.UserControl okSocket 
   AutoRedraw      =   -1  'True
   CanGetFocus     =   0   'False
   ClientHeight    =   240
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   240
   ClipBehavior    =   0  'None
   HitBehavior     =   0  'None
   InvisibleAtRuntime=   -1  'True
   Picture         =   "okSocket.ctx":0000
   ScaleHeight     =   16
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   16
   ToolboxBitmap   =   "okSocket.ctx":0087
End
Attribute VB_Name = "okSocket"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
' okSocket, a self-subclassing winsock 2.2 vb6 user control by RayOK (rayisok@gmail.com)
' thanks to:
' ucSubclass by Paul_Caton@hotmail.com
'   downloaded from: http://www.pscode.com/vb/scripts/ShowCode.asp?txtCodeId=54117&lngWId=1
' and most winsock code from Will Barden at http://www.WinsockVB.com

Option Explicit

Private theProtocol As Protocols
Private udtUDPSend As sockaddr_in
Private lngAsyncMsg As Long
Private blnInitilized As Boolean

Public Event Connected(lngSocket As Long)
Public Event Accepted(lngSocket As Long, strAddr As String, intPort As Integer)
Public Event Received(lngSocket As Long, Data() As Byte)
Public Event DataSent(lngSocket As Long)
Public Event Closed(lngSocket As Long)

' Winsock version, who needs 1.1?
Private Const WINSOCK_V2_2  As Long = &H202

' Length of fields within the WSADATA structure.
Private Const WSADESCRIPTION_LEN  As Long = 256
Private Const WSASYS_STATUS_LEN   As Long = 128

' For socket handle errors, and bas returns from APIs.
Private Const ERROR_SUCCESS    As Long = 0
Private Const SOCKET_ERROR     As Long = -1

' Internet addresses.
Private Const INADDR_ANY          As Long = &H0
Private Const INADDR_LOOPBACK     As Long = &H7F000001
Private Const INADDR_BROADCAST    As Long = &HFFFFFFFF
Private Const INADDR_NONE         As Long = &HFFFFFFFF

' Maximum backlog when calling listen().
Private Const SOMAXCONN As Long = 5

' Messages send with WSAAsyncSelect().
Private Const FD_READ       As Long = &H1
Private Const FD_WRITE      As Long = &H2
Private Const FD_OOB        As Long = &H4
Private Const FD_ACCEPT     As Long = &H8
Private Const FD_CONNECT    As Long = &H10
Private Const FD_CLOSE      As Long = &H20

' Used with shutdown().
Private Const SD_RECEIVE    As Long = &H0
Private Const SD_SEND       As Long = &H1
Private Const SD_BOTH       As Long = &H2

' GetWinsockError constants.
Private Const WSABASEERR          As Long = 10000
Private Const WSAEINTR            As Long = WSABASEERR + 4
Private Const WSAEACCES           As Long = WSABASEERR + 13
Private Const WSAEFAULT           As Long = WSABASEERR + 14
Private Const WSAEINVAL           As Long = WSABASEERR + 22
Private Const WSAEMFILE           As Long = WSABASEERR + 24
Private Const WSAEWOULDBLOCK      As Long = WSABASEERR + 35
Private Const WSAEINPROGRESS      As Long = WSABASEERR + 36
Private Const WSAEALREADY         As Long = WSABASEERR + 37
Private Const WSAENOTSOCK         As Long = WSABASEERR + 38
Private Const WSAEDESTADDRREQ     As Long = WSABASEERR + 39
Private Const WSAEMSGSIZE         As Long = WSABASEERR + 40
Private Const WSAEPROTOTYPE       As Long = WSABASEERR + 41
Private Const WSAENOPROTOOPT      As Long = WSABASEERR + 42
Private Const WSAEPROTONOSUPPORT  As Long = WSABASEERR + 43
Private Const WSAESOCKTNOSUPPORT  As Long = WSABASEERR + 44
Private Const WSAEOPNOTSUPP       As Long = WSABASEERR + 45
Private Const WSAEPFNOSUPPORT     As Long = WSABASEERR + 46
Private Const WSAEAFNOSUPPORT     As Long = WSABASEERR + 47
Private Const WSAEADDRINUSE       As Long = WSABASEERR + 48
Private Const WSAEADDRNOTAVAIL    As Long = WSABASEERR + 49
Private Const WSAENETDOWN         As Long = WSABASEERR + 50
Private Const WSAENETUNREACH      As Long = WSABASEERR + 51
Private Const WSAENETRESET        As Long = WSABASEERR + 52
Private Const WSAECONNABORTED     As Long = WSABASEERR + 53
Private Const WSAECONNRESET       As Long = WSABASEERR + 54
Private Const WSAENOBUFS          As Long = WSABASEERR + 55
Private Const WSAEISCONN          As Long = WSABASEERR + 56
Private Const WSAENOTCONN         As Long = WSABASEERR + 57
Private Const WSAESHUTDOWN        As Long = WSABASEERR + 58
Private Const WSAETOOMANYREFS     As Long = WSABASEERR + 59
Private Const WSAETIMEDOUT        As Long = WSABASEERR + 60
Private Const WSAECONNREFUSED     As Long = WSABASEERR + 61
Private Const WSAENAMETOOLONG     As Long = WSABASEERR + 63
Private Const WSAEHOSTDOWN        As Long = WSABASEERR + 64
Private Const WSAEHOSTUNREACH     As Long = WSABASEERR + 65
Private Const WSAENOTEMPTY        As Long = WSABASEERR + 66
Private Const WSAEPROCLIM         As Long = WSABASEERR + 67
Private Const WSASYSNOTREADY      As Long = WSABASEERR + 91
Private Const WSAVERNOTSUPPORTED  As Long = WSABASEERR + 92
Private Const WSANOTINITIALISED   As Long = WSABASEERR + 93
Private Const WSAEDISCON          As Long = WSABASEERR + 101
Private Const WSATYPE_NOT_FOUND   As Long = WSABASEERR + 109
Private Const WSAHOST_NOT_FOUND   As Long = WSABASEERR + 1001
Private Const WSATRY_AGAIN        As Long = WSABASEERR + 1002
Private Const WSANO_RECOVERY      As Long = WSABASEERR + 1003
Private Const WSANO_DATA          As Long = WSABASEERR + 1004

' Max size of event handle array when calling WSAWaitForMultipleEvents().
Private Const WSA_MAXIMUM_WAIT_EVENTS   As Long = 64

' Size of WSANETWORKEVENTS.iErrorCode[] array.
Private Const FD_MAX_EVENTS    As Long = 10

' To initialize Winsock.
Private Type WSADATA
   wVersion                               As Integer
   wHighVersion                           As Integer
   szDescription(WSADESCRIPTION_LEN + 1)  As Byte
   szSystemstatus(WSASYS_STATUS_LEN + 1)  As Byte
   iMaxSockets                            As Integer
   iMaxUpdDg                              As Integer
   lpVendorInfo                           As Long
End Type

' Basic IPv4 addressing structures.
Private Type in_addr
   s_addr   As Long
End Type

Private Type sockaddr_in
   sin_family        As Integer
   sin_port          As Integer
   sin_addr          As in_addr
   sin_zero(0 To 7)  As Byte
End Type

' Used with name resolution functions.
Private Type hostent
   h_name         As Long
   h_aliases      As Long
   h_addrtype     As Integer
   h_length       As Integer
   h_addr_list    As Long
End Type

' Used with socket().
Private Enum Protocols
   IPPROTO_TCP = 6
   IPPROTO_UDP = 17
End Enum

' Used with socket().
Private Enum SocketTypes
   SOCK_STREAM = 1
   SOCK_DGRAM = 2
End Enum

' Used with socket().
Private Enum AddressFamilies
   AF_INET = 2
End Enum

' DLL handling functions.
Private Declare Function WSAStartup Lib "ws2_32.dll" (ByVal wVersionRequested As Integer, ByRef lpWSAData As WSADATA) As Long
Private Declare Function WSACleanup Lib "ws2_32.dll" () As Long
Private Declare Function WSAGetLastError Lib "ws2_32.dll" () As Long
Private Declare Function WSASetLastError Lib "ws2_32.dll" (ByVal err As Long) As Long

' Resolution functions.
Private Declare Function gethostbyname Lib "ws2_32.dll" (ByVal host_name As String) As Long
Private Declare Function gethostbyaddr Lib "ws2_32.dll" (haddr As Long, ByVal hnlen As Long, ByVal addrtype As Long) As Long

' Conversion functions.
Private Declare Function inet_addr Lib "ws2_32.dll" (ByVal cp As String) As Long
Private Declare Function inet_ntoa Lib "ws2_32.dll" (ByVal laddr As Long) As Long
Private Declare Function htons Lib "ws2_32.dll" (ByVal hostshort As Long) As Integer
Private Declare Function ntohs Lib "ws2_32.dll" (ByVal netshort As Long) As Integer

' Socket functions.
Private Declare Function socket Lib "ws2_32.dll" (ByVal af As AddressFamilies, ByVal stype As SocketTypes, ByVal lngProtocol As Long) As Long
Private Declare Function bind Lib "ws2_32.dll" (ByVal s As Long, ByRef name As sockaddr_in, ByVal namelen As Long) As Long
Private Declare Function listen Lib "ws2_32.dll" (ByVal s As Long, ByVal backlog As Long) As Long
Private Declare Function accept Lib "ws2_32.dll" (ByVal s As Long, ByRef addr As sockaddr_in, ByRef addrlen As Long) As Long
Private Declare Function Connect Lib "ws2_32.dll" Alias "connect" (ByVal s As Long, ByRef name As sockaddr_in, ByVal namelen As Long) As Long
Private Declare Function send Lib "ws2_32.dll" (ByVal s As Long, ByRef buf As Byte, ByVal datalen As Long, ByVal Flags As Long) As Long
Private Declare Function sendto Lib "ws2_32.dll" (ByVal s As Long, ByRef buf As Byte, ByVal datalen As Long, ByVal Flags As Long, ByRef toaddr As sockaddr_in, ByVal tolen As Long) As Long
Private Declare Function recv Lib "ws2_32.dll" (ByVal s As Long, ByRef buf As Byte, ByVal datalen As Long, ByVal Flags As Long) As Long
Private Declare Function recvfrom Lib "ws2_32.dll" (ByVal s As Long, ByRef buf As Byte, ByVal datalen As Long, ByVal Flags As Long, ByRef fromaddr As sockaddr_in, ByRef fromlen As Long) As Long
Private Declare Function shutdown Lib "ws2_32.dll" (ByVal s As Long, ByVal how As Long) As Long
Private Declare Function closesocket Lib "ws2_32.dll" (ByVal s As Long) As Long

' I/O model functions.
Private Declare Function WSAAsyncSelect Lib "ws2_32.dll" (ByVal s As Long, ByVal hwnd As Long, ByVal wMsg As Long, ByVal lEvent As Long) As Long

' Other general Win32 APIs.
Private Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (pDst As Any, pSrc As Any, ByVal ByteLen As Long)
Private Declare Function RegisterWindowMessage Lib "user32" Alias "RegisterWindowMessageA" (ByVal lpString As String) As Long
Private Declare Function SafeArrayGetDim Lib "oleaut32.dll" (ByRef saArray() As Any) As Long


Private Type Connection
    sSocket As Long
    Protocol As String
    SocketAddress As sockaddr_in
    RecvBuffer() As Byte
    SendBuffer() As Byte
    SendStart As Long
    File As String
    FileStart As Long
End Type
Private ConnList() As Connection

'==================================================================================================
'Subclasser declarations
Private Enum eMsgWhen
  MSG_AFTER = 1                                                                         'Message calls back after the original (previous) WndProc
  MSG_BEFORE = 2                                                                        'Message calls back before the original (previous) WndProc
  MSG_BEFORE_AND_AFTER = MSG_AFTER Or MSG_BEFORE                                        'Message calls back before and after the original (previous) WndProc
End Enum

Private Const ALL_MESSAGES           As Long = -1                                       'All messages added or deleted
Private Const GMEM_FIXED             As Long = 0                                        'Fixed memory GlobalAlloc flag
Private Const GWL_WNDPROC            As Long = -4                                       'Get/SetWindow offset to the WndProc procedure address
Private Const PATCH_04               As Long = 88                                       'Table B (before) address patch offset
Private Const PATCH_05               As Long = 93                                       'Table B (before) entry count patch offset
Private Const PATCH_08               As Long = 132                                      'Table A (after) address patch offset
Private Const PATCH_09               As Long = 137                                      'Table A (after) entry count patch offset

Private Type tSubData                                                                   'Subclass data type
  hwnd                               As Long                                            'Handle of the window being subclassed
  nAddrSub                           As Long                                            'The address of our new WndProc (allocated memory).
  nAddrOrig                          As Long                                            'The address of the pre-existing WndProc
  nMsgCntA                           As Long                                            'Msg after table entry count
  nMsgCntB                           As Long                                            'Msg before table entry count
  aMsgTblA()                         As Long                                            'Msg after table array
  aMsgTblB()                         As Long                                            'Msg Before table array
End Type

Private sc_aSubData()                As tSubData                                        'Subclass data array

Private Declare Sub RtlMoveMemory Lib "kernel32" (Destination As Any, Source As Any, ByVal Length As Long)
Private Declare Function GetModuleHandleA Lib "kernel32" (ByVal lpModuleName As String) As Long
Private Declare Function GetProcAddress Lib "kernel32" (ByVal hModule As Long, ByVal lpProcName As String) As Long
Private Declare Function GlobalAlloc Lib "kernel32" (ByVal wFlags As Long, ByVal dwBytes As Long) As Long
Private Declare Function GlobalFree Lib "kernel32" (ByVal hMem As Long) As Long
Private Declare Function SetWindowLongA Lib "user32" (ByVal hwnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Long) As Long


'Subclass handler - MUST be the first Public routine in this file. That includes public properties also
Public Sub zSubclass_Proc(ByVal bBefore As Boolean, ByRef bHandled As Boolean, ByRef lReturn As Long, ByRef lng_hWnd As Long, ByRef uMsg As Long, ByRef wParam As Long, ByRef lParam As Long)
Attribute zSubclass_Proc.VB_MemberFlags = "40"
'Parameters:
  'bBefore  - Indicates whether the the message is being processed before or after the default handler - only really needed if a message is set to callback both before & after.
  'bHandled - Set this variable to True in a 'before' callback to prevent the message being subsequently processed by the default handler... and if set, an 'after' callback
  'lReturn  - Set this variable as per your intentions and requirements, see the MSDN documentation for each individual message value.
  'hWnd     - The window handle
  'uMsg     - The message number
  'wParam   - Message related data
  'lParam   - Message related data
'Notes:
  'If you really know what you're doing, it's possible to change the values of the
  'hWnd, uMsg, wParam and lParam parameters in a 'before' callback so that different
  'values get passed to the default handler.. and optionaly, the 'after' callback
  
    If uMsg = lngAsyncMsg Then
        Select Case LoWord(lParam)
            Case FD_READ
                Call RecvData(wParam)
            Case FD_WRITE
                Call ResumeSendData(wParam)
            Case FD_ACCEPT
                Call AcceptConnection(wParam)
            Case FD_CONNECT
                RaiseEvent Connected(wParam)
            Case FD_CLOSE
                Call ConnRemove(ConnFind(wParam))
                RaiseEvent Closed(wParam)
        End Select
    End If
End Sub

Public Function Initilize(UniqueString As String) As Boolean
    Dim udtWinsockData As WSADATA
    
    lngAsyncMsg = RegisterWindowMessage("okSocket" & UniqueString)
    
    Call WSACleanup
    
    If WSAStartup(WINSOCK_V2_2, udtWinsockData) = SOCKET_ERROR Or lngAsyncMsg = 0 Then
        blnInitilized = False
    Else
        'Start subclassing
        Call Subclass_Start(UserControl.hwnd)
          
        'Add the messages that we're interested in
        Call Subclass_AddMsg(UserControl.hwnd, lngAsyncMsg, MSG_BEFORE)
        
        blnInitilized = True
    End If
    
    Initilize = blnInitilized
End Function
Public Sub Terminate()
  Dim i As Long
  
  'close all sockets
  If SafeArrayGetDim(ConnList) > 0 Then
    For i = 0 To UBound(ConnList)
      Call closesocket(ConnList(i).sSocket)
    Next i
    Erase ConnList()
  End If
End Sub
'The control is terminating - a good place to stop the subclasser
Private Sub UserControl_Terminate()
  On Error GoTo Catch
  
  'Stop all subclassing
  If blnInitilized Then Call Subclass_StopAll
Catch:
End Sub

'------------ Methods ------------
Public Function ConnectTo(Protocol As String, Port As Long, Host As String) As Long
    Dim lngSocket As Long, intIndex As Integer
    
    If UCase(Protocol) = "TCP" Then
        lngSocket = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)
    ElseIf UCase(Protocol) = "UDP" Then
        lngSocket = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP)
    End If
    
    If lngSocket <> SOCKET_ERROR Then
        If (WSAAsyncSelect(lngSocket, UserControl.hwnd, lngAsyncMsg, _
        FD_READ Or FD_WRITE Or FD_CONNECT Or FD_CLOSE) = SOCKET_ERROR) Then
            Debug.Print "WSAAsyncSelect failed! ConnectTo"
            Call closesocket(lngSocket)
            Exit Function
        End If
        
        intIndex = ConnAdd(lngSocket)
        With ConnList(intIndex)
            .Protocol = UCase(Protocol)
            .SocketAddress.sin_family = AF_INET
            .SocketAddress.sin_addr.s_addr = vbInetAddr(vbIPFromHostName(Host))
            .SocketAddress.sin_port = htons(Port)
        End With
        Call Connect(lngSocket, ConnList(intIndex).SocketAddress, LenB(ConnList(intIndex).SocketAddress))
    End If
    
    ConnectTo = lngSocket
End Function
Public Function ListenTo(Protocol As String, Port As Long, Optional Host As String = INADDR_ANY) As Long
    Dim lngSocket As Long, intIndex As Integer
    
    If UCase(Protocol) = "TCP" Then
        lngSocket = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)
    ElseIf UCase(Protocol) = "UDP" Then
        lngSocket = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP)
    End If
    
    If lngSocket <> SOCKET_ERROR Then
        If (WSAAsyncSelect(lngSocket, UserControl.hwnd, lngAsyncMsg, _
        FD_READ Or FD_WRITE Or FD_ACCEPT Or FD_CLOSE) = SOCKET_ERROR) Then
            Debug.Print "WSAAsyncSelect failed! ListenTo"
            Call closesocket(lngSocket)
            Exit Function
        End If
        
        intIndex = ConnAdd(lngSocket)
        With ConnList(intIndex)
            .Protocol = UCase(Protocol)
            .SocketAddress.sin_family = AF_INET
            .SocketAddress.sin_addr.s_addr = vbInetAddr(Host)
            .SocketAddress.sin_port = htons(Port)
        End With
        Call bind(lngSocket, ConnList(intIndex).SocketAddress, LenB(ConnList(intIndex).SocketAddress))
        Call listen(lngSocket, SOMAXCONN)
    End If
    
    ListenTo = lngSocket
End Function
Private Sub AcceptConnection(ByVal lngSocket As Long)
    Dim udtRemote As sockaddr_in, lngAcceptSocket As Long, intIndex As Integer
    
    lngAcceptSocket = accept(lngSocket, udtRemote, LenB(udtRemote))
    
    If lngAcceptSocket <> SOCKET_ERROR Then
        If (WSAAsyncSelect(lngAcceptSocket, UserControl.hwnd, lngAsyncMsg, _
        FD_READ Or FD_WRITE Or FD_CLOSE) = SOCKET_ERROR) Then
            Debug.Print "WSAAsyncSelect failed! zSubclass_Proc"
            Call closesocket(lngAcceptSocket)
            Exit Sub
        End If
        
        intIndex = ConnAdd(lngAcceptSocket)
        ConnList(intIndex).Protocol = "TCP" 'i guess?
        ConnList(intIndex).SocketAddress = udtRemote
    End If
        
    RaiseEvent Accepted(lngAcceptSocket, vbInetNtoa(udtRemote.sin_addr.s_addr), udtRemote.sin_port)
End Sub

Private Sub RecvData(ByVal lngSocket As Long)
    Dim intIndex As Integer, lngRecv As Long, bytReadBuffer() As Byte, blnRaiseRecv As Boolean
    Const BUFFER_SIZE As Integer = 1024
    
    intIndex = ConnFind(lngSocket)
    If intIndex = -1 Then
        Debug.Print "|" & CStr(lngSocket) & "|recv: socket not found!"
        Do
            ReDim bytReadBuffer(1023)
            lngRecv = recv(lngSocket, bytReadBuffer(0), UBound(bytReadBuffer) + 1, 0)
        Loop Until lngRecv <= 0
        Call closesocket(lngSocket)
        Exit Sub
    Else
        With ConnList(intIndex)
            'new idea.. -1 or 0 just exit, 1 to 1023 return recv, 1024 loop
            Do
                ReDim bytReadBuffer(BUFFER_SIZE - 1)
                lngRecv = recv(lngSocket, bytReadBuffer(0), BUFFER_SIZE, 0)
                'Debug.Print "|" & CStr(lngSocket) & "|recv: " & CStr(lngRecv) & " bytes|" & IIf(lngRecv = -1, GetWinsockError(WSAGetLastError) & "|", "")

                If lngRecv > 0 Then
                    'if less, resize
                    If lngRecv < BUFFER_SIZE Then
                        ReDim Preserve bytReadBuffer(0 To lngRecv - 1)
                    End If
                    
                    'join data received onto total
                    Call JoinArrays(.RecvBuffer, bytReadBuffer)
                    
                    'raise recv, erase buffer outside of loop
                    blnRaiseRecv = True
                End If
            Loop Until lngRecv <> BUFFER_SIZE
        End With
        
        If blnRaiseRecv Then
            RaiseEvent Received(lngSocket, ConnList(intIndex).RecvBuffer)
            Erase ConnList(intIndex).RecvBuffer
        End If
    End If
End Sub

Public Sub SendData(aSocket As Long, Data() As Byte, Optional File As String)
    Dim intIndex As Integer, i As Long, intUDPNew As Integer
    
    intIndex = ConnFind(aSocket)
    If intIndex = -1 Then
        Debug.Print "|" & CStr(aSocket) & "|senddata: socket not found!"
        'Call closesocket(aSocket)
    Else
        With ConnList(intIndex)
            'copy the bytes to send to setup the socket
            Call JoinArrays(.SendBuffer, Data)
            
            'if there is a file to send, setup the socket
            If File <> "" Then
                .File = File
                .FileStart = 1
            End If
        End With
        Call ResumeSendData(aSocket)
    End If
End Sub

Private Sub ResumeSendData(aSocket As Long)
On Error GoTo SendDataErr
    Dim intIndex As Integer, i As Long, bytBuffer() As Byte, lngSent As Long, lngError As Long
    Dim lngNew As Long, intFileNum As Integer, lngFileSize As Long, lngSize As Long
    Dim blnSent As Boolean
    
    intIndex = ConnFind(aSocket)
    If intIndex = -1 Then
        Debug.Print "|" & CStr(aSocket) & "|sending: socket not found!"
        'Call closesocket(aSocket)
    Else
        With ConnList(intIndex)
        If SafeArrayGetDim(.SendBuffer) > 0 Then
            Do Until .SendStart >= UBound(.SendBuffer)
                'only send 1024 bytes at a time.. check if over 1024
                lngSize = UBound(.SendBuffer) - .SendStart
                If lngSize > 1023 Then lngSize = 1023
                
                ReDim bytBuffer(lngSize)
                'copy the buffer into the send buffer
                For i = 0 To lngSize
                    bytBuffer(i) = .SendBuffer(.SendStart + i)
                Next i
                
                'check port to check if it has a destination
                If .Protocol = "UDP" Then
                    lngSent = sendto(aSocket, bytBuffer(0), lngSize + 1, 0&, .SocketAddress, LenB(.SocketAddress))
                ElseIf .Protocol = "TCP" Then
                    lngSent = send(aSocket, bytBuffer(0), lngSize + 1, 0&)
                End If
                lngError = WSAGetLastError
                
                If lngSent > 0 Then
                    .SendStart = .SendStart + lngSent
                    'Debug.Print "|" & CStr(aSocket) & "|sending: " & .SendStart & "/" & UBound(.SendBuffer) + 1 & "|"
                Else
                    'error.. if would block just exit
                    Debug.Print "|" & CStr(aSocket) & "|sending: " & GetWinsockError(lngError) & "|"
                    If lngError <> WSAEWOULDBLOCK Then
                        'Call closesocket(aSocket)
                        'RaiseEvent Closed(aSocket)
                    End If
                    Exit Sub
                End If
            Loop
            blnSent = True
            Erase .SendBuffer
            .SendStart = 0
        End If
                
        If .File <> "" Then
            If Dir(.File) <> "" Then
                'exists, get start and open file
                intFileNum = FreeFile
                Open .File For Binary Access Read As #intFileNum
                    lngFileSize = LOF(intFileNum)
                    Do Until .FileStart >= lngFileSize
                        'get amount of bytes to send, 1024 max
                        lngSize = 1024
                        If lngFileSize < 1024 Then lngSize = lngFileSize
                        
                        'read from the file
                        ReDim bytBuffer(lngSize - 1)
                        Get #intFileNum, .FileStart, bytBuffer
    
                        'send
                        lngSent = send(aSocket, bytBuffer(0), lngSize, 0&)
                        If lngSent > 0 Then
                            'increment the bytes read
                            .FileStart = .FileStart + lngSent
                            'Debug.Print "|" & CStr(aSocket) & "|sendfile: " & .FileStart - 1 & "/" & lngFileSize & "|"
                        Else
                            'error, close the file then exit
                            Close #intFileNum
                            lngError = WSAGetLastError
                            'Debug.Print "|" & CStr(aSocket) & "|sendfile: " & GetWinsockError(WSAGetLastError) & "|"
                            If lngError <> WSAEWOULDBLOCK Then
                                Call closesocket(aSocket)
                                RaiseEvent Closed(aSocket)
                            End If
                            Exit Sub
                        End If
                    Loop
                    blnSent = True
                    .File = ""
                Close #intFileNum
            Else
                'does not exist, erase record by just returning
                blnSent = True
                .File = ""
            End If
        End If
        End With
        
        If blnSent Then RaiseEvent DataSent(aSocket)
    End If

    Exit Sub
SendDataErr:
    
End Sub

Public Sub CloseIt(ByVal lngSocket As Long)
    Call closesocket(lngSocket)
    RaiseEvent Closed(lngSocket)
End Sub

'- Connections List Code ------------------------------------------------------------------------------
Private Function ConnAdd(ByVal lngSocket As Long) As Integer
On Error GoTo ConnAddErr
    Dim intNew As Integer
    
    If SafeArrayGetDim(ConnList) > 0 Then
        intNew = UBound(ConnList) + 1
    Else
        intNew = 0
    End If
    
    ReDim Preserve ConnList(0 To intNew)
    ConnList(intNew).sSocket = lngSocket
    
    ConnAdd = intNew
    
    Exit Function
ConnAddErr:
    Debug.Print "ConnAdd() Error: " & intNew
End Function
Private Function ConnFind(ByVal lngSocket As Long) As Integer
    Dim intIndex As Integer, i As Integer
  
    intIndex = -1
  
    If SafeArrayGetDim(ConnList) > 0 Then
        For i = UBound(ConnList) To 0 Step -1
            If ConnList(i).sSocket = lngSocket Then
                intIndex = i
                Exit For
            End If
        Next
    End If
    
    ConnFind = intIndex
End Function
Private Sub ConnRemove(ByVal intIndex As Integer)
On Error GoTo ConnRemoveErr
    Dim i As Integer
    
    If intIndex = -1 Then Exit Sub
    
    If SafeArrayGetDim(ConnList) > 0 Then
        If UBound(ConnList) = 0 Then
            Erase ConnList()
        Else
            For i = intIndex + 1 To UBound(ConnList)
              ConnList(i - 1).sSocket = ConnList(i).sSocket
              ConnList(i - 1).RecvBuffer = ConnList(i).RecvBuffer
              ConnList(i - 1).SendBuffer = ConnList(i).SendBuffer
              ConnList(i - 1).File = ConnList(i).File
              ConnList(i - 1).FileStart = ConnList(i).FileStart
            Next
            ReDim Preserve ConnList(0 To UBound(ConnList) - 1)
        End If
    End If
    
    Exit Sub
ConnRemoveErr:
    Debug.Print "ConnRemove() Error: " & intIndex
End Sub

'------------ Helper Functions ------------
Private Function LoWord(lDWord As Long) As Integer
  If lDWord And &H8000& Then
    LoWord = lDWord Or &HFFFF0000
  Else
    LoWord = lDWord And &HFFFF&
  End If
End Function

'this function will append one array (data) to another (joined)
Private Sub JoinArrays(Joined() As Byte, Data() As Byte)
    Dim lngData As Long, lngEndJoin As Long, lngTotal As Long, i As Long

    'must have info from data to join them
    If SafeArrayGetDim(Data) > 0 Then
        lngData = UBound(Data)
        'if info in joined then
        If SafeArrayGetDim(Joined) > 0 Then
            'start at ubound + 1
            lngEndJoin = UBound(Joined) + 1
            'total is ubound(joined) + 1 + ubound(data)
            lngTotal = lngEndJoin + lngData
        'else no info in joined
        Else
            'start at beginning
            lngEndJoin = 0
            'total is ubound(data)
            lngTotal = lngData
        End If
        
        'resize joined 0 to total
        ReDim Preserve Joined(0 To lngTotal)
        
        'copy over/join/append
        For i = 0 To lngData
            Joined(lngEndJoin + i) = Data(i)
        Next i
    End If
    
    'since the arrays are byref, joined() has the info from data now
End Sub

'Winsock helper functions only
Private Function GetWinsockError(lngErrorCode As Long) As String
  Select Case lngErrorCode      ' Winsock errors.
    Case WSAEINTR
      GetWinsockError = "interrupted function call"
    Case WSAEACCES
      GetWinsockError = "permission denied"
    Case WSAEFAULT
      GetWinsockError = "invalid address"
    Case WSAEINVAL
      GetWinsockError = "invalid argument"
    Case WSAEMFILE
      GetWinsockError = "too many files open"
    Case WSAEWOULDBLOCK
      GetWinsockError = "function call would block"
    Case WSAEINPROGRESS
      GetWinsockError = "blocking call already in progress"
    Case WSAEALREADY
      GetWinsockError = "operation already in progress"
    Case WSAENOTSOCK
      GetWinsockError = "not a valid socket descriptor"
    Case WSAEDESTADDRREQ
      GetWinsockError = "destination address required"
    Case WSAEMSGSIZE
      GetWinsockError = "message is too long"
    Case WSAEPROTOTYPE
      GetWinsockError = "protocol wrong type for socket"
    Case WSAENOPROTOOPT
      GetWinsockError = "bad protocol option"
    Case WSAEPROTONOSUPPORT
      GetWinsockError = "protocol not supported"
    Case WSAESOCKTNOSUPPORT
      GetWinsockError = "socket type not supported"
    Case WSAEOPNOTSUPP
      GetWinsockError = "operation not supported"
    Case WSAEPFNOSUPPORT
      GetWinsockError = "protocol family not supported"
    Case WSAEAFNOSUPPORT
      GetWinsockError = "address family not supported by protocol"
    Case WSAEADDRINUSE
      GetWinsockError = "address in use"
    Case WSAEADDRNOTAVAIL
      GetWinsockError = "address is not available"
    Case WSAENETDOWN
      GetWinsockError = "network is down"
    Case WSAENETUNREACH
      GetWinsockError = "network is unreachable"
    Case WSAENETRESET
      GetWinsockError = "network dropped connection on reset"
    Case WSAECONNABORTED
      GetWinsockError = "software caused connection abort"
    Case WSAECONNRESET
      GetWinsockError = "connection reset by peer"
    Case WSAENOBUFS
      GetWinsockError = "no buffer space available"
    Case WSAEISCONN
      GetWinsockError = "socket is already connected"
    Case WSAENOTCONN
      GetWinsockError = "socket is not connected"
    Case WSAESHUTDOWN
      GetWinsockError = "cannot send after shutdown"
    Case WSAETOOMANYREFS
      GetWinsockError = "too many socket references"
    Case WSAETIMEDOUT
      GetWinsockError = "request timed out"
    Case WSAECONNREFUSED
      GetWinsockError = "connection refused"
    Case WSAENAMETOOLONG
      GetWinsockError = "name is too long"
    Case WSAEHOSTDOWN
      GetWinsockError = "host is down"
    Case WSAEHOSTUNREACH
      GetWinsockError = "host is unreachable"
    Case WSAEPROCLIM
      GetWinsockError = "too many processes"
    Case WSASYSNOTREADY
      GetWinsockError = "network sub-system is unavailable"
    Case WSAVERNOTSUPPORTED
      GetWinsockError = "requested version not supported"
    Case WSANOTINITIALISED
      GetWinsockError = "winsock is not loaded - call WSAStartup"
    Case WSAEDISCON
      GetWinsockError = "graceful shutdown in progress"
    Case WSATYPE_NOT_FOUND
      GetWinsockError = "class type not found"
    Case WSAHOST_NOT_FOUND
      GetWinsockError = "host not found"
    Case WSATRY_AGAIN
      GetWinsockError = "non-authoritative host not found"
    Case WSANO_RECOVERY
      GetWinsockError = "non-recoverable error"
    Case WSANO_DATA
      GetWinsockError = "valid name - no data record of requested type"
    Case Else
      GetWinsockError = "unknown error(" + CStr(lngErrorCode) & ")"
  End Select
End Function

' Convert a dotted IP address into a network byte integer.
Private Function vbInetAddr(ByVal strIPAddress As String) As Long
  vbInetAddr = inet_addr(strIPAddress)
End Function
' Return a dotted 4 octet address from a 32bit network byte integer.
Private Function vbInetNtoa(ByVal lngIPAddress As Long) As String
  Dim lpString As Long, strBuffer As String
  
  lpString = inet_ntoa(lngIPAddress)
  If (lpString) Then
    ' Prepare a buffer, copy the IP into it, then trim and return.
    strBuffer = String$(16, 0)
    Call CopyMemory(ByVal strBuffer, ByVal lpString, Len(strBuffer))
    vbInetNtoa = Mid$(strBuffer, 1, InStr(1, strBuffer, Chr$(0)) - 1)
  End If
End Function

Private Function vbHostNameFromIP(ByVal strIPAddress As String) As String
  Dim udtHost As hostent, lngIPAddress As Long, lngPointer As Long, strBuffer As String
  
  ' First, convert the string IP to a long IP.
  lngIPAddress = vbInetAddr(strIPAddress)
  
  If (lngIPAddress = INADDR_NONE) Then Exit Function
  
  ' Now call gethostbyaddr to retrieve the hostent structure.
  lngPointer = gethostbyaddr(lngIPAddress, 4, AF_INET)
  If (lngPointer) Then
    ' Copy the hostent structure out of the pointer.
    Call CopyMemory(udtHost, ByVal lngPointer, LenB(udtHost))
    
    ' Prepare a string buffer and copy the hostname into it from the hostent.h_name field.
    strBuffer = String$(1024, 0)
    Call CopyMemory(ByVal strBuffer, ByVal udtHost.h_name, Len(strBuffer))
    
    ' Trim the null characters off, and return the buffer.
    vbHostNameFromIP = Mid$(strBuffer, 1, InStr(1, strBuffer, Chr$(0)) - 1)
  End If
End Function
Private Function vbIPFromHostName(ByVal strHostName As String) As String
  Dim udtHost As hostent, lngIPAddress As Long, lngPointer As Long
  Dim bytIPAddress(0 To 3) As Byte, strBuffer As String, i As Long
   
  ' Firstly, check if the hostname is already an IP.
  lngIPAddress = vbInetAddr(strHostName)
  If (lngIPAddress <> INADDR_NONE) Then
    ' If it's already an IP, just return it.
    vbIPFromHostName = strHostName
    Exit Function
  End If
  
  ' It's not an IP, so we'll have to resolve it. Call gethostbyname().
  lngPointer = gethostbyname(strHostName)
  If (lngPointer) Then
    ' Copy the hostent structure to local memory.
    Call CopyMemory(udtHost, ByVal lngPointer, LenB(udtHost))
    
    ' h_addr_list contains a pointer to a long. So, firstly, copy out the pointer.
    Call CopyMemory(lngPointer, ByVal udtHost.h_addr_list, udtHost.h_length)
    
    ' Copy the IP address into a four byte array, so we can build a dotted IP string from it.
    Call CopyMemory(bytIPAddress(0), ByVal lngPointer, udtHost.h_length)
    
    ' Build and return the IP string.
    For i = 0 To 3
      strBuffer = strBuffer & CStr(bytIPAddress(i)) & "."
    Next i
    vbIPFromHostName = Mid$(strBuffer, 1, Len(strBuffer) - 1)
  End If
End Function



'======================================================================================================
'Subclass code - The programmer may call any of the following Subclass_??? routines

'Add a message to the table of those that will invoke a callback. You should Subclass_Start first and then add the messages
Private Sub Subclass_AddMsg(ByVal lng_hWnd As Long, ByVal uMsg As Long, Optional ByVal When As eMsgWhen = MSG_AFTER)
'Parameters:
  'lng_hWnd  - The handle of the window for which the uMsg is to be added to the callback table
  'uMsg      - The message number that will invoke a callback. NB Can also be ALL_MESSAGES, ie all messages will callback
  'When      - Whether the msg is to callback before, after or both with respect to the the default (previous) handler
  With sc_aSubData(zIdx(lng_hWnd))
    If When And eMsgWhen.MSG_BEFORE Then
      Call zAddMsg(uMsg, .aMsgTblB, .nMsgCntB, eMsgWhen.MSG_BEFORE, .nAddrSub)
    End If
    If When And eMsgWhen.MSG_AFTER Then
      Call zAddMsg(uMsg, .aMsgTblA, .nMsgCntA, eMsgWhen.MSG_AFTER, .nAddrSub)
    End If
  End With
End Sub

'Delete a message from the table of those that will invoke a callback.
Private Sub Subclass_DelMsg(ByVal lng_hWnd As Long, ByVal uMsg As Long, Optional ByVal When As eMsgWhen = MSG_AFTER)
'Parameters:
  'lng_hWnd  - The handle of the window for which the uMsg is to be removed from the callback table
  'uMsg      - The message number that will be removed from the callback table. NB Can also be ALL_MESSAGES, ie all messages will callback
  'When      - Whether the msg is to be removed from the before, after or both callback tables
  With sc_aSubData(zIdx(lng_hWnd))
    If When And eMsgWhen.MSG_BEFORE Then
      Call zDelMsg(uMsg, .aMsgTblB, .nMsgCntB, eMsgWhen.MSG_BEFORE, .nAddrSub)
    End If
    If When And eMsgWhen.MSG_AFTER Then
      Call zDelMsg(uMsg, .aMsgTblA, .nMsgCntA, eMsgWhen.MSG_AFTER, .nAddrSub)
    End If
  End With
End Sub

'Return whether we're running in the IDE.
Private Function Subclass_InIDE() As Boolean
  Debug.Assert zSetTrue(Subclass_InIDE)
End Function

'Start subclassing the passed window handle
Private Function Subclass_Start(ByVal lng_hWnd As Long) As Long
'Parameters:
  'lng_hWnd  - The handle of the window to be subclassed
'Returns;
  'The sc_aSubData() index
  Const CODE_LEN              As Long = 200                                             'Length of the machine code in bytes
  Const FUNC_CWP              As String = "CallWindowProcA"                             'We use CallWindowProc to call the original WndProc
  Const FUNC_EBM              As String = "EbMode"                                      'VBA's EbMode function allows the machine code thunk to know if the IDE has stopped or is on a breakpoint
  Const FUNC_SWL              As String = "SetWindowLongA"                              'SetWindowLongA allows the cSubclasser machine code thunk to unsubclass the subclasser itself if it detects via the EbMode function that the IDE has stopped
  Const MOD_USER              As String = "user32"                                      'Location of the SetWindowLongA & CallWindowProc functions
  Const MOD_VBA5              As String = "vba5"                                        'Location of the EbMode function if running VB5
  Const MOD_VBA6              As String = "vba6"                                        'Location of the EbMode function if running VB6
  Const PATCH_01              As Long = 18                                              'Code buffer offset to the location of the relative address to EbMode
  Const PATCH_02              As Long = 68                                              'Address of the previous WndProc
  Const PATCH_03              As Long = 78                                              'Relative address of SetWindowsLong
  Const PATCH_06              As Long = 116                                             'Address of the previous WndProc
  Const PATCH_07              As Long = 121                                             'Relative address of CallWindowProc
  Const PATCH_0A              As Long = 186                                             'Address of the owner object
  Static aBuf(1 To CODE_LEN)  As Byte                                                   'Static code buffer byte array
  Static pCWP                 As Long                                                   'Address of the CallWindowsProc
  Static pEbMode              As Long                                                   'Address of the EbMode IDE break/stop/running function
  Static pSWL                 As Long                                                   'Address of the SetWindowsLong function
  Dim i                       As Long                                                   'Loop index
  Dim J                       As Long                                                   'Loop index
  Dim nSubIdx                 As Long                                                   'Subclass data index
  Dim sHex                    As String                                                 'Hex code string
  
'If it's the first time through here..
  If aBuf(1) = 0 Then
  
'The hex pair machine code representation.
    sHex = "5589E583C4F85731C08945FC8945F8EB0EE80000000083F802742185C07424E830000000837DF800750AE838000000E84D00" & _
           "00005F8B45FCC9C21000E826000000EBF168000000006AFCFF7508E800000000EBE031D24ABF00000000B900000000E82D00" & _
           "0000C3FF7514FF7510FF750CFF75086800000000E8000000008945FCC331D2BF00000000B900000000E801000000C3E33209" & _
           "C978078B450CF2AF75278D4514508D4510508D450C508D4508508D45FC508D45F85052B800000000508B00FF90A4070000C3"

'Convert the string from hex pairs to bytes and store in the static machine code buffer
    i = 1
    Do While J < CODE_LEN
      J = J + 1
      aBuf(J) = Val("&H" & Mid$(sHex, i, 2))                                            'Convert a pair of hex characters to an eight-bit value and store in the static code buffer array
      i = i + 2
    Loop                                                                                'Next pair of hex characters
    
'Get API function addresses
    If Subclass_InIDE Then                                                              'If we're running in the VB IDE
      aBuf(16) = &H90                                                                   'Patch the code buffer to enable the IDE state code
      aBuf(17) = &H90                                                                   'Patch the code buffer to enable the IDE state code
      pEbMode = zAddrFunc(MOD_VBA6, FUNC_EBM)                                           'Get the address of EbMode in vba6.dll
      If pEbMode = 0 Then                                                               'Found?
        pEbMode = zAddrFunc(MOD_VBA5, FUNC_EBM)                                         'VB5 perhaps
      End If
    End If
    
    pCWP = zAddrFunc(MOD_USER, FUNC_CWP)                                                'Get the address of the CallWindowsProc function
    pSWL = zAddrFunc(MOD_USER, FUNC_SWL)                                                'Get the address of the SetWindowLongA function
    ReDim sc_aSubData(0 To 0) As tSubData                                               'Create the first sc_aSubData element
  Else
    nSubIdx = zIdx(lng_hWnd, True)
    If nSubIdx = -1 Then                                                                'If an sc_aSubData element isn't being re-cycled
      nSubIdx = UBound(sc_aSubData()) + 1                                               'Calculate the next element
      ReDim Preserve sc_aSubData(0 To nSubIdx) As tSubData                              'Create a new sc_aSubData element
    End If
    
    Subclass_Start = nSubIdx
  End If

  With sc_aSubData(nSubIdx)
    .hwnd = lng_hWnd                                                                    'Store the hWnd
    .nAddrSub = GlobalAlloc(GMEM_FIXED, CODE_LEN)                                       'Allocate memory for the machine code WndProc
    .nAddrOrig = SetWindowLongA(.hwnd, GWL_WNDPROC, .nAddrSub)                          'Set our WndProc in place
    Call RtlMoveMemory(ByVal .nAddrSub, aBuf(1), CODE_LEN)                              'Copy the machine code from the static byte array to the code array in sc_aSubData
    Call zPatchRel(.nAddrSub, PATCH_01, pEbMode)                                        'Patch the relative address to the VBA EbMode api function, whether we need to not.. hardly worth testing
    Call zPatchVal(.nAddrSub, PATCH_02, .nAddrOrig)                                     'Original WndProc address for CallWindowProc, call the original WndProc
    Call zPatchRel(.nAddrSub, PATCH_03, pSWL)                                           'Patch the relative address of the SetWindowLongA api function
    Call zPatchVal(.nAddrSub, PATCH_06, .nAddrOrig)                                     'Original WndProc address for SetWindowLongA, unsubclass on IDE stop
    Call zPatchRel(.nAddrSub, PATCH_07, pCWP)                                           'Patch the relative address of the CallWindowProc api function
    Call zPatchVal(.nAddrSub, PATCH_0A, ObjPtr(Me))                                     'Patch the address of this object instance into the static machine code buffer
  End With
End Function

'Stop all subclassing
Private Sub Subclass_StopAll()
  Dim i As Long
  
  i = UBound(sc_aSubData())                                                             'Get the upper bound of the subclass data array
  Do While i >= 0                                                                       'Iterate through each element
    With sc_aSubData(i)
      If .hwnd <> 0 Then                                                                'If not previously Subclass_Stop'd
        Call Subclass_Stop(.hwnd)                                                       'Subclass_Stop
      End If
    End With
    
    i = i - 1                                                                           'Next element
  Loop
End Sub

'Stop subclassing the passed window handle
Private Sub Subclass_Stop(ByVal lng_hWnd As Long)
'Parameters:
  'lng_hWnd  - The handle of the window to stop being subclassed
  With sc_aSubData(zIdx(lng_hWnd))
    Call SetWindowLongA(.hwnd, GWL_WNDPROC, .nAddrOrig)                                 'Restore the original WndProc
    Call zPatchVal(.nAddrSub, PATCH_05, 0)                                              'Patch the Table B entry count to ensure no further 'before' callbacks
    Call zPatchVal(.nAddrSub, PATCH_09, 0)                                              'Patch the Table A entry count to ensure no further 'after' callbacks
    'Call GlobalFree(.nAddrSub)                                                          'Release the machine code memory
    .hwnd = 0                                                                           'Mark the sc_aSubData element as available for re-use
    .nMsgCntB = 0                                                                       'Clear the before table
    .nMsgCntA = 0                                                                       'Clear the after table
    Erase .aMsgTblB                                                                     'Erase the before table
    Erase .aMsgTblA                                                                     'Erase the after table
  End With
End Sub

'======================================================================================================
'These z??? routines are exclusively called by the Subclass_??? routines.

'Worker sub for Subclass_AddMsg
Private Sub zAddMsg(ByVal uMsg As Long, ByRef aMsgTbl() As Long, ByRef nMsgCnt As Long, ByVal When As eMsgWhen, ByVal nAddr As Long)
  Dim nEntry  As Long                                                                   'Message table entry index
  Dim nOff1   As Long                                                                   'Machine code buffer offset 1
  Dim nOff2   As Long                                                                   'Machine code buffer offset 2
  
  If uMsg = ALL_MESSAGES Then                                                           'If all messages
    nMsgCnt = ALL_MESSAGES                                                              'Indicates that all messages will callback
  Else                                                                                  'Else a specific message number
    Do While nEntry < nMsgCnt                                                           'For each existing entry. NB will skip if nMsgCnt = 0
      nEntry = nEntry + 1
      
      If aMsgTbl(nEntry) = 0 Then                                                       'This msg table slot is a deleted entry
        aMsgTbl(nEntry) = uMsg                                                          'Re-use this entry
        Exit Sub                                                                        'Bail
      ElseIf aMsgTbl(nEntry) = uMsg Then                                                'The msg is already in the table!
        Exit Sub                                                                        'Bail
      End If
    Loop                                                                                'Next entry

    nMsgCnt = nMsgCnt + 1                                                               'New slot required, bump the table entry count
    ReDim Preserve aMsgTbl(1 To nMsgCnt) As Long                                        'Bump the size of the table.
    aMsgTbl(nMsgCnt) = uMsg                                                             'Store the message number in the table
  End If

  If When = eMsgWhen.MSG_BEFORE Then                                                    'If before
    nOff1 = PATCH_04                                                                    'Offset to the Before table
    nOff2 = PATCH_05                                                                    'Offset to the Before table entry count
  Else                                                                                  'Else after
    nOff1 = PATCH_08                                                                    'Offset to the After table
    nOff2 = PATCH_09                                                                    'Offset to the After table entry count
  End If

  If uMsg <> ALL_MESSAGES Then
    Call zPatchVal(nAddr, nOff1, VarPtr(aMsgTbl(1)))                                    'Address of the msg table, has to be re-patched because Redim Preserve will move it in memory.
  End If
  Call zPatchVal(nAddr, nOff2, nMsgCnt)                                                 'Patch the appropriate table entry count
End Sub

'Return the memory address of the passed function in the passed dll
Private Function zAddrFunc(ByVal sDLL As String, ByVal sProc As String) As Long
  zAddrFunc = GetProcAddress(GetModuleHandleA(sDLL), sProc)
  Debug.Assert zAddrFunc                                                                'You may wish to comment out this line if you're using vb5 else the EbMode GetProcAddress will stop here everytime because we look for vba6.dll first
End Function

'Worker sub for Subclass_DelMsg
Private Sub zDelMsg(ByVal uMsg As Long, ByRef aMsgTbl() As Long, ByRef nMsgCnt As Long, ByVal When As eMsgWhen, ByVal nAddr As Long)
  Dim nEntry As Long
  
  If uMsg = ALL_MESSAGES Then                                                           'If deleting all messages
    nMsgCnt = 0                                                                         'Message count is now zero
    If When = eMsgWhen.MSG_BEFORE Then                                                  'If before
      nEntry = PATCH_05                                                                 'Patch the before table message count location
    Else                                                                                'Else after
      nEntry = PATCH_09                                                                 'Patch the after table message count location
    End If
    Call zPatchVal(nAddr, nEntry, 0)                                                    'Patch the table message count to zero
  Else                                                                                  'Else deleteting a specific message
    Do While nEntry < nMsgCnt                                                           'For each table entry
      nEntry = nEntry + 1
      If aMsgTbl(nEntry) = uMsg Then                                                    'If this entry is the message we wish to delete
        aMsgTbl(nEntry) = 0                                                             'Mark the table slot as available
        Exit Do                                                                         'Bail
      End If
    Loop                                                                                'Next entry
  End If
End Sub

'Get the sc_aSubData() array index of the passed hWnd
Private Function zIdx(ByVal lng_hWnd As Long, Optional ByVal bAdd As Boolean = False) As Long
'Get the upper bound of sc_aSubData() - If you get an error here, you're probably Subclass_AddMsg-ing before Subclass_Start
  zIdx = UBound(sc_aSubData)
  Do While zIdx >= 0                                                                    'Iterate through the existing sc_aSubData() elements
    With sc_aSubData(zIdx)
      If .hwnd = lng_hWnd Then                                                          'If the hWnd of this element is the one we're looking for
        If Not bAdd Then                                                                'If we're searching not adding
          Exit Function                                                                 'Found
        End If
      ElseIf .hwnd = 0 Then                                                             'If this an element marked for reuse.
        If bAdd Then                                                                    'If we're adding
          Exit Function                                                                 'Re-use it
        End If
      End If
    End With
    zIdx = zIdx - 1                                                                     'Decrement the index
  Loop
  
  If Not bAdd Then
    Debug.Assert False                                                                  'hWnd not found, programmer error
  End If

'If we exit here, we're returning -1, no freed elements were found
End Function

'Patch the machine code buffer at the indicated offset with the relative address to the target address.
Private Sub zPatchRel(ByVal nAddr As Long, ByVal nOffset As Long, ByVal nTargetAddr As Long)
  Call RtlMoveMemory(ByVal nAddr + nOffset, nTargetAddr - nAddr - nOffset - 4, 4)
End Sub

'Patch the machine code buffer at the indicated offset with the passed value
Private Sub zPatchVal(ByVal nAddr As Long, ByVal nOffset As Long, ByVal nValue As Long)
  Call RtlMoveMemory(ByVal nAddr + nOffset, nValue, 4)
End Sub

'Worker function for Subclass_InIDE
Private Function zSetTrue(ByRef bValue As Boolean) As Boolean
  zSetTrue = True
  bValue = True
End Function

