package lfsqualifyingticker.structures;

import java.util.HashMap;

import net.sf.jinsim.response.NewPlayerResponse;
import net.sf.jinsim.types.CompCar;

/**
 * The interface for listeners to the TimingModel
 * @author Gus
 *
 */

public interface TimingModelListener {
	/**
	 * The given player has joined the qualifying session
	 * @param playerJoining
	 */
	public void playerJoinedSession(byte playerIDJoining);
	
	/**
	 * The given player has left the qualifying session
	 * @param playerLeaving
	 */
	public void playerLeftSession(byte playerIDLeaving);
	
	/**
	 * The given player has started a hotlap
	 * @param player
	 */
	public void playerStartedHotlap(byte playerID);
	
	/**
	 * The given player has pitted
	 * @param playerPitting
	 */
	public void playerPitted(byte playerIDPitting);
	
	/**
	 * The given player has completed a lap
	 * @param playerIDStartedHotlap
	 */
	public void playerCompletedLap(byte playerIDStartedHotlap);
	
	/**
	 * The fastest lap in the session has been updated to the given lap
	 * @param fastestLap
	 */
	public void fastestLapUpdated(Lap fastestLap);
	
	/**
	 * The players positions have been updated
	 * @param playerPositions
	 */
	public void updatePlayerPositionNodes(HashMap<NewPlayerResponse, CompCar> playerPositions);
}
