package lfsqualifyingticker.structures;

import java.util.HashMap;

/**
 * Contains the total gap between two laps over a number of nodes. Used 
 * to calculate the average gap between the drivers
 * @author Gus
 *
 */

public class GapOverNumberOfNodes {
	// HashMap containing the gaps at various nodes. Key is node index
	private HashMap<Integer, Long> gapsAtNodes = new HashMap<Integer, Long>();

	/**
	 * 
	 */
	public GapOverNumberOfNodes() {
		
	}
	
	/**
	 * Add a gap to this object
	 * @param nodeIndex
	 * @param gap
	 */
	public void addGap(int nodeIndex, long gap) {
		gapsAtNodes.put(nodeIndex, gap);
	}
	
	/**
	 * 
	 * @param nodeIndex
	 * @return
	 */
	public Long getGapAtIndex(int nodeIndex) {
		if(gapsAtNodes.containsKey(nodeIndex)) {
			return gapsAtNodes.get(nodeIndex);
		} else {
			return null;
		}
	}
	
	/**
	 * Get the total gap over all of the nodes contained in this object
	 * @return
	 */
	public long getTotalGap() {
		long totalGap = 0;
		
		for(Long gap : gapsAtNodes.values()) {
			totalGap += gap;
		}
		
		return totalGap;
	}
	
	/**
	 * Get the number of nodes in this object
	 * @return
	 */
	public int getNumNodes() {
		return gapsAtNodes.size();
	}
	
	/**
	 * Returns the average gap over the nodes contained in this object
	 * @return
	 */
	public Double getAverageGap() {
		if(gapsAtNodes.size() == 0) {
			return null;
		} else {
			return getTotalGap() / (double) getNumNodes();
		}
	}
}
