package lfsqualifyingticker;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.swing.JOptionPane;

import lfsqualifyingticker.models.TrackModel;
import lfsqualifyingticker.structures.QualiTickerPrefs;

public class LFSQualifyingTickerStart {
	private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat(
			"EEE d MMM yyyy HH:mm:ss");

	public static void main(String[] args) {
		createLogFile();

		QualiTickerPrefs.loadPreferencesFromFile();

		loadTrackDetails();

		new LFSQualifyingTicker();
	}
	
	/**
	 * Create a log file for the LFS Qualifying Ticker application by redirecting 
	 * System.err output
	 */
	private static void createLogFile() {
		try {
			FileOutputStream fos = new FileOutputStream("LFSQualifyingTicker.log");
			PrintStream ps = new PrintStream(fos);
			System.setErr(ps);
		} catch (FileNotFoundException fnfe) {
			fnfe.printStackTrace();
			print("Error creating log file: "+fnfe.getMessage());
		}
	}

	private static void loadTrackDetails() {
		try {
			TrackModel.loadAllTrackData();
		} catch(Exception e) {
			JOptionPane.showMessageDialog(null, 
					"There was a problem reading the track information files\n" +
					"LFS Qualifying Ticker cannot continue.\n" +
					"Details: "+e.getMessage(), 
					"Problem Reading Config File", 
					JOptionPane.ERROR_MESSAGE);
			
			System.exit(1);
		}
	}
	
	/**
	 * Prints the given message to the console and to log file
	 * @param msg
	 */
	public static void print(String msg) {
		System.out.println(DATE_FORMAT.format(new Date())+" - "+msg);
		System.err.println(DATE_FORMAT.format(new Date())+" - "+msg);
	}
}
