package lfstrackdatatesting;

import java.util.Comparator;

/**
 * Represents one node on a track
 * @author Gus
 *
 */

public class OneNode implements Comparator<OneNode>, Comparable<OneNode> {
	int nodeIndex, centreX, centreY, centreZ; 
	float directionX, directionY, directionZ, limitLeft, 
		limitRight, driveLeft, driveRight;

	/**
	 * Construct a new node with the given parameters
	 * @param nodeIndex
	 * @param centreX
	 * @param centreY
	 * @param centreZ
	 * @param directionX
	 * @param directionY
	 * @param directionZ
	 * @param limitLeft
	 * @param limitRight
	 * @param driveLeft
	 * @param driveRight
	 */
	public OneNode(int nodeIndex, 
			int centreX, int centreY, int centreZ, 
			float directionX, float directionY, float directionZ, 
			float limitLeft, float limitRight, 
			float driveLeft, float driveRight) {
		this.nodeIndex = nodeIndex;
		
		this.centreX = centreX;
		this.centreY = centreY;
		this.centreZ = centreZ;
		
		this.directionX = directionX;
		this.directionY = directionY;
		this.directionZ = directionZ;
		
		this.limitLeft = limitLeft;
		this.limitRight = limitRight;
		
		this.driveLeft = driveLeft;
		this.driveRight = driveRight;
	}
	
	/**
	 * 
	 * @return
	 */
	public int getNodeIndex() {
		return nodeIndex;
	}
	
	/**
	 * 
	 * @return
	 */
	public int getCentreX() {
		return centreX;
	}

	/**
	 * 
	 * @return
	 */
	public int getCentreY() {
		return centreY;
	}

	/**
	 * 
	 * @return
	 */
	public int getCentreZ() {
		return centreZ;
	}

	/**
	 * 
	 * @return
	 */
	public float getDirectionX() {
		return directionX;
	}

	/**
	 * 
	 * @return
	 */
	public float getDirectionY() {
		return directionY;
	}

	/**
	 * 
	 * @return
	 */
	public float getDirectionZ() {
		return directionZ;
	}

	/**
	 * 
	 * @return
	 */
	public float getLimitLeft() {
		return limitLeft;
	}

	/**
	 * 
	 * @return
	 */
	public float getLimitRight() {
		return limitRight;
	}

	/**
	 * 
	 * @return
	 */
	public float getDriveLeft() {
		return driveLeft;
	}

	/**
	 * 
	 * @return
	 */
	public float getDriveRight() {
		return driveRight;
	}

	/*
	 * (non-Javadoc)
	 * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
	 */
	public int compare(OneNode o1, OneNode o2) {
		if(o1.getNodeIndex() < o2.getNodeIndex()) {
			return -1;
		} else if(o1.getNodeIndex() > o2.getNodeIndex()) {
			return 1;
		} else {
			return 0;
		}
	}
	
	/*
	 * For testing purposes. Highlights the differences between this node and 
	 * the given node
	 */
	public String getDifferenceComparedToAnotherNode(OneNode comp) {
		StringBuilder diff = new StringBuilder();
		
		diff.append("Differences between node "+this.getNodeIndex()+
				" and node "+comp.getNodeIndex()+"\n");
		
		if(this.centreX != comp.getCentreX()) {
			diff.append("centreX: "+((this.getCentreX()-comp.getCentreX())/65536.0)+"\n");
		}
		if(this.centreY != comp.getCentreY()) {
			diff.append("centreY: "+((this.getCentreY()-comp.getCentreY())/65536.0)+"\n");
		}
		if(this.centreZ != comp.getCentreZ()) {
			diff.append("centreZ: "+((this.getCentreZ()-comp.getCentreZ())/65536.0)+"\n");
		}
		
		if(this.directionX != comp.getDirectionX()) {
			diff.append("directionX: "+(this.getDirectionX()-comp.getDirectionX())+"\n");
		}
		if(this.directionY != comp.getDirectionY()) {
			diff.append("directionY: "+(this.getDirectionY()-comp.getDirectionY())+"\n");
		}
		if(this.directionZ != comp.getDirectionZ()) {
			diff.append("directionZ: "+(this.getDirectionZ()-comp.getDirectionZ())+"\n");
		}

		if(this.limitLeft != comp.getLimitLeft()) {
			diff.append("limitLeft: "+(this.getLimitLeft()-comp.getLimitLeft())+"\n");
		}
		if(this.limitRight != comp.getLimitRight()) {
		diff.append("limitRight: "+(this.getLimitRight()-comp.getLimitRight())+"\n");
		}
		
		if(this.driveLeft != comp.getDriveLeft()) {
			diff.append("driveLeft: "+(this.getDriveLeft()-comp.getDriveLeft())+"\n");
		}
		if(this.driveRight != comp.getDriveRight()) {
			diff.append("driveRight: "+(this.getDriveRight()-comp.getDriveRight())+"\n");
		}

		return diff.toString();
	}

	/*
	 * (non-Javadoc)
	 * @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	public int compareTo(OneNode o) {
		return compare(this, o);
	}
	
	/*
	 * (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return "Node: "+nodeIndex+", centre: ("+centreX+","+centreY+","+centreZ+"), " +
				"dir: ("+directionX+","+directionY+","+directionZ+"), " +
				"lim (L: "+limitLeft+", R: "+limitRight+"), " +
				"drive (L: "+driveLeft+", R: "+driveRight+")";
	}
}
