#
# This file is part of AutoMessage Redux.
# 
# AutoMessage Redux is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License as published by the Free 
# Software Foundation, either version 3 of the License, or (at your option) any 
# later version.
#
# AutoMessage Redux is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
# FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more 
# details.
#
# You should have received a copy of the GNU General Public License along with 
# AutoMessage Redux. If not, see <http://www.gnu.org/licenses/>.
#

"""Defines, saves and loads the program's configuration file."""

# Dependencies
import cPickle

def save(cfg, path):
    with open(path, 'w') as f:
        cPickle.dump(cfg, f)
        
def load(path):
    try:
        with open(path, 'r') as f:
            return cPickle.load(f)
    except:
        return Config()
        
class Config:
    def __init__(self):
        self.host = 'localhost'
        self.port = 29999
        self.admin = ''
        self.minimise = True
        self.interval = 0
        self.lfsExePath = ''
        self.autoConnect = True
        self.youConnect = '^7Hello!'
        self.playerConnects = '^7Welcome, {player}^7!'
        self.raceStarts = '^7Good luck and drive safely!'
        self.raceEnds = '^7Thanks for racing!'
        self.fastestLap = '^7Hey, slow down!'
        self.personalBest = '^7Congratulations!'
        self.messages = []
        self.messages.append(['bye;cu;cya', '^7Goodbye, {player}^7!'])
        self.messages.append(['night;goodnight;gn8', '^7Goodnight, {player}^7!'])
        self.messages.append(['fuck;shit;arse;bollocks;retard', '^7Hey, {player}, ^7watch your language!'])  
         