#
# This file is part of AutoMessage Redux.
# 
# AutoMessage Redux is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License as published by the Free 
# Software Foundation, either version 3 of the License, or (at your option) any 
# later version.
#
# AutoMessage Redux is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
# FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more 
# details.
#
# You should have received a copy of the GNU General Public License along with 
# AutoMessage Redux. If not, see <http://www.gnu.org/licenses/>.
#

"""Contains the main menu, popup menus and the main taskbar icon."""

# Dependencies.
import wx

# Libraries.
import info


class MainTaskBarIcon(wx.TaskBarIcon):
    def __init__(self, *args, **kwds):
        wx.TaskBarIcon.__init__(self, *args, **kwds)
    
    def CreatePopupMenu(self):
        menu = wx.Menu()
        menu.Append(info.ID_RESTORE, 'Restore', 'Restore the program')
        menu.AppendSeparator()
        menu.Append(info.ID_EXIT, 'Exit', 'Exit the program')
        return menu


class ManagedMenu(wx.Menu):
    def __init__(self, *args, **kwds):
        wx.Menu.__init__(self, *args, **kwds)
        
    def Append(self, id, text, help='', icon=None, kind=wx.ITEM_NORMAL):
        item = wx.MenuItem(self, id, text, help, kind)
        if icon:
            item.SetBitmap(wx.BitmapFromImage(wx.Image(icon, wx.BITMAP_TYPE_PNG)))
        self.AppendItem(item)    


class MainMenuBar(wx.MenuBar):
    def __init__(self, *args, **kwds):
        wx.MenuBar.__init__(self, *args, **kwds)
        
        file = ManagedMenu()
        file.Append(info.ID_EXIT, 'Exit\tALT+F4', 'Exit the program', info.ICON_EXIT)
        self.Append(file, '&File')
        
        insim = ManagedMenu()
        insim.Append(info.ID_OPTIONS, 'Options...', 'Configure InSim options', info.ICON_OPTIONS)
        insim.AppendSeparator()
        insim.Append(info.ID_CONNECT, 'Connect\tCTRL+T', 'Connect to LFS')
        insim.Append(info.ID_DISCONNECT, 'Disconnect\tCTRL+X', 'Disconnect from LFS')
        insim.AppendSeparator()
        insim.Append(info.ID_LAUNCH, 'Launch LFS', 'Launch LFS and connect to InSim')
        self.Append(insim, '&InSim')
        
        help = ManagedMenu()
        help.Append(info.ID_ABOUT, 'About\tF1', 'About the program', info.ICON_HELP)
        self.Append(help, '&Help')
        
        self.connected(False)
        
    def connected(self, enable):
        self.Enable(info.ID_OPTIONS, not enable)
        self.Enable(info.ID_CONNECT, not enable)
        self.Enable(info.ID_DISCONNECT, enable)
        self.Enable(info.ID_LAUNCH, not enable)
        
        
class WordsPopupMenu(wx.Menu):
    def __init__(self, *args, **kwds):
        wx.Menu.__init__(self, *args, **kwds)
        self.Append(info.ID_EDIT, 'Edit', 'Edit the currently selected message')
        self.AppendSeparator()
        self.Append(info.ID_REMOVE, 'Remove', 'Remove the currently selected message')
        
        