#
# This file is part of AutoMessage Redux.
# 
# AutoMessage Redux is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License as published by the Free 
# Software Foundation, either version 3 of the License, or (at your option) any 
# later version.
#
# AutoMessage Redux is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
# FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more 
# details.
#
# You should have received a copy of the GNU General Public License along with 
# AutoMessage Redux. If not, see <http://www.gnu.org/licenses/>.
#

"""Defines and launches the main AutoMessage application."""

# Libraries.
import src.main as main
import src.info as info

# Check wxPython version.
import sys   
if sys.modules.has_key('wx') or sys.modules.has_key('wxPython'):
    pass # Already loaded.
else:
    try:
        import wxversion
        wxversion.ensureMinimal(info.MIN_WX_VERSION)
    except ImportError:
        print '%s requires that wxPython be installed, download it from \
http://www.wxpython.org/' % info.PROG_NAME
        sys.exit(-1)
    
# We should be good to go.
import wx


class AutoMessage(wx.App):
    def __init__(self, *args, **kwds):
        wx.App.__init__(self, *args, **kwds)
        
    def OnInit(self):
        # Create and launch the main program window.
        style = wx.DEFAULT_DIALOG_STYLE | wx.MINIMIZE_BOX
        frame = main.MainFrame(None, wx.ID_ANY, info.PROG_NAME, size=(500, 530), style=style)        
        self.SetTopWindow(frame)
        return True
        
        
if __name__ == '__main__':
    # Start the application.
    AutoMessage(redirect=info.REDIRECT_ERRORS).MainLoop()
    