#
# This file is part of AutoMessage Redux.
# 
# AutoMessage Redux is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License as published by the Free 
# Software Foundation, either version 3 of the License, or (at your option) any 
# later version.
#
# AutoMessage Redux is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
# FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more 
# details.
#
# You should have received a copy of the GNU General Public License along with 
# AutoMessage Redux. If not, see <http://www.gnu.org/licenses/>.
#

"""This file was generate by wxGlade.

http://wxglade.sourceforge.net/

See the file wxg.wxg to edit these controls.

"""

# Dependenvies.
import wx


class EditDialog(wx.Dialog):
    def __init__(self, *args, **kwds):
        # begin wxGlade: EditDialog.__init__
        kwds["style"] = wx.DEFAULT_DIALOG_STYLE
        wx.Dialog.__init__(self, *args, **kwds)
        self.wordLabel = wx.StaticText(self, -1, "Words:")
        self.wordsTextCtrl = wx.TextCtrl(self, -1, "")
        self.messageLabel = wx.StaticText(self, -1, "Message:")
        self.messageTextCtrl = wx.TextCtrl(self, -1, "")
        self.acceptButton = wx.Button(self, -1, "&Accept")
        self.cancelButton = wx.Button(self, wx.ID_CANCEL, "")

        self.__set_properties()
        self.__do_layout()
        # end wxGlade

    def __set_properties(self):
        # begin wxGlade: EditDialog.__set_properties
        self.SetTitle("Edit Message")
        self.SetSize((300, 190))
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: EditDialog.__do_layout
        mainSizer = wx.BoxSizer(wx.VERTICAL)
        okCancelSizer = wx.BoxSizer(wx.HORIZONTAL)
        sizer_2 = wx.BoxSizer(wx.VERTICAL)
        sizer_2.Add(self.wordLabel, 0, wx.LEFT|wx.TOP, 7)
        sizer_2.Add(self.wordsTextCtrl, 0, wx.LEFT|wx.RIGHT|wx.TOP|wx.EXPAND, 7)
        sizer_2.Add(self.messageLabel, 0, wx.LEFT|wx.TOP, 7)
        sizer_2.Add(self.messageTextCtrl, 0, wx.LEFT|wx.RIGHT|wx.TOP|wx.EXPAND, 7)
        mainSizer.Add(sizer_2, 1, wx.EXPAND, 0)
        okCancelSizer.Add(self.acceptButton, 0, wx.RIGHT|wx.BOTTOM, 7)
        okCancelSizer.Add(self.cancelButton, 0, wx.RIGHT|wx.BOTTOM, 7)
        mainSizer.Add(okCancelSizer, 0, wx.ALIGN_RIGHT, 0)
        self.SetSizer(mainSizer)
        self.Layout()
        self.Centre()
        # end wxGlade

# end of class EditDialog


class OptionsDialog(wx.Dialog):
    def __init__(self, *args, **kwds):
        # begin wxGlade: OptionsDialog.__init__
        kwds["style"] = wx.DEFAULT_DIALOG_STYLE
        wx.Dialog.__init__(self, *args, **kwds)
        self.mainNotebook = wx.Notebook(self, -1, style=0)
        self.lfsPane = wx.Panel(self.mainNotebook, -1)
        self.insimPane = wx.Panel(self.mainNotebook, -1)
        self.hostLabel = wx.StaticText(self.insimPane, -1, "Host Address:")
        self.hostTextCtrl = wx.TextCtrl(self.insimPane, -1, "")
        self.portLabel = wx.StaticText(self.insimPane, -1, "InSim Port:")
        self.portSpinCtrl = wx.SpinCtrl(self.insimPane, -1, "", min=0, max=32767)
        self.adminLabel = wx.StaticText(self.insimPane, -1, "Admin Pass:")
        self.adminTextCtrl = wx.TextCtrl(self.insimPane, -1, "")
        self.intervalLabel = wx.StaticText(self.insimPane, -1, "Interval:")
        self.intervalSpinCtrl = wx.SpinCtrl(self.insimPane, -1, "", min=0, max=100)
        self.minimiseCheckbox = wx.CheckBox(self.insimPane, -1, "Minimise to Tray")
        self.lfsExeLabel = wx.StaticText(self.lfsPane, -1, "Location of LFS.exe (optional):")
        self.lfsExeTextCtrl = wx.TextCtrl(self.lfsPane, -1, "", style=wx.TE_READONLY)
        self.lfsExeButton = wx.BitmapButton(self.lfsPane, -1, wx.Bitmap("src\\icons\\open.png", wx.BITMAP_TYPE_ANY))
        self.autoConnectCheckBox = wx.CheckBox(self.lfsPane, -1, "Auto-connect after launching")
        self.acceptButton = wx.Button(self, -1, "&Accept")
        self.cancelButton = wx.Button(self, wx.ID_CANCEL, "")

        self.__set_properties()
        self.__do_layout()
        # end wxGlade

    def __set_properties(self):
        # begin wxGlade: OptionsDialog.__set_properties
        self.SetTitle("Options")
        self.SetSize((300, 300))
        self.hostTextCtrl.SetMinSize((180, -1))
        self.hostTextCtrl.SetToolTipString("Address of the host where LFS is running")
        self.portSpinCtrl.SetMinSize((180, -1))
        self.portSpinCtrl.SetToolTipString("Port to connect to LFS through")
        self.adminTextCtrl.SetToolTipString("LFS game admin password")
        self.intervalSpinCtrl.SetMinSize((180, -1))
        self.intervalSpinCtrl.SetToolTipString("Minimum delay in seconds between messages (anti-spam)")
        self.minimiseCheckbox.SetToolTipString("Minimise the program to the system tray")
        self.lfsExeTextCtrl.SetMinSize((225, -1))
        self.lfsExeTextCtrl.SetBackgroundColour(wx.Colour(236, 233, 216))
        self.lfsExeTextCtrl.SetToolTipString("Path to your LFS.exe file, for use in the launcher")
        self.lfsExeButton.SetToolTipString("Browse to the location of your LFS.exe")
        self.lfsExeButton.SetSize(self.lfsExeButton.GetBestSize())
        self.autoConnectCheckBox.SetToolTipString("Auto-connect to InSim after LFS has been launched")
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: OptionsDialog.__do_layout
        mainSizer = wx.BoxSizer(wx.VERTICAL)
        buttonSizer = wx.BoxSizer(wx.HORIZONTAL)
        lfsSizer = wx.BoxSizer(wx.VERTICAL)
        lfsExeSizer = wx.BoxSizer(wx.HORIZONTAL)
        insimSizer = wx.FlexGridSizer(5, 2, 0, 0)
        insimSizer.Add(self.hostLabel, 0, wx.LEFT|wx.TOP|wx.ALIGN_CENTER_VERTICAL, 7)
        insimSizer.Add(self.hostTextCtrl, 0, wx.LEFT|wx.TOP|wx.ALIGN_CENTER_VERTICAL, 7)
        insimSizer.Add(self.portLabel, 0, wx.LEFT|wx.TOP|wx.ALIGN_CENTER_VERTICAL, 7)
        insimSizer.Add(self.portSpinCtrl, 0, wx.LEFT|wx.TOP|wx.ALIGN_CENTER_VERTICAL, 7)
        insimSizer.Add(self.adminLabel, 0, wx.LEFT|wx.TOP|wx.ALIGN_CENTER_VERTICAL, 7)
        insimSizer.Add(self.adminTextCtrl, 0, wx.LEFT|wx.TOP|wx.EXPAND|wx.ALIGN_CENTER_VERTICAL, 7)
        insimSizer.Add(self.intervalLabel, 0, wx.LEFT|wx.TOP|wx.ALIGN_CENTER_VERTICAL, 7)
        insimSizer.Add(self.intervalSpinCtrl, 0, wx.LEFT|wx.TOP|wx.ALIGN_CENTER_VERTICAL, 7)
        insimSizer.Add((1, 1), 0, 0, 0)
        insimSizer.Add(self.minimiseCheckbox, 0, wx.LEFT|wx.TOP|wx.ALIGN_CENTER_VERTICAL, 7)
        self.insimPane.SetSizer(insimSizer)
        lfsSizer.Add(self.lfsExeLabel, 0, wx.LEFT|wx.TOP, 7)
        lfsExeSizer.Add(self.lfsExeTextCtrl, 0, wx.LEFT|wx.TOP|wx.ALIGN_CENTER_VERTICAL, 7)
        lfsExeSizer.Add(self.lfsExeButton, 0, wx.LEFT|wx.TOP|wx.ALIGN_CENTER_VERTICAL, 7)
        lfsSizer.Add(lfsExeSizer, 0, wx.EXPAND, 0)
        lfsSizer.Add(self.autoConnectCheckBox, 0, wx.LEFT|wx.TOP, 7)
        self.lfsPane.SetSizer(lfsSizer)
        self.mainNotebook.AddPage(self.insimPane, "InSim")
        self.mainNotebook.AddPage(self.lfsPane, "LFS")
        mainSizer.Add(self.mainNotebook, 1, wx.ALL|wx.EXPAND, 7)
        buttonSizer.Add(self.acceptButton, 0, wx.RIGHT|wx.BOTTOM, 7)
        buttonSizer.Add(self.cancelButton, 0, wx.RIGHT|wx.BOTTOM, 7)
        mainSizer.Add(buttonSizer, 0, wx.ALIGN_RIGHT, 0)
        self.SetSizer(mainSizer)
        self.Layout()
        self.Centre()
        # end wxGlade

# end of class OptionsDialog


