#
# This file is part of AutoMessage Redux.
# 
# AutoMessage Redux is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License as published by the Free 
# Software Foundation, either version 3 of the License, or (at your option) any 
# later version.
#
# AutoMessage Redux is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
# FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more 
# details.
#
# You should have received a copy of the GNU General Public License along with 
# AutoMessage Redux. If not, see <http://www.gnu.org/licenses/>.
#

"""General program information."""

# Dependencies.
import os
import wx

REDIRECT_ERRORS = True
DEBUG_MESSAGES = False
MIN_WX_VERSION = '2.8.0.0'

PROG_NAME = 'AutoMessage Redux'
PROG_INAME = '^3AutoMessage'
PROG_VERSION = '0.3'
PROG_COPYRIGHT = 'Copyright Alex McBride 2009'

STARTUP_DIR = os.path.dirname(__file__)
CONFIG_PATH = os.path.join(STARTUP_DIR, 'config.dat')
ICONS_DIR = os.path.join(STARTUP_DIR, 'icons')
LFS_EXE_WILDCARD = 'Live for Speed Executable (LFS.exe)|LFS.exe'

ID_EXIT = wx.ID_EXIT
ID_OPTIONS = wx.NewId()
ID_CONNECT = wx.NewId()
ID_DISCONNECT = wx.NewId()
ID_LAUNCH = wx.NewId()
ID_RESTORE = wx.NewId()
ID_ABOUT = wx.ID_ABOUT
ID_EDIT = wx.ID_EDIT
ID_REMOVE = wx.ID_REMOVE

ICON_MAIN = os.path.join(ICONS_DIR, 'icon.ico')
ICON_EXIT = os.path.join(ICONS_DIR, 'exit.png')
ICON_OPTIONS = os.path.join(ICONS_DIR, 'options.png')
ICON_HELP = os.path.join(ICONS_DIR, 'help.png')
ICON_ADD = os.path.join(ICONS_DIR, 'add.png')
ICON_EDIT = os.path.join(ICONS_DIR, 'edit.png')
ICON_REMOVE = os.path.join(ICONS_DIR, 'remove.png')