#
# This file is part of AutoMessage Redux.
# 
# AutoMessage Redux is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License as published by the Free 
# Software Foundation, either version 3 of the License, or (at your option) any 
# later version.
#
# AutoMessage Redux is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
# FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more 
# details.
#
# You should have received a copy of the GNU General Public License along with 
# AutoMessage Redux. If not, see <http://www.gnu.org/licenses/>.
#

"""Contains the program's various dialog boxes."""

# Dependencies.
import wx
import os

# Libraries.
import info
import wxg


class OptionsDialog(wxg.OptionsDialog):
    def __init__(self, *args, **kwds):
        wxg.OptionsDialog.__init__(self, *args, **kwds)
        self.cfg = self.GetParent().cfg
        self.hostTextCtrl.SetValue(self.cfg.host)
        self.portSpinCtrl.SetValue(self.cfg.port)
        self.adminTextCtrl.SetValue(self.cfg.admin)
        self.minimiseCheckbox.SetValue(self.cfg.minimise)
        self.intervalSpinCtrl.SetValue(self.cfg.interval)
        self.lfsExeTextCtrl.SetValue(self.cfg.lfsExePath)
        self.autoConnectCheckBox.SetValue(self.cfg.autoConnect)
        self.lfsExeButton.Bind(wx.EVT_BUTTON, self.onLfsExe)
        self.acceptButton.Bind(wx.EVT_BUTTON, self.onAccept)
        
    def onLfsExe(self, evt):
        dir, file = os.path.split(self.lfsExeTextCtrl.GetValue())
        dlg = wx.FileDialog(self, 'Select LFS.exe', dir, file, info.LFS_EXE_WILDCARD, wx.FD_DEFAULT_STYLE | wx.FD_OPEN)
        if dlg.ShowModal() == wx.ID_OK:
            self.lfsExeTextCtrl.SetValue(dlg.GetPath())
        dlg.Destroy()
        
    def onAccept(self, evt):
        self.cfg.host = str(self.hostTextCtrl.GetValue())
        self.cfg.port = self.portSpinCtrl.GetValue()
        self.cfg.admin = str(self.adminTextCtrl.GetValue())
        self.cfg.minimise = self.minimiseCheckbox.GetValue()
        self.cfg.interval = self.intervalSpinCtrl.GetValue()
        self.cfg.lfsExePath = self.lfsExeTextCtrl.GetValue()
        self.cfg.autoConnect = self.autoConnectCheckBox.GetValue()
        self.EndModal(wx.ID_OK)
        
        
class EditDialog(wxg.EditDialog):
    def __init__(self, *args, **kwds):
        wxg.EditDialog.__init__(self, *args, **kwds)
        self.acceptButton.Bind(wx.EVT_BUTTON, self.onAccept)
        self.acceptButton.SetFocus()
        
    def onAccept(self, evt):
        self.EndModal(wx.ID_OK)
        