/*
List of All variable that can be used in player events

$Nickname          	-> Nickname
$Username          	-> UserName
$Laps 			-> Total number of laps done on the current track and with the current car
$SessLaps 		-> Total number of laps done this session on current track and with the current car
$TotalPitTime     	-> Totaltime used for a pitstop
$Car              	-> Current car of the player
$Posabs           	-> Current absolute position
$Posqual          	-> Current qualification position
$Groupqual        	-> Current group qualification
$SwearWordsRem    	-> Remaining number of swearwords to be used before SwearWordsAction2 is triggered
$H_Mass           	-> User mass required on this server
$H_TRes           	-> User intake restriction required on this server
$P_Mass           	-> Current player Mass
$P_TRes           	-> Current player restriction
$SplitTime        	-> Last Split time done by player

$Split1			-> Last First Split, updated when doing new Split1
$Split2			-> Last First Split, erased when doing Split1
$Split3			-> Last First Split, erased when doing Split1
$LapTime          	-> Current Lap Time, erased when doing New LapTime
$PBLapTime		-> Current PB on current Combo
$diffLapTimeToPB	-> Laptime - PBLTime, Last PBLTime is new realised

$SectorSplit1		-> Last First sector Split, updated when doing new Split1
$SectorSplit2		-> Last second sector Split, erased when doing Split1
$SectorSplit3		-> Last third sector Split, erased when doing Split1
$SectorSplitLast	-> Last Last sector Split, erased when doing Split1

$BestSectorSplit1	-> Best Split duration for the sector 1
$BestSectorSplit2	-> Best Split duration for the sector 2
$BestSectorSplit3	-> Best Split duration for the sector 3
$BestSectorSplitLast	-> BestSplit duration for the last sector

$DiffSectorSplit1	-> $SectorSplit1 - $BestSectorSplit1
$DiffSectorSplit2	-> $SectorSplit2 - $BestSectorSplit2
$DiffSectorSplit3	-> $SectorSplit3 - $BestSectorSplit3
$DiffSectorSplitLast	-> $SectorSplitLast - $BestSectorSplitLast

$isBestSectorSplit1	-> 1 if this sector split is best than previous Best, otherwise 0
$isBestSectorSplit2	-> 1 if this sector split is best than previous Best, otherwise 0
$isBestSectorSplit3	-> 1 if this sector split is best than previous Best, otherwise 0
$isBestSectorSplitLast	-> 1 if this sector split is best than previous Best, otherwise 0

$BestSpeed		-> Best Speed done on this combo by player
$UnitSpeed		-> Speedunit of the current player
$AvgSpeed		-> Avg Speed on last Lap Time
$Tpb			-> Theoretical PB
$DriftScore		-> Drift score
$typ			-> {typ} - = "Sess" if split PB for Session "PB" if split PB for PB file;
$AngleVelocity		-> Last Angle velocity in degrees
$LastDriftScore		-> Last drift score
$AccelerationStartSpeed	-> Starting speed
$AccelerationEndSpeed	-> Ending speed
$AccelerationTime	-> Acceleration time achieved from start to end speed
$MaxAllowedLapTime1	-> Max Allowed Time before trigger Event OnMaxAllowedLapTime1
$MaxAllowedLapTime2	-> Max Allowed Time before trigger Event OnMaxAllowedLapTime2
$Dist			-> Distance done on current combo/track by player
$SessDist		-> Distance done on current combo/track by player this session

$RotateIn		-> Race remain before Rotation


List of all variables that can be used in all events

$HostName		-> Current host Name
$ShortTrackName		-> Track Name in Short format : SO6
$LongTrackName		-> Track Name in long format : South City Chicane
$ShortTime		-> Server Time in short format
$LongTime		-> Server Time in long format
$ShortDate		-> Date in short format
$LongDate		-> Date in long format
$CurrRotateCar 					-> Current rotated Car
$CurrRotateTrack 				-> Current rotated Track
$CurrLongRotateTrack 		-> Current rotated Track
$NextRotateCar 					-> Next rotated Car
$NextRotateTrack 				-> Next rotated Track
$NextLongRotateTrack 		-> Next rotated Track



Additionnal variable that can be used in OnBeginPit.

$Work			-> Work do on current car player after Pit


Additionnal variables that can be used in votation.

$Vote			-> Number of player that have voted to restart, qualify or end
$Players		-> Number of player that can vote ( player on track )
$Remain			-> Number of votes remaining after votation conclude
$Need			-> Number of votes to do action (qualify, restart, end)


Additionnal variables that can be used in OnNotMatchFlags.

$RequiredFlags		-> Flag(s) required on this server
$PlayerFlags		-> Flag(s) for the current player


Additionnal variable that can be used in OnFastDriveOnPitL1 or OnFastDriveOnPitL2.

$RemainFDIP		-> Number of remaining penalties for fast driving in pits


Additionnal variable that can be used in OnAuthReached.

$auth			-> Authorization reached
*/

/*
Command block to run when a LFS Special event is triggered
Event EventId()
...
EndEvent

Command block used by backcall command like button or scheduled action or when received a command by player
Sub SubId()
...
EndSub

Register MsgAction("!test",MA_test);
	You can register a subfunction to call when a player typed a special text
	Firts arg = text typed in
	Second arg = Sub to call when a player typed this text

Register ScheduleAction( "0 0 0 * * *", SA_mid );
	You can register a subfunction to call when a time is reached
	Firts arg = cron format ss mm hh dd MM YYYY
	Second arg = Sub to call when player type this text

Command allowed on Event and Sub

cmdLFS("Command_text");
	Send a command to Lapper, see command.txt in LFS Doc

privMsg( "Message_text");
	Send a private message to the player that has triggered the event

openPrivButton( "help",25,28,150,10,5,-1,0,"^2Commands list" );
openPrivButton( "help",25,28,150,10,5,-1,0,"^2Commands list", backcall );
	Open a button for the current player
	1 - Unique id for this button
	2 - Left coordinate for this button ( 0-200 )
		$origL = (value between 0-200); - when this value is used, every next value can be made relative to this one (example: $origL + 5;)
	3 - Top coordinate for this button ( 0-200 )
		$origT = (value between 0-200); - when this value is used, every next value can be made relative to this one (example: $origT + 5;)
	4 - Width of the button ( 0-200 )
	5 - Heigth of the button ( 0-200 )
	6 - Space between line in multiline button
	7 - Duration in seconds for the button to be displayed (use -1 if you don't want an automatic close)
	8 - Format of the button, look at insim.txt for values
	9 - Button caption, for multiline, separate each line with &
	10 - Option name of the backcalled sub

closePrivButton("welc&pos&clos&ref");
	Close one or more button(s), you specify ID of the button to close, multiple ID's have to be separated by a &

openGlobalButton( "bargr1",60,1,10,6,6,30,96,"Restart:" );
	Same as openPrivButton, but open button for all players connected

closeGlobalButton("welc&pos&clos&ref");
	Same as closePrivButton, but close button for all players connected

console( "My test");
	To display message on the Lapper console

There are another functions, look in config file

Codes that can be used on button format:

0 - transparent button
16 - light button
32 - dark button
64 - align text to left
128 - align text to right

If you want to make a light colored button with text aligned to the left, combine the codes to one new code, for example 16+64 = 80
*/

/*
To create colored text, use the following codes in front of the text you want to color:

^0 - black
^1 - red
^2 - green
^3 - yellow
^4 - blue
^5 - violet
^6 - cyan
^7 - white
^8 - no color

Other variables that could be used on expressions
&&			-> and
||			-> or
+			-> plus
-			-> minus
/			-> devide
*			-> multiply
^			-> pow
==			-> equal to
!=			-> not equal to
>			-> bigger then
<			-> smaller then
<=			-> smaller then and equal to
>=			-> bigger then and equal to
*/

#################
#General options#
#################

$Host = 127.0.0.1; # Host IP. When more network interfaces are present, set it to IP of your host.

$Port = 29999; # Insim UDP port. Open this port after starting LFS Server by typing /insim=29999 in chat or include it in config-file LFS Server

$Password = "yourpass"; # Put in the admin password used on the LFS Server

$TrackInfoFile = "trackInfo.cfg"; # Path to the TrackInfoFile used to compare splits

$TCPmode = true; # Connection to LFS in UDP mode or TCP mode

$EnableRegisterWeb = true; # When set to "true" your LFS Server is displayed on the FRH Team website

$DateFormat = "dd/MM/yyyy";	# Date format used for the PB files
				# Look at C#-format for date/time, little help
				# HH = Hour in 0-23 format
				# hh = Hour in 0-12 format
				# mm = Minute
				# tt = PM or AM
				# dd = Day
				# MM = Month
				# yyyy = year with 4 digits

$TimeFormat = "HH:mm"; # Time format used for the PB files

$MessageTime = 5000; # Time in milliseconds for a racecontrol message (started by: rcm_all) to be displayed on screen

#$PubStatIdk = "";	# Indentification code for a connection to PubStat.
			# To obtain a PubStatId go to www.lfsworld.net , select My LFSW Setting, tab Pubstat Access
			# Remove # before PubStatIdK to activate this option

$ShowPlayerControl = False; # Set option to "true" if you want to show the control configuration of players when leaving the pits.

##############
#FTP transfer#
##############
# Results files can also be transferred to an FTP server
# Define the following parameters to use this feature
# Remove # before line to activate it
# -------------------------------------------------------------------

#$FtpServer = "your ftp server"; # Name/IP-address of your FTP server
#$FtpLogin = "your login"; # Loginname for your FTP server
#$FtpPasswd = "your password"; # Password for your FTP server
#$FtpRemotePath = "your remote dir"; # Directorname

##############################
#Synchronise Lapper databases#
##############################

#$SyncID="frh01";		# Unique ID for this instance of Lapper
#$SyncDir="synchro";		# Name of synchronisation directory. Every Lapper should have this directory name in order to synchronise
#$SyncIDsToSync="frh02|frh03";	# Lapper ID's to synchronise with
				# Seperate ID's with |
				# You can't use current SyncID here

#############
#Default Car#
#############
# Default car to show, when no car is specified in command !top or !drf and when a player haven't used a car on this server
# You can combine several cars by using + (example: "XFG+XRG";)
# -------------------------------------------------------------------

#$DefaultTopCar = "UF1";
$DefaultTopCar = "XFG";
#$DefaultTopCar = "XRG";
#$DefaultTopCar = "XRT";
#$DefaultTopCar = "RB4";
#$DefaultTopCar = "FXO";
#$DefaultTopCar = "LX4";
#$DefaultTopCar = "LX6";
#$DefaultTopCar = "RAC";
#$DefaultTopCar = "FZ5";
#$DefaultTopCar = "MRT";
#$DefaultTopCar = "XFR";
#$DefaultTopCar = "UFR";
#$DefaultTopCar = "FOX";
#$DefaultTopCar = "FO8";
#$DefaultTopCar = "FXR";
#$DefaultTopCar = "XRR";
#$DefaultTopCar = "FZR";
#$DefaultTopCar = "BF1";
#$DefaultTopCar = "FBM";

###################################
#Event triggered when lapper start#
###################################
Event OnLapperStart()
EndEvent

###################################
#Authorization Options ( license )#
###################################
#Authorization Options
#
#$Auth1 $Auth2 ... $Auth10 variable
#Syntax : $AuthX = "Carname:Trackname:MinimumTime&Carname:Trackname:MinimumTime&...| Carname:Trackname:MinimumTime&Carname:Trackname:MinimumTime&... | ...";
#& -> And condition
#| -> Or condition
#
#$AuthAllowPlayer="Auth1|...|AuthX|@username1,username2,...,usernameN";
#or
#$AuthAllowPlayer="All";
#-------------------------------------------------------------------

#$Auth1 = "XFG:BL1:1.30.10 | XRT:SO4:1.20.20";
#$Auth2 = "XFG:BL1:1.10.10 | XRT:SO4:1.20.20";
#$Auth3 = "XFG:BL1:1.05.10";

$AuthAllowPlayer = "All";

$AuthMinPlayer = 0;	# Minimum number of players on the server to auto enable authorization
			# If number of players is below value, alle players are allowed
			# If number of players is above value, only AuthAllowPlayer are allowed

Event OnAuthAllowed()
	cmdLFS( "/msg "  . $Nickname . "^3 allowed on this server" );
Endevent

Event OnAuthNotAllowed()
	cmdLFS("/spec "  . $Nickname . "^3 allowed on this server");
	cmdLFS("/msg " . $Nickname . "^3 not allowed on this server");
Endevent

# Local viariable that can be used
# $auth -> Authorization reached

Event OnAuthReached()
	privMsg("^3You have got level" . $auth );
EndEvent

##################
#Swearword filter#
##################
#Specify a list of swearwords seperated by ,
#Specify a file with swearwords, one word per line
#-------------------------------------------------------------------

$SwearWordsList = "fuck,asholes,bastard,idiot,shit,cunt,arse,motherfucker";
#$SwearWordsList = "&./swear.txt";
$SwearWordsMax = 2; # Maximum number of allowed swearwords per session

Event SwearWordsAction1()
	privMsg( "^1Don't use this words on this server" );
	privMsg( "You will be spectated in ^2" . $SwearWordsRem . " ^1 more attempt(s)" );
EndEvent

Event SwearWordsAction2()
	privMsg( "Too many swearwords, spectated" );
	cmdLFS( "/spec " . $Nickname );
EndEvent

###########
#Handicaps#
###########
#You can specify 3 levels of handicap : for car, for car and track, for user
#Priority Level low to hight : HandicapCars, HandicapCarsTracks, HandicapUser
#-------------------------------------------------------------------
#Handicap cars
#
#Syntax :
#
#$HandicapCars = "car:mass:irest,car:mass:irest,...,car:mass:irest";
#
#car : LFS short car name
#mass : mass handicap in kg
#irest : Air intake restriction in percent
#-------------------------------------------------------------------
#Handicap cars/tracks
#
#Syntax :
#
#$HandicapCarsTracks = "car/track:mass:irest,car/track:mass:irest,...,car/track:mass:irest";
#
#car : LFS short car name
#track : LFS short track name
#mass : mass handicap in kg
#irest : Air intake restriction in percent
#-------------------------------------------------------------------
#$HandicapUser		# a list of players and their handicap
#			# if you prefix with & , You can indicate a file name that contains a list of racers, one racer per line
#			# if you prefix with @, You can list username separated with ,
#
#Syntax :
#
#$HandicapUsers = "&./your_file";
#$HandicapUsers = "@userName:mass:irest,userName:mass:irest,...userName:mass:irest";
#
#$RefreshHandicapUsers	# allow Lapper to refresh HandicapUsers on each player leaving pits
			# Usefull if HandicapUsers is a file and is updated frequently by an external program
#-------------------------------------------------------------------

#$HandicapCars = "XFG:100:10,XRT:50:10";

#$HandicapCarsTracks = "XFG/BL1:100:10,XRT/AS1:50:10";

#$RefreshHandicapUsers = true;
#$HandicapUsers = "&./your_hand.flt";
#$HandicapUsers = "@Gai-Luron:100:20,gwendoline:100:30,_-ALUCARD-_,lagamel:50:10,lister88,c-quad,shimanofr,bruno7529,boby5,kevinb,edgar,berlioz,la tortue,neron59,eur-can,stff,2psbob,oliv76000";

# Actions to execute, when the handicap of a player is below specified HandicapUsers
# Possible variables to use:
#
#$Nickname - Nickname of driver
#$Username - Username of driver
#$H_Mass - User mass required
#$H_TRes - User Intake restriction required

Event OnToLowHandicap()
	cmdLFS("/spec " . $Nickname );
	cmdLFS("/msg " . $Nickname . "^3 spectated for to low handicap" );
	cmdLFS("/msg ^3need " . $H_Mass . "kg and " . $H_TRes . "% of intake restriction!");
EndEvent

#################
#Control Allowed#
#################
# Racer flags
# "Y" = Yes
# "N" = No
# "*"" = Yes or No
# Local variable
# $PlayerFlags = The current Player flags
# $RequiredFlags = The current Required flags
#-------------------------------------------------------------------

$SwapSide = "*";
$AutoGears = "*";
$Shifter = "*";
$HelpBrake = "*";
$AxisClutch = "*";
$AutoClutch = "*";
$Mouse = "*";
$KbNoHelp = "*";
$KbStabilised = "*";
$CustomView = "*";

Event OnNotMatchFlags()
	privMsg( "Flags not match required flags" );
	privMsg("Yours flags -> " . $PlayerFlags );
	privMsg("Required flags -> " . $RequiredFlags );
	privMsg("Spectated" );
	cmdLFS("/spec " . $Username );
EndEvent

##############
#Race Control#
##############
#Voting:
#
#$InRaceLapsVoteMinMax = Laps in between where votes are allowed in race
#$InRaceLapsVoteMinMax = 0-0 Votes are never allowed
#$InRaceLapsVoteMinMax = -5 Votes are allowed between lap 1 and 5
#$InRaceLapsVoteMinMax = 2- Votes are allowed between laps 2 and the end of the race
#$InRaceLapsVoteMinMax = - Votes are always allowed
#
#$VoteRestart = percentage of players that have to vote to restart a race. To let LFS admin this function, set it to -1
#onVoteRestartChange = Command to do when player votes to restart
#onVoteRestartReach = Command to execute when VoteRestart is reached
#onVoteRestartZero = Command to execute when no nb of player reach zero

#$VoteQualify = percentage of players that have to vote to start a qualification. To let LFS admin this function, set it to -1
#onVoteQualifyChange = same as restart but for qualify
#onVoteQualifyReach = same as restart but for qualify
#onVoteQualifyZero = same as restart but for qualify
#
#$VoteEnd = percentage of players that have to vote to end a race. To let LFS admin this function, set it to -1
#onVoteEndChange = same as restart but for endrace
#onVoteEndReach = same as restart but for endrace
#onVoteEndyZero = same as restart but for endrace
#-------------------------------------------------------------------
#Local variable:
#
#$Vote - Number of players that have voted
#$Remain - Number of players remaining to vote
#$Need - Number of players needed for an action
#$VoteLifeSec = Number of seconds to keep the vote alive after voting
#-------------------------------------------------------------------
#Auto restart:
#
#$AutoRestartRaceMn = Minutes between the end of a race (last player finished) and an automatic restart
#$AutoRestartRaceMn = 0; No restart
#
#Rotation only work if AutoRestartRaceMn is set
#EnableRotation =	Allow or disallow rotation for track and/or car
#			Values : true or false
#$RotateTracks = "tracks to rotate"; separated by ','
#$RotateCars = "cars to rotate"; separated by ',' Use LFS definition for car, if not set, no car rotation
#$RotateEveryNbRaces = Number of races to do before rotation;
#-------------------------------------------------------------------

$InRaceLapsVoteMinMax = "-";

$VoteRestart = -1;

Event onVoteRestartChange()
	openGlobalButton( "bargr1",60,1,10,6,6,30,96,"Restart:" );
	openGlobalButton( "bargr2",70,1,20,6,6,30,96,"(" . $Vote ."/" . $Players . ") Need " . $Need );
EndEvent

Event onVoteRestartReach()
	closeGlobalButton( "bargr1&bargr2" );
	cmdLFS("/restart");
EndEvent

Event onVoteRestartZero()
	closeGlobalButton( "bargr1&bargr2" );
EndEvent

$VoteQualify = -1;

Event onVoteQualifyChange()
	openGlobalButton( "bargq1",90,1,10,6,6,30,96,"Qualify" );
	openGlobalButton( "bargq2",100,1,20,6,6,30,96,"(" . $Vote . "/" . $Players . ") Need " . $Need );
EndEvent

Event onVoteQualifyReach()
	closeGlobalButton("bargq1&bargq2" );
	cmdLFS("/qualify" );
EndEvent

Event onVoteQualifyZero()
	closeGlobalButton("bargq1&bargq2" );
EndEvent

$VoteEnd = -1;

Event onVoteEndChange()
	openGlobalButton( "barge1",120,1,10,6,6,30,96,"End:" );
	openGlobalButton( "barge2",130,1,20,6,6,30,96,"(" . $Vote . "/" . $Players . ") Need " . $Need );
EndEvent
Event onVoteEndReach()
 	closeGlobalButton( "barge1&barge2" );
	cmdLFS("/end");
EndEvent

Event onVoteEndZero()
 	closeGlobalButton( "barge1&barge2" );
EndEvent

$VoteLifeSec = 30;

$AutoRestartRaceMn = 0;

$EnableRotation = 	false;
$RotateTracks = "SO6R,BL1,FE3";
$RotateEveryNbRaces = 4;
$RotateCars = "XFG+UF1,TBO,XFR+UFR";

Event OnRotateCar()
 	cmdLFS("/msg Car changed, go to pit! Current car = " . $CurrRotateCar);
EndEvent
Event OnRotateTrack()
 	cmdLFS("/msg Track changed, please wait!" );
	cmdLFS("/msg Current Track = " . $CurrLongRotateTrack);
EndEvent


#################################################
#Connect messages when a player joins the server#
#################################################

Event OnConnect()
	openPrivButton( "welc",25,50,150,15,12,-1,0,"^7Welcome " .  $Nickname . " ^7to ^1LFSLapper ^7powered server !&^2Type ^7!help ^2after leaving garage to see commands." );
	openPrivButton( "pos",25,80,150,10,8,-1,0,"^7Your actual friendly Position (all visitors) : ^7" . $Posabs
		. "&^2Your actual League prequalify Position : " . $Posqual . " ^6Estimate Pool : " . $Groupqual
		. "&Don't use swearwords on this server"
		. "&respect other player"
		. "&otherwise you can be banned "
	);
	openPrivButton( "clos",78,120,20,10,10,-1,32,"Accept",OnConnectClose );
	openPrivButton( "ref",103,120,20,10,10,-1,32,"Deny",OnConnectCloseKick );
	http("http://www.frh-team.net/reglapper/getserver2.php" );
EndEvent

Sub OnConnectClose()
	closePrivButton("welc&pos&clos&ref");

	IF( $Nickname == "unnamed" )
	THEN
		cmdLFS( "/kick " . $Username );
	ENDIF

openGlobalButton( "sinrs_dm_logo",5,98,36,6,4,-1,16,"^1Put your name/team name in this space" ); # Put your name/teamname or server or anything else you want in between the quotes - this text (^1) will be in red (see attached text file if you want to learn how to change the text colour)
openGlobalButton( "sinrs_dm_track",5,113,36,5,5,-1,16,"^3Track: ^2" . $LongTrackName . " ^1[" . $ShortTrackName . "]" );
openGlobalButton( "sinrs_dm_caranddriver",5,118,36,5,8,-1,16,"^6Car: ^2". $Car . "^7 - ^6Driver: " .  $Nickname . );
openGlobalButton( "sinrs_dm_criteria",5,146,36,4,4,-1,16,"^4Scoring Criteria: "
					. "&^7Minimum Drift Speed: ^330MPH / 48kph"
					. "&^7Drift Angles (degrees): ^215^3 min / ^1100 ^3max");
openGlobalButton( "sinrs_dm_back",4,97,38,48,4,-1,32," " ); # Blank backing
openGlobalButton( "sinrs_dm_text",5,105,36,8,4,-1,16,"^0DRIFT MASTER ^1(c)Sin'rs" ); # 'DRIFT MASTER is in Black text
openGlobalButton( "sinrs_dm_driftblank",5,124,36,6,4,-1,80,"This Drift Score: " );
openGlobalButton( "sinrs_dm_comboblank",5,131,36,6,4,-1,80,"Total Combo Score: " );
openGlobalButton( "sinrs_dm_angleblank",5,138,36,6,4,-1,80,"Drift Angle: " );
openPrivButton( "sinrs_dm_score",30,124,11,6,4,-1,128,"- - - " ); # Blank.  Score will overlay once you start scoring drift points
openPrivButton( "sinrs_dm_combo",30,131,11,6,4,-1,128,"- - - " ); # Blank
openPrivButton( "sinrs_dm_angle",30,138,11,6,4,-1,128,"> - < " ); # Blank
openGlobalButton( "sinrs_dm_criteriablank",4,145,38,14,3,-1,32," " );


EndSub

Sub OnConnectCloseKick()
	closePrivButton("welc&pos&clos&ref");
	cmdLFS("/kick " . $Username );
EndSub

#####################################################
#DisConnect messages when a player leaves the server#
#####################################################

Event OnDisConnect()
	cmdLFS( "/msg " . $Nickname . " left the server" );
EndEvent

#############################################$#
#Splitting (general action when passing split)#
###############################################

Event OnSplit1()
EndEvent

Event OnSplit2()
EndEvent

Event OnSplit3()
EndEvent

Event OnLap()
/*
	IF( $DiffLapTimeToPB >= 0 )
	THEN
	  $color = "^1";
	  $diff = $DiffLapTimeToPB;
	ELSE
	  $color = "^2";
	  $diff = - $DiffLapTimeToPB;
	ENDIF

	privMsg( "New lap " .$color . $LapTime . "(" . $diff . ")" );
*/
EndEvent

#######################################################
#Splitting (compare player split to best player split)#
#######################################################

$ShowSplitPB = true; # Set to false if you don't want to see messages about splits

Event OnSpbSplit1()
	IF( $isBestSectorSplit1 == 1 )
	THEN
	  $color = "^2";
	ELSE
	  $color = "^1";
	ENDIF
	openPrivButton( "id_spb",50,55,100,10,10,5,0,$typ
		. " ^7SP1"
		. ": " . $SectorSplit1 . " "
		. $color
		. "(" . $DiffSectorSplit1 . ")"
		. "&^7TPB:" . $Tpb);
EndEvent

Event OnSpbSplit2()
	IF( $isBestSectorSplit2  == 1 )
	THEN
	  $color = "^2";
	ELSE
	  $color = "^1";
	ENDIF
	openPrivButton( "id_spb",50,55,100,10,10,5,0,$typ
		. " ^7SP2"
		. ": " . $SectorSplit2 . " "
		. $color
		. "(" . $DiffSectorSplit2 . ")"
		. "&^7TPB:" . $Tpb);
EndEvent

Event OnSpbSplit3()
	IF( $isBestSectorSplit3  == 1 )
	THEN
	  $color = "^2";
	ELSE
	  $color = "^1";
	ENDIF
	openPrivButton( "id_spb",50,55,100,10,10,5,0,$typ
		. " ^7SP3"
		. ": " . $SectorSplit3 . " "
		. $color
		. "(" . $DiffSectorSplit3 . ")"
		. "&^7TPB:" . $Tpb);
EndEvent

Event OnSpbLast()
	IF( $isBestSectorSplitLast  == 1 )
	THEN
	  $color = "^2";
	ELSE
	  $color = "^1";
	ENDIF
	openPrivButton( "id_spb",50,55,100,10,10,5,0,$typ
		. " ^7SPL: "
		. $SectorSplitLast . " "
		. $color
		. "(" . $DiffSectorSplitLast
		. ")&^7TPB:" . $Tpb . " Avg:" . $AvgSpeed . " " . $UnitSpeed );
EndEvent

####################################################
#Actions to do on splits relative to trackinfo.cfg#
####################################################
#Local variable: {SplitTime} - Split time
#-------------------------------------------------------------------

Sub TRI_split1_0()
	cmdLFS( "/msg Great 1st split (" . $SplitTime . ") by " . $Nickname . "^8!" );
EndSub
Sub TRI_split1_1()
	cmdLFS( "/msg Good 1st split (" . $SplitTime . ") by " . $Nickname . "^8!" );
EndSub
Sub TRI_split2_0()
	cmdLFS( "/msg Great 2nd split (" . $SplitTime . ") by " . $Nickname . "^8!" );
EndSub
Sub TRI_split2_1()
	cmdLFS( "/msg Good 2nd split (" . $SplitTime . ") by " . $Nickname . "^8!" );
EndSub
Sub TRI_split3_0()
	cmdLFS( "/msg Great 3rd split (" . $SplitTime . ") by " . $Nickname . "^8!" );
EndSub
Sub TRI_split3_1()
	cmdLFS( "/msg Good 3rd split (" . $SplitTime . ") by " . $Nickname . "^8!" );
EndSub
Sub TRI_lap_0()
	cmdLFS( "/msg Great lap (" . $LapTime . ") by " . $Nickname . "^8!" );
EndSub
Sub TRI_lap_1()
	cmdLFS( "/msg Great lap (" . $LapTime . ") by " . $Nickname . "^8!" );
EndSub

#########################
#List of user qualifying#
#########################
#RefreshQualUsers : allow Lapper to refresh QualUsers on each outgoing pits, Usefull if QualUsers is a file and this is changed frequently by an external program
#QualUser : is a list of racers that participed in the qualification, required for function !nearqual !topqual and !statsqual
#if you prefix with & , You can indicate a file name that contains a list of racers, one racer per line (example : QualUsers = ./userfile.txt;)
#if you prefix with @, You can list usernames separated with ',' (example : QualUsers = @Gai-Luron,gwendoline,_-ALUCARD-_,lagamel;)
#You can specify which car is used by a user adding car after username separated by ':' (example : Gai-Luron:XFR,lagamel:UFR)
#You can specify the scheme of group of this qualification using a special username called DefGroup
#Defgroup Take 3 argument separated with ':'
#1 - Is the number Max of Group for this qualification
#2 - Is the number max of user per group
#3 - Is the minimum of user in the last group, recalc previous group as possible if number is low
#If you ommit scheme of groups, the group of qualification do not appear
#-------------------------------------------------------------------

$RefreshQualUsers = true;
#$QualUsers = "&./your_file.flt";
$QualUsers = "@DefGroup:5:5:2,Gai-Luron,MataGyula,nesrulz,gwendoline,_-ALUCARD-_,lagamel,lister88,c-quad,shimanofr,bruno7529,boby5,kevinb,edgar,berlioz,la tortue,neron59,eur-can,stff,2psbob,oliv76000";

###################
#Scheduled actions#
###################
#Syntax: ss mm hh dd MM YYYY
#-------------------------------------------------------------------

Register ScheduleAction( "0 0 0 * * *", SA_mid );
Sub SA_mid()
	cmdLFS("/rcm Midnight warning to all working men!");
	cmdLFS("/rcm_all");
EndSub

Register ScheduleAction( "0 0 0 1 1 *", SA_newyear );
Sub SA_newyear()
	cmdLFS("/rcm Happy New Year!");
	cmdLFS("/rcm_all");
EndSub

#################
#Command actions#
#################
#$allow is optional if you wish to specify users, that are allowed to execute action
#You can specify more users if you separated them by ','
#You can use a file to specify users, one user per line (example : $allow = "&./your_file.flt";)
#If ! before a name, force nickName authentification if UseUsernameForAuthentication=true
#If ! before a name, force userName authentification if UseUsernameForAuthentication=false
#You can use regexp expression in userName pattern, type regex=your regular expression
#
#Example:	if UseUsernameForAuthentication=true
#		!regex=^\[COP\].*
#		Find all user with a nickname that begins with [COP]
#		regex=^Gai.*
#		Find all user with a username that begins with Gai
# 		See regular expression on web for more info how it work
#
#Use & sign at end of patterns
#-------------------------------------------------------------------

$UseUsernameForAuthentication = true;

Register MsgAction("!test",MA_test);
Sub MA_test()
	$allow = "Gai-Luron,lagamel";
	cmdLFS("/rcm " . $Nickname . " is testing...");
	cmdLFS("/rcm_ply " . $Nickname );
EndSub

Register MsgAction("!license",MA_license);
Sub MA_license()
	$allow = "Gai-Luron,lagamel";
	setLicense( $argv );
EndSub

Register MsgAction("!ban",MA_ban);
Sub MA_ban()
	$allow = "Gai-Luron";
	cmdLFS( "/ban " . $argv . " 1" );
EndSub

Register MsgAction("!kick",MA_kick);
Sub MA_kick()
	$allow = "Gai-Luron";
	cmdLFS( "/kick " . $argv );
EndSub

Register MsgAction("!powered",MA_powered);
Sub MA_powered()
	http("http://www.frh-team.net/reglapper/getserver2.php");
EndSub

Register MsgAction("!pos",MA_pos);
Sub MA_pos()
	privMsg( "Your friendly position is " . $Posabs );
EndSub

Register MsgAction("!posqual",MA_posqual);
Sub MA_posqual()
	privMsg( "Your qualification position is " . $Posqual );
EndSub

Register MsgAction("!groupqual",MA_groupqual);
Sub MA_groupqual()
	privMsg( "Your groupqual is " . $Groupqual );
EndSub

Register MsgAction("!ver",MA_ver);
Sub MA_ver()
	http("http://www.frh-team.net/reglapper/getserver2.php");
	lapperVersion();
EndSub

Register MsgAction("!auth",MA_auth);
Sub MA_auth()
	authLevel();
EndSub

Register MsgAction("!cleanspb",MA_cleanspb);
Register MsgAction("!razspb",MA_cleanspb);
Sub MA_cleanspb()
	cleanSpb();
EndSub

Register MsgAction("!spb",MA_spb);
Sub MA_spb()
	showSpb();
EndSub

Register MsgAction("!hand",MA_hand);
Sub MA_hand()
	showHand( $argv );
EndSub

Register MsgAction("!statsqual",MA_statsqual);
Sub MA_statsqual()
	statsQual( $argv );
EndSub

Register MsgAction("!dstats",MA_dstats);
Sub MA_dstats()
	dStats( $argv );
EndSub

Register MsgAction("!stats",MA_stats);
Sub MA_stats()
	stats( $argv );
EndSub

Register MsgAction("!nearqual",MA_nearqual);
Sub MA_nearqual()
	nearQual( $argv );
EndSub

Register MsgAction("!near",MA_near);
Sub MA_near()
	near( $argv );
EndSub

Register MsgAction("!topqual",MA_topqual);
Sub MA_topqual()
	topQual( $argv );
EndSub

Register MsgAction("!top",MA_top);
Sub MA_top()
	top( $argv );
EndSub

Register MsgAction("!drf",MA_drf);
Sub MA_drf()
	drf( $argv );
EndSub

Register MsgAction("!distance",MA_distance);
Sub MA_distance()
	privMsg("Distance done on " . $Car . "/" . $ShortTrackName . " = " . $Dist . ", session = " . $SessDist );
EndSub

Register MsgAction("!laps",MA_laps);
Sub MA_laps()
	privMsg( "Laps done on " . $Car . "/" . $ShortTrackName ." = " . $Laps . ", session = " . $SessLaps );
EndSub

Register MsgAction("!pit",MA_pit);
Sub MA_pit()
	privMsg( "Time in pitting " . $TotalPitTime );
EndSub

Register MsgAction("!track",MA_track);
Sub MA_track()
	privMsg( "Track in use :" . $ShortTrackName . " = " . $LongTrackName );
EndSub

Register MsgAction("!time",MA_time);
Sub MA_time()
	privMsg( "Server time clock reference : " . $LongTime );
EndSub

Register MsgAction("!help",MA_help);
Sub MA_help()
	openPrivButton( "help",25,28,150,10,5,-1,0,"^2Commands list" );
	openPrivButton( "help2",25,38,150,6,5,-1,96,"^2General commands"
		. "&^3!top ^8[table offset] [3-letter car name] ['filter' pattern]"
		. "&^3!drf ^8[table offset] [3-letter car name] ['filter' pattern]"
		. "&^3!stats ^8[playername pattern]"
		. "&^3!dstats ^8[playername pattern]"
		. "&^3!near ^8Gap with 14 pilots near you on the ranking"
		. "&^3!spb ^8Split times and TPB (Theoretical PB)"
		. "&^3!razspb ^8Start new spb session (eg when changing car)"
		. "&^3!track ^8Name of actual track"
		. "&^3!time ^8Server time (to leagues mettings)"
		. "&^3!ver ^8Version of LFSLapper"
		. "&"
		. "&^2Special league commands"
		. "&^3!topqual ^8Rank to pilots specified on *.flt file"
		. "&^3!statsqual ^8Actual Position on prequalify session"
		. "&"
		. "&^2New functions"
		. "&^3!laps ^8Total laps number + session laps number"
		. "&^3!hand ^8Handicap by pilot ordered by league-host admin"
		. "&^3!pit ^8Total pit stop time"
		. "&^3Shft+i ^8Configure your display messages" );
	openPrivButton( "close",90,145,20,10,8,-1,32,Ok,MA_closeHelp );
EndSub

Sub MA_closeHelp()
	closePrivButton("help&help2&close");
EndSub

#####################################
#Action on teleport to pit (Shift+P)#
#####################################

/*
Event EnterPitAction()
 	privMsg( $Nickname . "^8 teleported to pits!" );
EndEvent
*/

# Actions to execute when player spectates or disconnects (leaves race).

/*
Event LeaveRaceAction()
	privMsg( $Nickname . "^8 left the race!";
EndEvent
*/

###############################
#Action a player flooding chat#
###############################

Event FloodAction()
	privMsg( $Nickname . "^3 kicked for flooding" );
	cmdLFS( "/kick " . $Username );
EndEvent

$MaxFloodLines = 4; # Maximum number of consecutive lines allowed

$MaxFloodLinesTime = 5000; # Maximum time between two consecutive lines in milliseconds to count as flooding

######################
#Action on race start#
######################

Event RaceStartAction()
	cmdLFS( "/rcm ^3Please, brake in time!" );
	cmdLFS( "/rcm_all" );
EndEvent

#########################
#Action to do on session#
#########################

/*
$MaxSessionLaps = 2;

Event OnMaxSessionLaps()
	privMsg( "Max session laps reacheds" );
EndEvent
*/

###############################
#Options on spinning detection#
###############################

$MinAngleVelocity = 250; # Minimum angle velocity to trigger action. Possible values: 0 - 720

# Action to execute when angle velocity is higher than MinAngleVelocity.

/*
Event
	cmdLFS( "/spec " . $Nickname );
	cmdLFS( "/msg " . $Nickname . " ^3 removed from track for wrecking" );
EndEvent
*/

Event AngleVelocityAction()
	cmdLFS( "/msg ^1Danger! ^8" . $Nickname . " ^2lost control!" );
EndEvent

$MaxNbInStunt = 20; #MaxNbInStunt is max time (in 100 ms) allowed in stunt mode before MaxNbInStuntAction is executed. If -1 No MaxNbInStuntAction are activated

Event MaxNbInStuntAction()
	cmdLFS( "/spec " . $Nickname );
EndEvent

#################################
#Actions when player is too slow#
#################################

#$MaxAllowedLapTime1 = 100; # % Max allowed time to complete a lap relative to MaxLapTime in trackInfo.cfg

/*
Event OnMaxAllowedLapTime1()
	privMsg( "you are too slow! Max : " . $MaxAllowedLapTime1 );
	privMsg( "kick on " . $MaxAllowedLapTime2 );
EndEvent
*/

#$MaxAllowedLapTime2 = 150; # % Max allowed time to complete a lap relative to MaxLapTime in trackInfo.cfg

/*
Event OnMaxAllowedLapTime2()
	privMsg( "You are very slow, spectated!" );
	cmdLFS( "/msg " . $Nickname . " is too slow, spectated!" );
	cmdLFS( "/spec " . $Username );
EndEvent
*/

##################################
#Options for idle player on track#
##################################

#$IdleExclude = "Lagamel,Gai-Luron"; # Usernames excluded for idle check

$OnIdleTimeout1 = 20; # Idle timeout for OnIdleAction1 in seconds

Event OnIdleAction1()
	privMsg( "^3You are idle and will be spectated in 10 seconds" );
EndEvent

$OnIdleTimeout2 = 30; # Idle timeout for OnIdleAction2 in seconds

Event OnIdleAction2()
	cmdLFS( "/spec " . $Nickname );
	privMsg( "^3You are spectated for non-activity" );
EndEvent

#================#
#Drifting options          #
#================#

$DriftDatabase = "./DriftPB.txt"; # This is the filepath for a file containing the collected data.


$MinimumDriftSpeed = 48; # Minimum speed in km/h to maintain. Driving below that speed will reset score (48kmph is approx 30MPH)
$MinimumDriftAngle = 15; # Minimum angel to maintain. When angle is below value, score is reset
$MaximumDriftAngle = 100; # Maximum angel to maintain. When angle is above value, score is reset
$GoodDriftScore = 2000; # Value to be reached to execute action on good drift score
$MinimumDriftScore = 250; # Minimum drift score required

Event OnDriftScore()

      IF( $AngleVelocity < 0 )

  	THEN
     		$AngleVelocity_reverse=($AngleVelocity)*(-1);

     		openPrivButton( "sinrs_dm_score",30,124,11,6,4,-1,128," ^7" . $LastDriftScore ); # Gray text with white score
     		openPrivButton( "sinrs_dm_combo",30,131,11,6,4,-1,128," ^2" . $DriftScore ); # Gray text with green score
     		openPrivButton( "sinrs_dm_angle",30,138,11,6,4,-1,128," ^7" . $AngleVelocity_reverse . "^2 =>" ); # Gray text with white score and green arrow

 	 ELSE

     		openPrivButton( "sinrs_dm_score",30,124,11,6,4,-1,128," ^7" . $LastDriftScore ); # Gray text with white score
     		openPrivButton( "sinrs_dm_combo",30,131,11,6,4,-1,128," ^3" . $DriftScore ); # Gray text with yellow score
     		openPrivButton( "sinrs_dm_angle",30,138,11,6,4,-1,128," ^1<= ^7" . $AngleVelocity . " " ); # Gray text with white score and red arrow
       ENDIF

EndEvent



# Message that will be shown to all on a drivers new personal best drift lap.
Event DriftPBAction()
	cmdLFS( "/rcm " . $Nickname . "^3 made new drift PB: ^7" . $DriftScore . " ^3pts!" );
	cmdLFS( "/rcm_all" );
EndEvent


# Message that will be shown when total lap drift score is higher or equal to MinimumDriftScore.
Event DriftLapAction()
	cmdLFS("/msg " . $Nickname . " ^3drifted to ^7" . $DriftScore . " ^3pts" );
EndEvent


# Message that will be shown to all when driver makes a good drift score
Event GoodDriftAction()
	cmdLFS( "/rcm " . $Nickname . " ^3made excellent drift: ^7" . $LastDriftScore ." ^3pts" );
	cmdLFS( "/rcm_all" );

EndEvent


# Message that will be shown to all if a driver fails to score a minimum amount
Event DriftTooLowAction()
	cmdLFS( "/rcm " . $Nickname . " ^3was absolutely rubbish!" );
	cmdLFS( "/rcm_all" );
EndEvent

################################
#Options for hotlapping options#
################################

$Database = "./PB.txt";	# This is the filepath of a file containing the collected data
			# This file will be created if it doesnt exist yet
			# You must ensure read/write access to this path

# Action to do on new personal best lap.
# PBQualAction for the racer who make qualif ( in QualUser )
# PBAction the other racer

/*
Event PBAction()
	cmdLFS( "New PB by " . $Nickname . "^8 (" . $Car . "): " . $LapTime;
EndEvent
*/

Event PBAction()
	cmdLFS("/msg New PB by " . $Nickname . "^8 (" . $Car . "): " . $LapTime );
	cmdLFS("/msg Friendly rank : " . $Posabs );
	cmdLFS("/msg Session laps done = " . $SessLaps );
	cmdLFS("/msg Total laps done (server) = " . $Laps );
	cmdLFS("/msg Average speed: " . $AvgSpeed . " " . $UnitSpeed );
	cmdLFS("/rcm Friendly " . $Car . " rank: ^7" .  $Posabs );
	cmdLFS("/rcm_ply " . $Username );
EndEvent

Event PBQualAction()
	cmdLFS("/msg League - New QT by " . $Nickname . "^8:" . $LapTime );
	cmdLFS("/msg Friendly rank (all visitors): ^7" . $Posabs );
	cmdLFS("/msg ^2Qualify pos.: " . $Posqual );
	cmdLFS("/msg ^6Actual Pool: " . $Groupqual );
	cmdLFS("/msg Average speed: " . $AvgSpeed . " " . $UnitSpeed );
	cmdLFS("/rcm " . $Nickname . " ^2Pos:" . $Posqual . " - Pool:" . $Groupqual );
	cmdLFS("/rcm_All");
EndEvent

##########################
#Options for acceleration#
##########################

$AccelerationStartSpeed = 1; # At which speed to start measuring time. In km/h
$AccelerationEndSpeed = 100; # At which speed to stop measuring time. In km/h

$AccelerationStartSpeedMph = 1; # At which speed to start measuring time. In Mph
$AccelerationEndSpeedMph = 60; # At which speed to stop measuring time. In Mph

$AccelerationPrivateMaxTime = 10; # Maximum acceleration time in seconds to show message

#Message to show to players.
#Possible variables to use:
#{AccelerationStartSpeed} - Starting speed
#{AccelerationEndSpeed} - Ending speed
#{AccelerationTime} - Acceleration time achieved from start to end speed
#{UnitSpeed} Unit of the Speed of the player connected

Event OnAcceleration()
	privMsg( "^8Accelerated in ^3" . $AccelerationTime . "^8 seconds to " . $AccelerationEndSpeed . " " . $UnitSpeed ."!" );
EndEvent

######################
#Actions for pit stop#
######################
#Local variable tou can use
#$Work - Work on pit (only for OnBeginPit)
#-------------------------------------------------------------------

Event OnBeginPit()
	cmdLFS( "/msg " . $Nickname . "^8 makes a pit stop" );
	privMsg( "Pit begin! Work:" . $Work );
EndEvent

Event OnEndPit()
	cmdLFS( "/msg " . $Nickname . "^8 left pits in " . $PitTime );
	privMsg( "Pit stop finished in " . $PitTime ." - Total Pit: " . $TotalPitTime );
EndEvent

######################
#Actions on penalties#
######################
#Possible variables to use:
#
#OnFastDriveOnPitL1 = Actions on 30 Sec Penalty or drive-through
#OnFastDriveOnPitL2 = Actions on 45 Sec Penalty or Stop&Go
#MaxFastDriveOnPit = Max Fast Drive on Pit allowed per race
#OnMaxFastDriveOnPit = Actions on Max Fast Drive on Pit allowed
#OnFalseStartL1 = 30 Sec Penalty or drive-through
#OnFalseStartL2 = 45 Sec Penalty or Stop&Go
#
#Local Variable can be used:
#
#{RemainFDIP} = Remain count for fast drive in pit
#-------------------------------------------------------------------

Event OnFastDriveOnPitL1()
	cmdLFS( "/msg " . $Nickname . "^1 Warning for fast driving in pit" );
	privMsg( "^1WARNING-KICK POSSIBLE" );
EndEvent

Event OnFastDriveOnPitL2()
	cmdLFS( "/msg " . $Nickname . "^1 Spectated for fast driving in pit" );
	privMsg( "^1KICK IN " . $RemainFDIP . " TRY" );
	cmdLFS( "/spec " . $Username );
EndEvent

Event OnMaxFastDriveOnPit()
	cmdLFS( "/msg " . $Nickname . "^1 kicked for fast driving in pit" );
	cmdLFS( "/rcm ^1YOU ARE KICKED" );
	cmdLFS( "/rcm_ply " . $Username );
	cmdLFS( "/kick " . $Username );
EndEvent
$MaxFastDriveOnPit = 2;

Event OnFalseStartL1()
EndEvent

Event OnFalseStartL2()
EndEvent

####################
#Overriding options#
####################
