<?php
/*
** @package   Internet Message Access Protocol (IMAP) Class
** @since     2008-06-21 04:30
** @author    Mark 'Dygear' Tomlin
** @license   MIT License (http://opensource.org/licenses/mit-license.php)
** @copyright Copyright (C) 2008, Mark 'Dygear' Tomlin
** @version   0.1.0
** @phpver    5.2.0
*/

if (($IMAP = new IMAP('{imap.gmail.com:993/imap/ssl}', 'Username@gmail.com', 'Password')) === FALSE) {
	trigger_error('Unable to Start new IMAP session!');
	die();
}

class IMAP {
	function __construct($mbox, $user, $pass, $opt = 1, $retrys = 3) {
		if (($this->self = imap_open($this->utf7_encode($mbox), $user, $pass, $opt, $retrys)) === FALSE) {
			trigger_error($this->last_error());
			return FALSE;
		} else {
			return TRUE;
		}
	}
	function check() {
		return imap_check($this->self);
	}
	function header($msg_number, $fromlength = 1024, $subjectlength = 1024, $defaulthost = '') {
		return imap_headerInfo($this->self, $msg_number, $fromlength, $subjectlength, $defaulthost);
	}
	function headers() {
		return imap_headers($this->self);
	}
	function body($msg_number, $options = FT_PEEK) {
		return imap_body($this->self, $msg_number, $options);
	}
	function utf7_encode($string) {
		return imap_utf7_encode($string);
	}
	function __destruct() {
		imap_close($this->self);
	}
}

?>