<?php

/*
** @package   cURL Class
** @since     2009-01-25 21:30
** @author    Mark 'Dygear' Tomlin
** @license   MIT License (http://opensource.org/licenses/mit-license.php)
** @copyright Copyright (C) 2008, Mark 'Dygear' Tomlin
** @version   0.6.0
*/

if (($cURL = new cURL()) === FALSE) {
	trigger_error('Unable to Start new cURL session!');
	die();
}

class cURL {
	# Initialize a cURL session
	function __construct($url = NULL) {
		if (!extension_loaded('curl') && (!dl('php_curl.dll') || !dl('curl.so'))) {
			trigger_error('cURL: Extension Not Loaded!');
			return FALSE;
		}
		if (!function_exists('curl_setopt')) {
			trigger_error('cURL: Functions Not Loaded!');
			return FALSE;
		}
		$this->self = curl_init($url);
	}
	# Copy a cURL handle along with all of its preferences
	function copyHandle() {
		return curl_copy_handle($this->self);
	}
	# Return the last error number
	function errno() {
		return curl_errno($this->self);
	}
	# Return a string containing the last error for the current session
	function error() {
		return curl_error($this->self);
	}
	# Perform a cURL session
	function exec() {
		return curl_exec($this->self);
	}
	# Get information regarding a specific transfer
	function getInfo($opt = NULL) {
		return curl_getinfo($this->self, $opt);
	}
	# Set an option for a cURL transfer
	function setOpt($option, $value) {
		return curl_setopt($this->self, $option, $value);
	}
	# Set multiple options for a cURL transfer
	function setOptArray($options) {
		if (!function_exists('curl_setopt_array')) {
			function curl_setopt_array(&$ch, $curl_options) {
				foreach ($curl_options as $option => $value) {
					if (!$this->setOpt($ch, $option, $value)) {
						return FALSE;
					}
				}
				return TRUE;
			}
		}
		return curl_setopt_array($this->self, $options);
	}
	# Get version Number 
	function version($age = NULL) {
		return curl_version($age);
	}
	# Close a cURL session
	function __destruct() {
		if (isset($this->self)) {
			return curl_close($this->self);
		}
	}
}

?>