function across(x1,y1,x2,y2,xa,ya)
	local ymax,ymin
	if (y1 < y2) then
		ymax = y2
		ymin = y1
	else
		ymax = y1
		ymin = y2
	end

	local y = (xa-x1)*(y2-y1)/(x2-x1) + y1
	
	if ((xa == x1) and (ya == y1)) or ((xa == x2) and (ya == y2)) then
		return 2
	elseif ((x1 == x2) and (xa == x1) and (ya >= ymin) and (ya <= ymax)) then
		return 2
	elseif ((x1 < x2) and (xa >= x1) and (xa <= x2)) or ((x1 > x2) and (xa <= x1) and (xa >= x2)) then

		if (ya >= y) and (ymin <= y) then
			return 1
		end
	end
	return 0
end

function in_area(points,x,y)
	local trig = 0
	local temp

	for i=2,#points/2 do
		temp = across(points[i*2-3],points[i*2-2],points[i*2-1],points[i*2-0],x,y)
		if (temp == 2) then
			return true
		elseif (temp == 1) then
			trig = 1 - trig
		end
	end
	temp = across(points[#points-1],points[#points-0],points[1],points[2],x,y)
	if (temp == 2) then
		return true
	elseif (temp == 1) then
		trig = 1 - trig
	end
	if (trig == 1) then return true else return false end
end

function info(imsg, pause)
	luaLFS:small(0, SMALL_NLI, 0)
--	for i = 1, 15, 1 do
--		luaLFS:btn(8, 255, 8, 0, 32, 0, 0, 100, 200, i, imsg) 
--		luaLFS.sleep(0.02)
--	end
	luaLFS:mst(imsg)
	luaLFS:btn(8, 255, 8, 0, 32, 0, 0, 100, 200, 15, imsg) 
	luaLFS.sleep(pause)
--	for i = 15, 1, -1 do
--		luaLFS:btn(8, 255, 8, 0, 32, 0, 0, 100, 200, i, imsg) 
--		luaLFS.sleep(0.02)
--	end
	luaLFS:bfn(0, 255, 8, 0)
	luaLFS:small(0, SMALL_NLI, 50)
end

function draw_traffic_light(s1, s2, s3, s4)
	local l = 172 -- left
	local t = 15   -- top
	local w = 18 -- 
	local h = 17  -- 

	luaLFS:btn(1, 255, 1, 0, 0, 0, l, t, w, h, s1.." "..s1.." "..s1)
	t = t + 6
	luaLFS:btn(2, 255, 2, 0, 0, 0, l, t, w, h, s2.." "..s2.." "..s2)
	t = t + 6
	luaLFS:btn(3, 255, 3, 0, 0, 0, l, t, w, h, s3.." "..s3.." "..s3)
	t = t + 6
	luaLFS:btn(4, 255, 4, 0, 0, 0, l, t, w, h, s4.." "..s4.." "..s4)

	t = t - 13   -- top
	w = 6 -- widht
	h = 26  -- height
	luaLFS:btn(5, 255, 5, 0, 32, 0, l, t, w, h, "")
	l = l + 6 -- left
	luaLFS:btn(6, 255, 6, 0, 32, 0, l, t, w, h, "")
	l = l + 6 -- left
	luaLFS:btn(7, 255, 7, 0, 32, 0, l, t, w, h, "")
end
function traffic_light()
	local off = "^0"..string.char(149)
	local red = "^1"..string.char(149)
	local green = "^2"..string.char(149)
	luaLFS:mst(off.." "..off.." "..off.." "..off)
	draw_traffic_light(off, off, off, off)

	luaLFS:small(0, SMALL_NLI, 0)

	luaLFS.sleep(2)	
	luaLFS:mst(red.." "..off.." "..off.." "..off)
	draw_traffic_light(red, off, off, off)
	luaLFS.sleep(1)	
	luaLFS:mst(red.." "..red.." "..off.." "..off)
	draw_traffic_light(red, red, off, off)
	luaLFS.sleep(1)	
	luaLFS:mst(red.." "..red.." "..red.." "..off)
	draw_traffic_light(red, red, red, off)
	luaLFS.sleep(3+math.random()*5)	
	luaLFS:mst(off.." "..off.." "..off.." "..green)
	draw_traffic_light(off, off, off, green)
	luaLFS.sleep(3)

	luaLFS:small(0, SMALL_NLI, 50)

	luaLFS:bfn(0, 255, 4, 0)
	luaLFS:bfn(0, 255, 3, 0)
	luaLFS:bfn(0, 255, 2, 0)
	luaLFS:bfn(0, 255, 1, 0)
	luaLFS:bfn(0, 255, 5, 0)
	luaLFS:bfn(0, 255, 6, 0)
	luaLFS:bfn(0, 255, 7, 0)
end

function print_users(ucid)
	local d = ""
	for i = 1, (#DRAG.PLIDS) do d = d.." "..DRAG.PLIDS[i] end
	d = d.." "

	local i = 0
	for key,value in pairs(racer) do
		if (string.find(d," "..key.." ")) then
			luaLFS:btn(key, ucid, 30+i, 0, 0, 0, 75, 100+i*5, 50, 5, value)
		else
			luaLFS:btn(key, ucid, 30+i, 0, 32+8, 0, 75, 100+i*5, 50, 5, value)
		end
		i = i + 1
	end
end

function clear_menu()
	luaLFS:bfn(0, 255, 45, 0)
	luaLFS:bfn(0, 255, 46, 0)
	luaLFS:bfn(0, 255, 47, 0)
	luaLFS:bfn(0, 255, 48, 0)
	luaLFS:bfn(0, 255, 49, 0)
	local i = 0
	for key,value in pairs(racer) do
		luaLFS:bfn(0, 255, 30+i, 0)
		i = i + 1
	end
end

function draw_siren()
	for i = 1, 15, 1 do
		if i/2 == math.floor(i/2) then
			c1 = "^1"
			c2 = "^4"
		else
			c1 = "^4"
			c2 = "^1"
		end
		local l = 100 -- left
		local t = 5   -- top
		local w = 18 -- 
		local h = 17  -- 

		luaLFS:btn(1, 255, 1, 0, 0, 0, l, t, 18, 56, c1..string.char(150))
		luaLFS:btn(2, 255, 2, 0, 0, 0, l-1, t-3, 14, 48, c1..".")

		l = l+6
	
		luaLFS:btn(3, 255, 3, 0, 0, 0, l, t, 18, 56, c2..string.char(150))
		luaLFS:btn(4, 255, 4, 0, 0, 0, l+5, t-3, 14, 48, c2..".")

		luaLFS.sleep(0.5)
	end
	luaLFS:bfn(0, 255, 1, 0)
	luaLFS:bfn(0, 255, 2, 0)
	luaLFS:bfn(0, 255, 3, 0)
	luaLFS:bfn(0, 255, 4, 0)
end