import ConfigParser
import pyinsim

# Constants.
PROG_NAME = 'SpecHelper'
PROG_INAME = '^3SpecHelper'
PROG_VERSION = '0.1'
PROG_CFG = 'config.ini'

# Globals.
insim = pyinsim.InSim()
cfg = ConfigParser.ConfigParser()
showing =False
players = {}

# Load config.
with open(PROG_CFG) as f:
    cfg.readfp(f)

def versionCheck(insim, ver):
    """Check InSim version."""
    if ver['InSimVer'] == pyinsim.INSIM_VERSION:
        print 'InSim connected (LFS: %(Product)s%(Version)s InSim: %(InSimVer)d)!' % ver
    else:
        insim.close()        
        print 'Error: Invalid version, expecting version %s' % pyinsim.INSIM_VERSION
    
def playerJoined(insim, npl):
    """Add player to players dict."""
    players[npl['PLID']] = npl
    
def playerLeft(insim, pll):
    """Delete player from players dict."""
    del players[pll['PLID']]
    
def joinedMultiplayer(insim, ism):
    """Request players to be sent."""
    insim.send(pyinsim.ISP_TINY, ReqI=1, SubT=pyinsim.TINY_NPL)
    
def messageReceived(insim, mso):
    """Show and hide spectate list."""
    global showing
    cmd = pyinsim.parseCommand(mso, cfg.get('insim', 'prefix'))
    if cmd and cmd[0] == cfg.get('insim', 'command'):
        if showing:
            insim.send(pyinsim.ISP_BFN, SubT=pyinsim.BFN_CLEAR, UCID=0)
            showing = False
        else:
            top = cfg.getint('insim', 'top')
            left = cfg.getint('insim', 'left')
            clickid = 1
            insim.send(pyinsim.ISP_BTN, ReqI=255, UCID=0, ClickID=clickid, 
                       BStyle=pyinsim.ISB_DARK, T=top, L=left, W=40, H=6, 
                       Text='Spectate')
            for i in range(len(players.values())):
                npl = players.values()[i]
                top += 7
                clickid += 1
                insim.send(pyinsim.ISP_BTN, ReqI=npl['PLID'], UCID=0, 
                           ClickID=clickid, 
                           BStyle=pyinsim.ISB_LIGHT|pyinsim.ISB_CLICK, T=top, 
                           L=left, W=40, H=6, Text=npl['PName']) 
            showing = True
            
def buttonClicked(insim, btc):
    """Spectate player and delete button."""
    npl = players[btc['ReqI']]
    insim.send(pyinsim.ISP_MST, Msg='/spec %(PName)s' % npl)
    insim.send(pyinsim.ISP_MST, Msg='%(PName)s ^3spectated by admin' % npl)
    insim.send(pyinsim.ISP_BFN, SubT=pyinsim.BFN_DEL_BTN, UCID=0, 
               ClickID=btc['ClickID'])
    
def connectionLost(insim):
    """Connection has been lost."""
    print 'InSim Error: InSim connection lost'
    
def threadError(insim, err):
    """Error occured on internal receive thread."""
    print 'InSim Error:', err

# Bind events.
insim.bind(pyinsim.ISP_VER, versionCheck)
insim.bind(pyinsim.ISP_NPL, playerJoined)
insim.bind(pyinsim.ISP_PLL, playerLeft)
insim.bind(pyinsim.ISP_ISM, joinedMultiplayer)
insim.bind(pyinsim.ISP_MSO, messageReceived)
insim.bind(pyinsim.ISP_BTC, buttonClicked)
insim.bindConnectionLost(connectionLost)
insim.bindThreadError(threadError)

# Welcome message.
print PROG_NAME, PROG_VERSION
print 'Attempting to connect to InSim...'

try:
    # Connect to InSim.
    insim.connect(cfg.get('insim', 'host'), cfg.getint('insim', 'port'))
    # Initailise InSim.
    insim.send(pyinsim.ISP_ISI, Admin=cfg.get('insim', 'admin'), 
               IName=PROG_INAME, Flags=pyinsim.ISF_LOCAL, ReqI=1, 
               Prefix=cfg.get('insim', 'prefix'))
    # Request players.
    insim.send(pyinsim.ISP_TINY, ReqI=1, SubT=pyinsim.TINY_NPL)               
    insim.run()
except pyinsim.socket.error, err:
    print 'InSim Error:', err[1]



    
