import wx
import wx.lib.agw.speedmeter as sm
import math
import os
import pyinsim


HOST = 'localhost'
PORT = 30000
TIMEOUT = 10 # Seconds.


class OutGaugeApp(wx.Frame):
    def __init__(self, *args, **kwds):
        wx.Frame.__init__(self, *args, **kwds)
        
        # Setup layout
        self.CreateStatusBar()
        sizer = wx.BoxSizer()
        self.SetSizer(sizer)
        
        # Create gauges.
        self.createSpeedometer()
        sizer.Add(self.speedometer, 1, wx.EXPAND)
        self.closing = False        
        
        # Start OutGauge.
        self.og = pyinsim.OutGauge(TIMEOUT)
        self.og.bindTimeout(self.onTimeout)
        self.og.bindError(self.onError)
        self.og.bind(self.onOutGauge)
        
        try:
            self.og.connect(HOST, PORT)
        except pyinsim.socket.error, err:
            self.SetStatusText('OutGauge Error: %s' % err)
        
        # Bind window events.
        self.Bind(wx.EVT_CLOSE, self.onClose)
        
        #Show window.
        self.Center()
        self.Show()
        
    def onClose(self, evt):
        self.closing = True
        self.og.close()
        self.Destroy()
        
    def createSpeedometer(self):
        extrastyle = sm.SM_DRAW_HAND | sm.SM_DRAW_SECTORS | sm.SM_DRAW_MIDDLE_TEXT | sm.SM_DRAW_SECONDARY_TICKS        
        self.speedometer = sm.SpeedMeter(self, extrastyle=extrastyle)
        self.speedometer.SetAngleRange(-math.pi / 6, 7 * math.pi / 6)     
        intervals = range(0, 201, 20)
        self.speedometer.SetIntervals(intervals)
        colours = [wx.BLACK] * 10
        self.speedometer.SetIntervalColours(colours)
        ticks = [str(interval) for interval in intervals]
        self.speedometer.SetTicks(ticks)
        self.speedometer.SetTicksColour(wx.WHITE)
        self.speedometer.SetNumberOfSecondaryTicks(5)
        self.speedometer.SetTicksFont(wx.Font(7, wx.SWISS, wx.NORMAL, wx.NORMAL))
        self.speedometer.SetMiddleText("Km/h")
        self.speedometer.SetMiddleTextColour(wx.WHITE)
        self.speedometer.SetMiddleTextFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.BOLD))
        self.speedometer.SetHandColour(wx.Colour(255, 50, 0))
        self.speedometer.DrawExternalArc(False)        
        
    def onTimeout(self, og, timeout):
        if hasattr(self, 'closing') and not self.closing:
            og.close()        
            self.SetStatusText('OutGauge: LFS timed out')
    
    def onError(self, og, err):
        og.close()    
        self.SetStatusText('OutGauge Error: %s' % err)
        
    def onOutGauge(self, og, packet):  
        # Update the control.
        kph = pyinsim.mpsToKph(packet['Speed'])
        self.speedometer.SetSpeedValue(kph)
        
        
if __name__ == '__main__':
    app = wx.App(redirect=False)
    style = wx.DEFAULT_DIALOG_STYLE | wx.MINIMIZE_BOX
    OutGaugeApp(None, wx.ID_ANY, 'OutGauge', size=(400, 400), style=style)
    app.MainLoop()
        